# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v2_assurance_flow_summary_post200_response_client_endpoint import V2AssuranceFlowSummaryPost200ResponseClientEndpoint
from typing import Optional, Set
from typing_extensions import Self

class V2AssuranceFlowSummaryPost200Response(BaseModel):
    """
    V2AssuranceFlowSummaryPost200Response
    """ # noqa: E501
    app_name: Optional[StrictStr] = Field(default=None, alias="appName")
    bucket: Optional[StrictStr] = None
    client_endpoint: Optional[V2AssuranceFlowSummaryPost200ResponseClientEndpoint] = Field(default=None, alias="clientEndpoint")
    client_ip: Optional[StrictStr] = Field(default=None, alias="clientIp")
    first_seen_ts: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="firstSeenTs")
    lan_segment: Optional[StrictStr] = Field(default=None, alias="lanSegment")
    last_seen_ts: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="lastSeenTs")
    risk_status: Optional[StrictStr] = Field(default=None, alias="riskStatus")
    server_endpoint: Optional[V2AssuranceFlowSummaryPost200ResponseClientEndpoint] = Field(default=None, alias="serverEndpoint")
    server_ip: Optional[StrictStr] = Field(default=None, alias="serverIp")
    server_port: Optional[StrictInt] = Field(default=None, alias="serverPort")
    sla_class: Optional[StrictStr] = Field(default=None, alias="slaClass")
    __properties: ClassVar[List[str]] = ["appName", "bucket", "clientEndpoint", "clientIp", "firstSeenTs", "lanSegment", "lastSeenTs", "riskStatus", "serverEndpoint", "serverIp", "serverPort", "slaClass"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2AssuranceFlowSummaryPost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of client_endpoint
        if self.client_endpoint:
            _dict['clientEndpoint'] = self.client_endpoint.to_dict()
        # override the default output from pydantic by calling `to_dict()` of first_seen_ts
        if self.first_seen_ts:
            _dict['firstSeenTs'] = self.first_seen_ts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_seen_ts
        if self.last_seen_ts:
            _dict['lastSeenTs'] = self.last_seen_ts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of server_endpoint
        if self.server_endpoint:
            _dict['serverEndpoint'] = self.server_endpoint.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2AssuranceFlowSummaryPost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "appName": obj.get("appName"),
            "bucket": obj.get("bucket"),
            "clientEndpoint": V2AssuranceFlowSummaryPost200ResponseClientEndpoint.from_dict(obj["clientEndpoint"]) if obj.get("clientEndpoint") is not None else None,
            "clientIp": obj.get("clientIp"),
            "firstSeenTs": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["firstSeenTs"]) if obj.get("firstSeenTs") is not None else None,
            "lanSegment": obj.get("lanSegment"),
            "lastSeenTs": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["lastSeenTs"]) if obj.get("lastSeenTs") is not None else None,
            "riskStatus": obj.get("riskStatus"),
            "serverEndpoint": V2AssuranceFlowSummaryPost200ResponseClientEndpoint.from_dict(obj["serverEndpoint"]) if obj.get("serverEndpoint") is not None else None,
            "serverIp": obj.get("serverIp"),
            "serverPort": obj.get("serverPort"),
            "slaClass": obj.get("slaClass")
        })
        return _obj


