# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v2_assurance_flow_summary_post200_response_client_endpoint_edges_inner import V2AssuranceFlowSummaryPost200ResponseClientEndpointEdgesInner
from graphiant_sdk.models.v2_assurance_flow_summary_post200_response_client_endpoint_jitter import V2AssuranceFlowSummaryPost200ResponseClientEndpointJitter
from graphiant_sdk.models.v2_assurance_flow_summary_post200_response_client_endpoint_site import V2AssuranceFlowSummaryPost200ResponseClientEndpointSite
from typing import Optional, Set
from typing_extensions import Self

class V2AssuranceFlowSummaryPost200ResponseClientEndpoint(BaseModel):
    """
    V2AssuranceFlowSummaryPost200ResponseClientEndpoint
    """ # noqa: E501
    circuits: Optional[List[StrictStr]] = None
    edges: Optional[List[V2AssuranceFlowSummaryPost200ResponseClientEndpointEdgesInner]] = None
    jitter: Optional[V2AssuranceFlowSummaryPost200ResponseClientEndpointJitter] = None
    latency: Optional[V2AssuranceFlowSummaryPost200ResponseClientEndpointJitter] = None
    loss: Optional[V2AssuranceFlowSummaryPost200ResponseClientEndpointJitter] = None
    site: Optional[V2AssuranceFlowSummaryPost200ResponseClientEndpointSite] = None
    total_downlink_usage: Optional[StrictInt] = Field(default=None, alias="totalDownlinkUsage")
    total_uplink_usage: Optional[StrictInt] = Field(default=None, alias="totalUplinkUsage")
    __properties: ClassVar[List[str]] = ["circuits", "edges", "jitter", "latency", "loss", "site", "totalDownlinkUsage", "totalUplinkUsage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2AssuranceFlowSummaryPost200ResponseClientEndpoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in edges (list)
        _items = []
        if self.edges:
            for _item_edges in self.edges:
                if _item_edges:
                    _items.append(_item_edges.to_dict())
            _dict['edges'] = _items
        # override the default output from pydantic by calling `to_dict()` of jitter
        if self.jitter:
            _dict['jitter'] = self.jitter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of latency
        if self.latency:
            _dict['latency'] = self.latency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of loss
        if self.loss:
            _dict['loss'] = self.loss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict['site'] = self.site.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2AssuranceFlowSummaryPost200ResponseClientEndpoint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "circuits": obj.get("circuits"),
            "edges": [V2AssuranceFlowSummaryPost200ResponseClientEndpointEdgesInner.from_dict(_item) for _item in obj["edges"]] if obj.get("edges") is not None else None,
            "jitter": V2AssuranceFlowSummaryPost200ResponseClientEndpointJitter.from_dict(obj["jitter"]) if obj.get("jitter") is not None else None,
            "latency": V2AssuranceFlowSummaryPost200ResponseClientEndpointJitter.from_dict(obj["latency"]) if obj.get("latency") is not None else None,
            "loss": V2AssuranceFlowSummaryPost200ResponseClientEndpointJitter.from_dict(obj["loss"]) if obj.get("loss") is not None else None,
            "site": V2AssuranceFlowSummaryPost200ResponseClientEndpointSite.from_dict(obj["site"]) if obj.get("site") is not None else None,
            "totalDownlinkUsage": obj.get("totalDownlinkUsage"),
            "totalUplinkUsage": obj.get("totalUplinkUsage")
        })
        return _obj


