# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v2_assurance_flow_summary_post200_response_client_endpoint_site import V2AssuranceFlowSummaryPost200ResponseClientEndpointSite
from graphiant_sdk.models.v2_assurance_topology_inventory_post200_response_regions_inner import V2AssuranceTopologyInventoryPost200ResponseRegionsInner
from typing import Optional, Set
from typing_extensions import Self

class V2AssuranceTopologyInventoryPost200Response(BaseModel):
    """
    V2AssuranceTopologyInventoryPost200Response
    """ # noqa: E501
    app_names: Optional[List[StrictStr]] = Field(default=None, alias="appNames")
    client_sites: Optional[List[V2AssuranceFlowSummaryPost200ResponseClientEndpointSite]] = Field(default=None, alias="clientSites")
    regions: Optional[List[V2AssuranceTopologyInventoryPost200ResponseRegionsInner]] = None
    server_sites: Optional[List[V2AssuranceFlowSummaryPost200ResponseClientEndpointSite]] = Field(default=None, alias="serverSites")
    topology_change_ts: Optional[List[V1AlarmHistoryGet200ResponseHistoryInnerTime]] = Field(default=None, alias="topologyChangeTs")
    __properties: ClassVar[List[str]] = ["appNames", "clientSites", "regions", "serverSites", "topologyChangeTs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2AssuranceTopologyInventoryPost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in client_sites (list)
        _items = []
        if self.client_sites:
            for _item_client_sites in self.client_sites:
                if _item_client_sites:
                    _items.append(_item_client_sites.to_dict())
            _dict['clientSites'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in regions (list)
        _items = []
        if self.regions:
            for _item_regions in self.regions:
                if _item_regions:
                    _items.append(_item_regions.to_dict())
            _dict['regions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in server_sites (list)
        _items = []
        if self.server_sites:
            for _item_server_sites in self.server_sites:
                if _item_server_sites:
                    _items.append(_item_server_sites.to_dict())
            _dict['serverSites'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in topology_change_ts (list)
        _items = []
        if self.topology_change_ts:
            for _item_topology_change_ts in self.topology_change_ts:
                if _item_topology_change_ts:
                    _items.append(_item_topology_change_ts.to_dict())
            _dict['topologyChangeTs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2AssuranceTopologyInventoryPost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "appNames": obj.get("appNames"),
            "clientSites": [V2AssuranceFlowSummaryPost200ResponseClientEndpointSite.from_dict(_item) for _item in obj["clientSites"]] if obj.get("clientSites") is not None else None,
            "regions": [V2AssuranceTopologyInventoryPost200ResponseRegionsInner.from_dict(_item) for _item in obj["regions"]] if obj.get("regions") is not None else None,
            "serverSites": [V2AssuranceFlowSummaryPost200ResponseClientEndpointSite.from_dict(_item) for _item in obj["serverSites"]] if obj.get("serverSites") is not None else None,
            "topologyChangeTs": [V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(_item) for _item in obj["topologyChangeTs"]] if obj.get("topologyChangeTs") is not None else None
        })
        return _obj


