# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v2_assurance_topology_overview_post200_response_topology import V2AssuranceTopologyOverviewPost200ResponseTopology
from graphiant_sdk.models.v2_assurance_topology_overview_post200_response_traffic_regions_inner import V2AssuranceTopologyOverviewPost200ResponseTrafficRegionsInner
from typing import Optional, Set
from typing_extensions import Self

class V2AssuranceTopologyOverviewPost200Response(BaseModel):
    """
    V2AssuranceTopologyOverviewPost200Response
    """ # noqa: E501
    num_applications: Optional[StrictInt] = Field(default=None, alias="numApplications")
    num_flows: Optional[StrictInt] = Field(default=None, alias="numFlows")
    topology: Optional[V2AssuranceTopologyOverviewPost200ResponseTopology] = None
    topology_change_ts: Optional[List[V1AlarmHistoryGet200ResponseHistoryInnerTime]] = Field(default=None, alias="topologyChangeTs")
    traffic_regions: Optional[List[V2AssuranceTopologyOverviewPost200ResponseTrafficRegionsInner]] = Field(default=None, alias="trafficRegions")
    __properties: ClassVar[List[str]] = ["numApplications", "numFlows", "topology", "topologyChangeTs", "trafficRegions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2AssuranceTopologyOverviewPost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of topology
        if self.topology:
            _dict['topology'] = self.topology.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in topology_change_ts (list)
        _items = []
        if self.topology_change_ts:
            for _item_topology_change_ts in self.topology_change_ts:
                if _item_topology_change_ts:
                    _items.append(_item_topology_change_ts.to_dict())
            _dict['topologyChangeTs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in traffic_regions (list)
        _items = []
        if self.traffic_regions:
            for _item_traffic_regions in self.traffic_regions:
                if _item_traffic_regions:
                    _items.append(_item_traffic_regions.to_dict())
            _dict['trafficRegions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2AssuranceTopologyOverviewPost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "numApplications": obj.get("numApplications"),
            "numFlows": obj.get("numFlows"),
            "topology": V2AssuranceTopologyOverviewPost200ResponseTopology.from_dict(obj["topology"]) if obj.get("topology") is not None else None,
            "topologyChangeTs": [V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(_item) for _item in obj["topologyChangeTs"]] if obj.get("topologyChangeTs") is not None else None,
            "trafficRegions": [V2AssuranceTopologyOverviewPost200ResponseTrafficRegionsInner.from_dict(_item) for _item in obj["trafficRegions"]] if obj.get("trafficRegions") is not None else None
        })
        return _obj


