# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v2_assurance_topology_client_sessions_post_request_filter import V2AssuranceTopologyClientSessionsPostRequestFilter
from graphiant_sdk.models.v2_notificationlist_post_request_time_window import V2NotificationlistPostRequestTimeWindow
from typing import Optional, Set
from typing_extensions import Self

class V2AssuranceTopologyOverviewPostRequest(BaseModel):
    """
    V2AssuranceTopologyOverviewPostRequest
    """ # noqa: E501
    app_name: Optional[StrictStr] = Field(default=None, alias="appName")
    app_server_key: Optional[StrictStr] = Field(default=None, alias="appServerKey")
    bucket_id: Optional[StrictStr] = Field(default=None, alias="bucketId")
    filter: Optional[V2AssuranceTopologyClientSessionsPostRequestFilter] = None
    flex_algo_id: Optional[StrictInt] = Field(default=None, alias="flexAlgoId")
    slider_time_window: Optional[V2NotificationlistPostRequestTimeWindow] = Field(default=None, alias="sliderTimeWindow")
    time_window: Optional[V2NotificationlistPostRequestTimeWindow] = Field(default=None, alias="timeWindow")
    topology_ts: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="topologyTs")
    topology_type: Optional[StrictStr] = Field(default=None, alias="topologyType")
    __properties: ClassVar[List[str]] = ["appName", "appServerKey", "bucketId", "filter", "flexAlgoId", "sliderTimeWindow", "timeWindow", "topologyTs", "topologyType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2AssuranceTopologyOverviewPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of filter
        if self.filter:
            _dict['filter'] = self.filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of slider_time_window
        if self.slider_time_window:
            _dict['sliderTimeWindow'] = self.slider_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_window
        if self.time_window:
            _dict['timeWindow'] = self.time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of topology_ts
        if self.topology_ts:
            _dict['topologyTs'] = self.topology_ts.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2AssuranceTopologyOverviewPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "appName": obj.get("appName"),
            "appServerKey": obj.get("appServerKey"),
            "bucketId": obj.get("bucketId"),
            "filter": V2AssuranceTopologyClientSessionsPostRequestFilter.from_dict(obj["filter"]) if obj.get("filter") is not None else None,
            "flexAlgoId": obj.get("flexAlgoId"),
            "sliderTimeWindow": V2NotificationlistPostRequestTimeWindow.from_dict(obj["sliderTimeWindow"]) if obj.get("sliderTimeWindow") is not None else None,
            "timeWindow": V2NotificationlistPostRequestTimeWindow.from_dict(obj["timeWindow"]) if obj.get("timeWindow") is not None else None,
            "topologyTs": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["topologyTs"]) if obj.get("topologyTs") is not None else None,
            "topologyType": obj.get("topologyType")
        })
        return _obj


