# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class V2NotificationCreatePostRequestNotificationBody(BaseModel):
    """
    V2NotificationCreatePostRequestNotificationBody
    """ # noqa: E501
    description: Optional[StrictStr] = None
    duration: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    frequency: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    message_body: Optional[StrictStr] = Field(default=None, alias="messageBody")
    notification_name: Optional[StrictStr] = Field(default=None, alias="notificationName")
    opsgenie_list: Optional[List[StrictStr]] = Field(default=None, alias="opsgenieList")
    opsramp_list: Optional[List[StrictStr]] = Field(default=None, alias="opsrampList")
    recipient_list: Optional[List[StrictStr]] = Field(default=None, alias="recipientList")
    teams_list: Optional[List[StrictStr]] = Field(default=None, alias="teamsList")
    __properties: ClassVar[List[str]] = ["description", "duration", "enabled", "frequency", "messageBody", "notificationName", "opsgenieList", "opsrampList", "recipientList", "teamsList"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2NotificationCreatePostRequestNotificationBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2NotificationCreatePostRequestNotificationBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "duration": obj.get("duration"),
            "enabled": obj.get("enabled"),
            "frequency": obj.get("frequency"),
            "messageBody": obj.get("messageBody"),
            "notificationName": obj.get("notificationName"),
            "opsgenieList": obj.get("opsgenieList"),
            "opsrampList": obj.get("opsrampList"),
            "recipientList": obj.get("recipientList"),
            "teamsList": obj.get("teamsList")
        })
        return _obj


