# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v2_notification_create_post_request_notification_body import V2NotificationCreatePostRequestNotificationBody
from typing import Optional, Set
from typing_extensions import Self

class V2NotificationlistPost200ResponseNotificationListInner(BaseModel):
    """
    V2NotificationlistPost200ResponseNotificationListInner
    """ # noqa: E501
    alert_type: Optional[StrictStr] = Field(default=None, alias="alertType")
    mute_count: Optional[StrictInt] = Field(default=None, alias="muteCount")
    name: Optional[StrictStr] = None
    notification_body: Optional[V2NotificationCreatePostRequestNotificationBody] = Field(default=None, alias="notificationBody")
    notification_id: Optional[StrictStr] = Field(default=None, alias="notificationId")
    rule_id: Optional[StrictStr] = Field(default=None, alias="ruleId")
    times_triggered: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="timesTriggered")
    __properties: ClassVar[List[str]] = ["alertType", "muteCount", "name", "notificationBody", "notificationId", "ruleId", "timesTriggered"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2NotificationlistPost200ResponseNotificationListInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of notification_body
        if self.notification_body:
            _dict['notificationBody'] = self.notification_body.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2NotificationlistPost200ResponseNotificationListInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alertType": obj.get("alertType"),
            "muteCount": obj.get("muteCount"),
            "name": obj.get("name"),
            "notificationBody": V2NotificationCreatePostRequestNotificationBody.from_dict(obj["notificationBody"]) if obj.get("notificationBody") is not None else None,
            "notificationId": obj.get("notificationId"),
            "ruleId": obj.get("ruleId"),
            "timesTriggered": obj.get("timesTriggered")
        })
        return _obj


