# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metric_type_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 import_gcp_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 project_service_keys: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectServiceKeyArgs']]]] = None,
                 project_wif_configs: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectWifConfigArgs']]]] = None,
                 projects: Optional[pulumi.Input['IntegrationProjectsArgs']] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_metric_source_project_for_quota: Optional[pulumi.Input[_builtins.bool]] = None,
                 wif_splunk_identity: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workload_identity_federation_config: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.str] auth_method: Authentication method to use in this integration. If empty, Splunk Observability backend defaults to SERVICE_ACCOUNT_KEY
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_metric_type_domains: List of additional GCP service domain names that Splunk Observability Cloud will monitor. See [Custom Metric Type Domains documentation](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/#Custom-metric-type-domains)
        :param pulumi.Input[_builtins.bool] import_gcp_metrics: If enabled, Splunk Observability Cloud will sync also Google Cloud Monitoring data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] include_lists: [Compute Metadata Include List](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/).
        :param pulumi.Input[_builtins.str] name: Name of the integration.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[_builtins.int] poll_rate: GCP integration poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationProjectServiceKeyArgs']]] project_service_keys: GCP projects to add.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationProjectWifConfigArgs']]] project_wif_configs: GCP WIF configs
        :param pulumi.Input['IntegrationProjectsArgs'] projects: GCP projects configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: GCP service metrics to import. Can be an empty list, or not included, to import 'All services'. See [Google Cloud Platform services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#google-cloud-platform-services) for a list of valid values.
        :param pulumi.Input[_builtins.bool] use_metric_source_project_for_quota: When this value is set to true Observability Cloud will force usage of a quota from the project where metrics are stored. For this to work the service account provided for the project needs to be provided with serviceusage.services.use permission or Service Usage Consumer role in this project. When set to false default quota settings are used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] wif_splunk_identity: The Splunk Observability GCP identity to include in GCP WIF provider definition.
        :param pulumi.Input[_builtins.str] workload_identity_federation_config: Workload Identity Federation configuration JSON
        """
        pulumi.set(__self__, "enabled", enabled)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if custom_metric_type_domains is not None:
            pulumi.set(__self__, "custom_metric_type_domains", custom_metric_type_domains)
        if import_gcp_metrics is not None:
            pulumi.set(__self__, "import_gcp_metrics", import_gcp_metrics)
        if include_lists is not None:
            pulumi.set(__self__, "include_lists", include_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_token is not None:
            pulumi.set(__self__, "named_token", named_token)
        if poll_rate is not None:
            pulumi.set(__self__, "poll_rate", poll_rate)
        if project_service_keys is not None:
            pulumi.set(__self__, "project_service_keys", project_service_keys)
        if project_wif_configs is not None:
            pulumi.set(__self__, "project_wif_configs", project_wif_configs)
        if projects is not None:
            pulumi.set(__self__, "projects", projects)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if use_metric_source_project_for_quota is not None:
            pulumi.set(__self__, "use_metric_source_project_for_quota", use_metric_source_project_for_quota)
        if wif_splunk_identity is not None:
            pulumi.set(__self__, "wif_splunk_identity", wif_splunk_identity)
        if workload_identity_federation_config is not None:
            pulumi.set(__self__, "workload_identity_federation_config", workload_identity_federation_config)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication method to use in this integration. If empty, Splunk Observability backend defaults to SERVICE_ACCOUNT_KEY
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_method", value)

    @_builtins.property
    @pulumi.getter(name="customMetricTypeDomains")
    def custom_metric_type_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of additional GCP service domain names that Splunk Observability Cloud will monitor. See [Custom Metric Type Domains documentation](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/#Custom-metric-type-domains)
        """
        return pulumi.get(self, "custom_metric_type_domains")

    @custom_metric_type_domains.setter
    def custom_metric_type_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_metric_type_domains", value)

    @_builtins.property
    @pulumi.getter(name="importGcpMetrics")
    def import_gcp_metrics(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will sync also Google Cloud Monitoring data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        """
        return pulumi.get(self, "import_gcp_metrics")

    @import_gcp_metrics.setter
    def import_gcp_metrics(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "import_gcp_metrics", value)

    @_builtins.property
    @pulumi.getter(name="includeLists")
    def include_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        [Compute Metadata Include List](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/).
        """
        return pulumi.get(self, "include_lists")

    @include_lists.setter
    def include_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "include_lists", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namedToken")
    def named_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the org token to be used for data ingestion. If not specified then default access token is used.
        """
        return pulumi.get(self, "named_token")

    @named_token.setter
    def named_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "named_token", value)

    @_builtins.property
    @pulumi.getter(name="pollRate")
    def poll_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        GCP integration poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        """
        return pulumi.get(self, "poll_rate")

    @poll_rate.setter
    def poll_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "poll_rate", value)

    @_builtins.property
    @pulumi.getter(name="projectServiceKeys")
    def project_service_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectServiceKeyArgs']]]]:
        """
        GCP projects to add.
        """
        return pulumi.get(self, "project_service_keys")

    @project_service_keys.setter
    def project_service_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectServiceKeyArgs']]]]):
        pulumi.set(self, "project_service_keys", value)

    @_builtins.property
    @pulumi.getter(name="projectWifConfigs")
    def project_wif_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectWifConfigArgs']]]]:
        """
        GCP WIF configs
        """
        return pulumi.get(self, "project_wif_configs")

    @project_wif_configs.setter
    def project_wif_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectWifConfigArgs']]]]):
        pulumi.set(self, "project_wif_configs", value)

    @_builtins.property
    @pulumi.getter
    def projects(self) -> Optional[pulumi.Input['IntegrationProjectsArgs']]:
        """
        GCP projects configuration
        """
        return pulumi.get(self, "projects")

    @projects.setter
    def projects(self, value: Optional[pulumi.Input['IntegrationProjectsArgs']]):
        pulumi.set(self, "projects", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        GCP service metrics to import. Can be an empty list, or not included, to import 'All services'. See [Google Cloud Platform services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#google-cloud-platform-services) for a list of valid values.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter(name="useMetricSourceProjectForQuota")
    def use_metric_source_project_for_quota(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When this value is set to true Observability Cloud will force usage of a quota from the project where metrics are stored. For this to work the service account provided for the project needs to be provided with serviceusage.services.use permission or Service Usage Consumer role in this project. When set to false default quota settings are used.
        """
        return pulumi.get(self, "use_metric_source_project_for_quota")

    @use_metric_source_project_for_quota.setter
    def use_metric_source_project_for_quota(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_metric_source_project_for_quota", value)

    @_builtins.property
    @pulumi.getter(name="wifSplunkIdentity")
    def wif_splunk_identity(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The Splunk Observability GCP identity to include in GCP WIF provider definition.
        """
        return pulumi.get(self, "wif_splunk_identity")

    @wif_splunk_identity.setter
    def wif_splunk_identity(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "wif_splunk_identity", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederationConfig")
    def workload_identity_federation_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workload Identity Federation configuration JSON
        """
        return pulumi.get(self, "workload_identity_federation_config")

    @workload_identity_federation_config.setter
    def workload_identity_federation_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_identity_federation_config", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metric_type_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 import_gcp_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 project_service_keys: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectServiceKeyArgs']]]] = None,
                 project_wif_configs: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectWifConfigArgs']]]] = None,
                 projects: Optional[pulumi.Input['IntegrationProjectsArgs']] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_metric_source_project_for_quota: Optional[pulumi.Input[_builtins.bool]] = None,
                 wif_splunk_identity: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workload_identity_federation_config: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input[_builtins.str] auth_method: Authentication method to use in this integration. If empty, Splunk Observability backend defaults to SERVICE_ACCOUNT_KEY
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_metric_type_domains: List of additional GCP service domain names that Splunk Observability Cloud will monitor. See [Custom Metric Type Domains documentation](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/#Custom-metric-type-domains)
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.bool] import_gcp_metrics: If enabled, Splunk Observability Cloud will sync also Google Cloud Monitoring data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] include_lists: [Compute Metadata Include List](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/).
        :param pulumi.Input[_builtins.str] name: Name of the integration.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[_builtins.int] poll_rate: GCP integration poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationProjectServiceKeyArgs']]] project_service_keys: GCP projects to add.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationProjectWifConfigArgs']]] project_wif_configs: GCP WIF configs
        :param pulumi.Input['IntegrationProjectsArgs'] projects: GCP projects configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: GCP service metrics to import. Can be an empty list, or not included, to import 'All services'. See [Google Cloud Platform services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#google-cloud-platform-services) for a list of valid values.
        :param pulumi.Input[_builtins.bool] use_metric_source_project_for_quota: When this value is set to true Observability Cloud will force usage of a quota from the project where metrics are stored. For this to work the service account provided for the project needs to be provided with serviceusage.services.use permission or Service Usage Consumer role in this project. When set to false default quota settings are used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] wif_splunk_identity: The Splunk Observability GCP identity to include in GCP WIF provider definition.
        :param pulumi.Input[_builtins.str] workload_identity_federation_config: Workload Identity Federation configuration JSON
        """
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if custom_metric_type_domains is not None:
            pulumi.set(__self__, "custom_metric_type_domains", custom_metric_type_domains)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if import_gcp_metrics is not None:
            pulumi.set(__self__, "import_gcp_metrics", import_gcp_metrics)
        if include_lists is not None:
            pulumi.set(__self__, "include_lists", include_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_token is not None:
            pulumi.set(__self__, "named_token", named_token)
        if poll_rate is not None:
            pulumi.set(__self__, "poll_rate", poll_rate)
        if project_service_keys is not None:
            pulumi.set(__self__, "project_service_keys", project_service_keys)
        if project_wif_configs is not None:
            pulumi.set(__self__, "project_wif_configs", project_wif_configs)
        if projects is not None:
            pulumi.set(__self__, "projects", projects)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if use_metric_source_project_for_quota is not None:
            pulumi.set(__self__, "use_metric_source_project_for_quota", use_metric_source_project_for_quota)
        if wif_splunk_identity is not None:
            pulumi.set(__self__, "wif_splunk_identity", wif_splunk_identity)
        if workload_identity_federation_config is not None:
            pulumi.set(__self__, "workload_identity_federation_config", workload_identity_federation_config)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication method to use in this integration. If empty, Splunk Observability backend defaults to SERVICE_ACCOUNT_KEY
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_method", value)

    @_builtins.property
    @pulumi.getter(name="customMetricTypeDomains")
    def custom_metric_type_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of additional GCP service domain names that Splunk Observability Cloud will monitor. See [Custom Metric Type Domains documentation](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/#Custom-metric-type-domains)
        """
        return pulumi.get(self, "custom_metric_type_domains")

    @custom_metric_type_domains.setter
    def custom_metric_type_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_metric_type_domains", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="importGcpMetrics")
    def import_gcp_metrics(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will sync also Google Cloud Monitoring data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        """
        return pulumi.get(self, "import_gcp_metrics")

    @import_gcp_metrics.setter
    def import_gcp_metrics(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "import_gcp_metrics", value)

    @_builtins.property
    @pulumi.getter(name="includeLists")
    def include_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        [Compute Metadata Include List](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/).
        """
        return pulumi.get(self, "include_lists")

    @include_lists.setter
    def include_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "include_lists", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namedToken")
    def named_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the org token to be used for data ingestion. If not specified then default access token is used.
        """
        return pulumi.get(self, "named_token")

    @named_token.setter
    def named_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "named_token", value)

    @_builtins.property
    @pulumi.getter(name="pollRate")
    def poll_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        GCP integration poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        """
        return pulumi.get(self, "poll_rate")

    @poll_rate.setter
    def poll_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "poll_rate", value)

    @_builtins.property
    @pulumi.getter(name="projectServiceKeys")
    def project_service_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectServiceKeyArgs']]]]:
        """
        GCP projects to add.
        """
        return pulumi.get(self, "project_service_keys")

    @project_service_keys.setter
    def project_service_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectServiceKeyArgs']]]]):
        pulumi.set(self, "project_service_keys", value)

    @_builtins.property
    @pulumi.getter(name="projectWifConfigs")
    def project_wif_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectWifConfigArgs']]]]:
        """
        GCP WIF configs
        """
        return pulumi.get(self, "project_wif_configs")

    @project_wif_configs.setter
    def project_wif_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationProjectWifConfigArgs']]]]):
        pulumi.set(self, "project_wif_configs", value)

    @_builtins.property
    @pulumi.getter
    def projects(self) -> Optional[pulumi.Input['IntegrationProjectsArgs']]:
        """
        GCP projects configuration
        """
        return pulumi.get(self, "projects")

    @projects.setter
    def projects(self, value: Optional[pulumi.Input['IntegrationProjectsArgs']]):
        pulumi.set(self, "projects", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        GCP service metrics to import. Can be an empty list, or not included, to import 'All services'. See [Google Cloud Platform services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#google-cloud-platform-services) for a list of valid values.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter(name="useMetricSourceProjectForQuota")
    def use_metric_source_project_for_quota(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When this value is set to true Observability Cloud will force usage of a quota from the project where metrics are stored. For this to work the service account provided for the project needs to be provided with serviceusage.services.use permission or Service Usage Consumer role in this project. When set to false default quota settings are used.
        """
        return pulumi.get(self, "use_metric_source_project_for_quota")

    @use_metric_source_project_for_quota.setter
    def use_metric_source_project_for_quota(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_metric_source_project_for_quota", value)

    @_builtins.property
    @pulumi.getter(name="wifSplunkIdentity")
    def wif_splunk_identity(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The Splunk Observability GCP identity to include in GCP WIF provider definition.
        """
        return pulumi.get(self, "wif_splunk_identity")

    @wif_splunk_identity.setter
    def wif_splunk_identity(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "wif_splunk_identity", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederationConfig")
    def workload_identity_federation_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workload Identity Federation configuration JSON
        """
        return pulumi.get(self, "workload_identity_federation_config")

    @workload_identity_federation_config.setter
    def workload_identity_federation_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_identity_federation_config", value)


@pulumi.type_token("signalfx:gcp/integration:Integration")
class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metric_type_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 import_gcp_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 project_service_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationProjectServiceKeyArgs', 'IntegrationProjectServiceKeyArgsDict']]]]] = None,
                 project_wif_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationProjectWifConfigArgs', 'IntegrationProjectWifConfigArgsDict']]]]] = None,
                 projects: Optional[pulumi.Input[Union['IntegrationProjectsArgs', 'IntegrationProjectsArgsDict']]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_metric_source_project_for_quota: Optional[pulumi.Input[_builtins.bool]] = None,
                 wif_splunk_identity: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workload_identity_federation_config: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Splunk Observability Cloud GCP Integration.

        > **NOTE** When managing integrations, use a session token of an administrator to authenticate the Splunk Observability Cloud provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator). Otherwise you'll receive a 4xx error.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_method: Authentication method to use in this integration. If empty, Splunk Observability backend defaults to SERVICE_ACCOUNT_KEY
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_metric_type_domains: List of additional GCP service domain names that Splunk Observability Cloud will monitor. See [Custom Metric Type Domains documentation](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/#Custom-metric-type-domains)
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.bool] import_gcp_metrics: If enabled, Splunk Observability Cloud will sync also Google Cloud Monitoring data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] include_lists: [Compute Metadata Include List](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/).
        :param pulumi.Input[_builtins.str] name: Name of the integration.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[_builtins.int] poll_rate: GCP integration poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationProjectServiceKeyArgs', 'IntegrationProjectServiceKeyArgsDict']]]] project_service_keys: GCP projects to add.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationProjectWifConfigArgs', 'IntegrationProjectWifConfigArgsDict']]]] project_wif_configs: GCP WIF configs
        :param pulumi.Input[Union['IntegrationProjectsArgs', 'IntegrationProjectsArgsDict']] projects: GCP projects configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: GCP service metrics to import. Can be an empty list, or not included, to import 'All services'. See [Google Cloud Platform services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#google-cloud-platform-services) for a list of valid values.
        :param pulumi.Input[_builtins.bool] use_metric_source_project_for_quota: When this value is set to true Observability Cloud will force usage of a quota from the project where metrics are stored. For this to work the service account provided for the project needs to be provided with serviceusage.services.use permission or Service Usage Consumer role in this project. When set to false default quota settings are used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] wif_splunk_identity: The Splunk Observability GCP identity to include in GCP WIF provider definition.
        :param pulumi.Input[_builtins.str] workload_identity_federation_config: Workload Identity Federation configuration JSON
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Splunk Observability Cloud GCP Integration.

        > **NOTE** When managing integrations, use a session token of an administrator to authenticate the Splunk Observability Cloud provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator). Otherwise you'll receive a 4xx error.

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metric_type_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 import_gcp_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 project_service_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationProjectServiceKeyArgs', 'IntegrationProjectServiceKeyArgsDict']]]]] = None,
                 project_wif_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationProjectWifConfigArgs', 'IntegrationProjectWifConfigArgsDict']]]]] = None,
                 projects: Optional[pulumi.Input[Union['IntegrationProjectsArgs', 'IntegrationProjectsArgsDict']]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_metric_source_project_for_quota: Optional[pulumi.Input[_builtins.bool]] = None,
                 wif_splunk_identity: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workload_identity_federation_config: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            __props__.__dict__["auth_method"] = auth_method
            __props__.__dict__["custom_metric_type_domains"] = custom_metric_type_domains
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["import_gcp_metrics"] = import_gcp_metrics
            __props__.__dict__["include_lists"] = include_lists
            __props__.__dict__["name"] = name
            __props__.__dict__["named_token"] = named_token
            __props__.__dict__["poll_rate"] = poll_rate
            __props__.__dict__["project_service_keys"] = None if project_service_keys is None else pulumi.Output.secret(project_service_keys)
            __props__.__dict__["project_wif_configs"] = project_wif_configs
            __props__.__dict__["projects"] = projects
            __props__.__dict__["services"] = services
            __props__.__dict__["use_metric_source_project_for_quota"] = use_metric_source_project_for_quota
            __props__.__dict__["wif_splunk_identity"] = wif_splunk_identity
            __props__.__dict__["workload_identity_federation_config"] = workload_identity_federation_config
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["projectServiceKeys"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Integration, __self__).__init__(
            'signalfx:gcp/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_method: Optional[pulumi.Input[_builtins.str]] = None,
            custom_metric_type_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            import_gcp_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
            include_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            named_token: Optional[pulumi.Input[_builtins.str]] = None,
            poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
            project_service_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationProjectServiceKeyArgs', 'IntegrationProjectServiceKeyArgsDict']]]]] = None,
            project_wif_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationProjectWifConfigArgs', 'IntegrationProjectWifConfigArgsDict']]]]] = None,
            projects: Optional[pulumi.Input[Union['IntegrationProjectsArgs', 'IntegrationProjectsArgsDict']]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            use_metric_source_project_for_quota: Optional[pulumi.Input[_builtins.bool]] = None,
            wif_splunk_identity: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workload_identity_federation_config: Optional[pulumi.Input[_builtins.str]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_method: Authentication method to use in this integration. If empty, Splunk Observability backend defaults to SERVICE_ACCOUNT_KEY
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_metric_type_domains: List of additional GCP service domain names that Splunk Observability Cloud will monitor. See [Custom Metric Type Domains documentation](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/#Custom-metric-type-domains)
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.bool] import_gcp_metrics: If enabled, Splunk Observability Cloud will sync also Google Cloud Monitoring data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] include_lists: [Compute Metadata Include List](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/).
        :param pulumi.Input[_builtins.str] name: Name of the integration.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[_builtins.int] poll_rate: GCP integration poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationProjectServiceKeyArgs', 'IntegrationProjectServiceKeyArgsDict']]]] project_service_keys: GCP projects to add.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationProjectWifConfigArgs', 'IntegrationProjectWifConfigArgsDict']]]] project_wif_configs: GCP WIF configs
        :param pulumi.Input[Union['IntegrationProjectsArgs', 'IntegrationProjectsArgsDict']] projects: GCP projects configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: GCP service metrics to import. Can be an empty list, or not included, to import 'All services'. See [Google Cloud Platform services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#google-cloud-platform-services) for a list of valid values.
        :param pulumi.Input[_builtins.bool] use_metric_source_project_for_quota: When this value is set to true Observability Cloud will force usage of a quota from the project where metrics are stored. For this to work the service account provided for the project needs to be provided with serviceusage.services.use permission or Service Usage Consumer role in this project. When set to false default quota settings are used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] wif_splunk_identity: The Splunk Observability GCP identity to include in GCP WIF provider definition.
        :param pulumi.Input[_builtins.str] workload_identity_federation_config: Workload Identity Federation configuration JSON
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["auth_method"] = auth_method
        __props__.__dict__["custom_metric_type_domains"] = custom_metric_type_domains
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["import_gcp_metrics"] = import_gcp_metrics
        __props__.__dict__["include_lists"] = include_lists
        __props__.__dict__["name"] = name
        __props__.__dict__["named_token"] = named_token
        __props__.__dict__["poll_rate"] = poll_rate
        __props__.__dict__["project_service_keys"] = project_service_keys
        __props__.__dict__["project_wif_configs"] = project_wif_configs
        __props__.__dict__["projects"] = projects
        __props__.__dict__["services"] = services
        __props__.__dict__["use_metric_source_project_for_quota"] = use_metric_source_project_for_quota
        __props__.__dict__["wif_splunk_identity"] = wif_splunk_identity
        __props__.__dict__["workload_identity_federation_config"] = workload_identity_federation_config
        return Integration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Authentication method to use in this integration. If empty, Splunk Observability backend defaults to SERVICE_ACCOUNT_KEY
        """
        return pulumi.get(self, "auth_method")

    @_builtins.property
    @pulumi.getter(name="customMetricTypeDomains")
    def custom_metric_type_domains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of additional GCP service domain names that Splunk Observability Cloud will monitor. See [Custom Metric Type Domains documentation](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/#Custom-metric-type-domains)
        """
        return pulumi.get(self, "custom_metric_type_domains")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="importGcpMetrics")
    def import_gcp_metrics(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will sync also Google Cloud Monitoring data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        """
        return pulumi.get(self, "import_gcp_metrics")

    @_builtins.property
    @pulumi.getter(name="includeLists")
    def include_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        [Compute Metadata Include List](https://dev.splunk.com/observability/docs/integrations/gcp_integration_overview/).
        """
        return pulumi.get(self, "include_lists")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the integration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namedToken")
    def named_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the org token to be used for data ingestion. If not specified then default access token is used.
        """
        return pulumi.get(self, "named_token")

    @_builtins.property
    @pulumi.getter(name="pollRate")
    def poll_rate(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        GCP integration poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        """
        return pulumi.get(self, "poll_rate")

    @_builtins.property
    @pulumi.getter(name="projectServiceKeys")
    def project_service_keys(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationProjectServiceKey']]]:
        """
        GCP projects to add.
        """
        return pulumi.get(self, "project_service_keys")

    @_builtins.property
    @pulumi.getter(name="projectWifConfigs")
    def project_wif_configs(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationProjectWifConfig']]]:
        """
        GCP WIF configs
        """
        return pulumi.get(self, "project_wif_configs")

    @_builtins.property
    @pulumi.getter
    def projects(self) -> pulumi.Output[Optional['outputs.IntegrationProjects']]:
        """
        GCP projects configuration
        """
        return pulumi.get(self, "projects")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        GCP service metrics to import. Can be an empty list, or not included, to import 'All services'. See [Google Cloud Platform services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#google-cloud-platform-services) for a list of valid values.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter(name="useMetricSourceProjectForQuota")
    def use_metric_source_project_for_quota(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When this value is set to true Observability Cloud will force usage of a quota from the project where metrics are stored. For this to work the service account provided for the project needs to be provided with serviceusage.services.use permission or Service Usage Consumer role in this project. When set to false default quota settings are used.
        """
        return pulumi.get(self, "use_metric_source_project_for_quota")

    @_builtins.property
    @pulumi.getter(name="wifSplunkIdentity")
    def wif_splunk_identity(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The Splunk Observability GCP identity to include in GCP WIF provider definition.
        """
        return pulumi.get(self, "wif_splunk_identity")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederationConfig")
    def workload_identity_federation_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Workload Identity Federation configuration JSON
        """
        return pulumi.get(self, "workload_identity_federation_config")

