# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetKubernetesClusterResult',
    'AwaitableGetKubernetesClusterResult',
    'get_kubernetes_cluster',
    'get_kubernetes_cluster_output',
]

@pulumi.output_type
class GetKubernetesClusterResult:
    """
    A collection of values returned by getKubernetesCluster.
    """
    def __init__(__self__, client_certificate=None, client_key=None, cluster_ca_certificate=None, host=None, id=None, kubeconfig=None, name=None):
        if client_certificate and not isinstance(client_certificate, str):
            raise TypeError("Expected argument 'client_certificate' to be a str")
        pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key and not isinstance(client_key, str):
            raise TypeError("Expected argument 'client_key' to be a str")
        pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_certificate and not isinstance(cluster_ca_certificate, str):
            raise TypeError("Expected argument 'cluster_ca_certificate' to be a str")
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubeconfig and not isinstance(kubeconfig, str):
            raise TypeError("Expected argument 'kubeconfig' to be a str")
        pulumi.set(__self__, "kubeconfig", kubeconfig)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> builtins.str:
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> builtins.str:
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> builtins.str:
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kubeconfig(self) -> builtins.str:
        return pulumi.get(self, "kubeconfig")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


class AwaitableGetKubernetesClusterResult(GetKubernetesClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesClusterResult(
            client_certificate=self.client_certificate,
            client_key=self.client_key,
            cluster_ca_certificate=self.cluster_ca_certificate,
            host=self.host,
            id=self.id,
            kubeconfig=self.kubeconfig,
            name=self.name)


def get_kubernetes_cluster(id: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesClusterResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_kubernetes as kubernetes
    import pulumi_local as local
    import pulumi_upcloud as upcloud

    # Use Kubernetes provider to access your Kubernetes cluster
    # Create a network for the Kubernetes cluster
    example_network = upcloud.Network("example",
        name="example-network",
        zone="de-fra1",
        ip_network={
            "address": "172.16.1.0/24",
            "dhcp": True,
            "family": "IPv4",
        })
    # Create a Kubernetes cluster
    example_kubernetes_cluster = upcloud.KubernetesCluster("example",
        control_plane_ip_filters=["0.0.0.0/0"],
        name="exampleapp",
        network=example_network.id,
        zone="de-fra1")
    # Read the details of the newly created cluster
    example = upcloud.get_kubernetes_cluster_output(id=example_kubernetes_cluster.id)
    # Use the Kubernetes provider resources to interact with the cluster
    example_namespace = kubernetes.index.Namespace("example", metadata=[{
        name: example-namespace,
    }])
    # In addition, write the kubeconfig to a file to interact with the cluster with `kubectl` or other clients
    example_file = local.index.File("example",
        content=example.kubeconfig,
        filename=example.conf)
    ```
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('upcloud:index/getKubernetesCluster:getKubernetesCluster', __args__, opts=opts, typ=GetKubernetesClusterResult).value

    return AwaitableGetKubernetesClusterResult(
        client_certificate=pulumi.get(__ret__, 'client_certificate'),
        client_key=pulumi.get(__ret__, 'client_key'),
        cluster_ca_certificate=pulumi.get(__ret__, 'cluster_ca_certificate'),
        host=pulumi.get(__ret__, 'host'),
        id=pulumi.get(__ret__, 'id'),
        kubeconfig=pulumi.get(__ret__, 'kubeconfig'),
        name=pulumi.get(__ret__, 'name'))
def get_kubernetes_cluster_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesClusterResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_kubernetes as kubernetes
    import pulumi_local as local
    import pulumi_upcloud as upcloud

    # Use Kubernetes provider to access your Kubernetes cluster
    # Create a network for the Kubernetes cluster
    example_network = upcloud.Network("example",
        name="example-network",
        zone="de-fra1",
        ip_network={
            "address": "172.16.1.0/24",
            "dhcp": True,
            "family": "IPv4",
        })
    # Create a Kubernetes cluster
    example_kubernetes_cluster = upcloud.KubernetesCluster("example",
        control_plane_ip_filters=["0.0.0.0/0"],
        name="exampleapp",
        network=example_network.id,
        zone="de-fra1")
    # Read the details of the newly created cluster
    example = upcloud.get_kubernetes_cluster_output(id=example_kubernetes_cluster.id)
    # Use the Kubernetes provider resources to interact with the cluster
    example_namespace = kubernetes.index.Namespace("example", metadata=[{
        name: example-namespace,
    }])
    # In addition, write the kubeconfig to a file to interact with the cluster with `kubectl` or other clients
    example_file = local.index.File("example",
        content=example.kubeconfig,
        filename=example.conf)
    ```
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('upcloud:index/getKubernetesCluster:getKubernetesCluster', __args__, opts=opts, typ=GetKubernetesClusterResult)
    return __ret__.apply(lambda __response__: GetKubernetesClusterResult(
        client_certificate=pulumi.get(__response__, 'client_certificate'),
        client_key=pulumi.get(__response__, 'client_key'),
        cluster_ca_certificate=pulumi.get(__response__, 'cluster_ca_certificate'),
        host=pulumi.get(__response__, 'host'),
        id=pulumi.get(__response__, 'id'),
        kubeconfig=pulumi.get(__response__, 'kubeconfig'),
        name=pulumi.get(__response__, 'name')))
