# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetStorageResult',
    'AwaitableGetStorageResult',
    'get_storage',
    'get_storage_output',
]

@pulumi.output_type
class GetStorageResult:
    """
    A collection of values returned by getStorage.
    """
    def __init__(__self__, access_type=None, encrypt=None, id=None, labels=None, most_recent=None, name=None, name_regex=None, size=None, state=None, system_labels=None, tier=None, title=None, type=None, zone=None):
        if access_type and not isinstance(access_type, str):
            raise TypeError("Expected argument 'access_type' to be a str")
        pulumi.set(__self__, "access_type", access_type)
        if encrypt and not isinstance(encrypt, bool):
            raise TypeError("Expected argument 'encrypt' to be a bool")
        pulumi.set(__self__, "encrypt", encrypt)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if most_recent and not isinstance(most_recent, bool):
            raise TypeError("Expected argument 'most_recent' to be a bool")
        pulumi.set(__self__, "most_recent", most_recent)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_labels and not isinstance(system_labels, dict):
            raise TypeError("Expected argument 'system_labels' to be a dict")
        pulumi.set(__self__, "system_labels", system_labels)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> builtins.str:
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter
    def encrypt(self) -> builtins.bool:
        return pulumi.get(self, "encrypt")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="mostRecent")
    @_utilities.deprecated("""Use exact title or UUID to limit the number of matching storages. Note that if you have multiple storages with the same title, you should use UUID to select the storage.""")
    def most_recent(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "most_recent")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Contains the same value as `title`. Use `title` instead.""")
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameRegex")
    @_utilities.deprecated("""Use exact title or UUID instead.""")
    def name_regex(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemLabels")
    def system_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "system_labels")

    @property
    @pulumi.getter
    def tier(self) -> builtins.str:
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        return pulumi.get(self, "zone")


class AwaitableGetStorageResult(GetStorageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageResult(
            access_type=self.access_type,
            encrypt=self.encrypt,
            id=self.id,
            labels=self.labels,
            most_recent=self.most_recent,
            name=self.name,
            name_regex=self.name_regex,
            size=self.size,
            state=self.state,
            system_labels=self.system_labels,
            tier=self.tier,
            title=self.title,
            type=self.type,
            zone=self.zone)


def get_storage(access_type: Optional[builtins.str] = None,
                id: Optional[builtins.str] = None,
                most_recent: Optional[builtins.bool] = None,
                name: Optional[builtins.str] = None,
                name_regex: Optional[builtins.str] = None,
                title: Optional[builtins.str] = None,
                type: Optional[builtins.str] = None,
                zone: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageResult:
    """
    Provides information on UpCloud [Block Storage](https://upcloud.com/products/block-storage) devices.

    Data source can be used to map storage to other resource based on the ID or just to read some other storage property like zone information. Storage types are: `normal`, `backup`, `cdrom`, and `template`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_upcloud as upcloud

    # Build server with your latest custom image 
    #
    # Note that when applied new updated image will cause replacement of the old server (debian.example.tld) 
    # with the new server created based on the updated image.This can cause posible data loss 
    # if it hasn't been taken into account when planning the service.
    app_image = upcloud.get_storage(type="template",
        name_regex="^app_image.*",
        most_recent=True)
    example = upcloud.Server("example",
        hostname="debian.example.tld",
        zone="fi-hel1",
        network_interfaces=[{
            "type": "public",
        }],
        template={
            "storage": app_image.id,
        })
    # Build only new servers with your latest custom image 
    #
    # Use the lifecycle meta-argument to ignore changes in server's template triggered by new image version
    example2 = upcloud.Server("example2",
        hostname="debian.example2.tld",
        zone="fi-hel1",
        network_interfaces=[{
            "type": "public",
        }],
        template={
            "storage": app_image.id,
        })
    ```
    """
    __args__ = dict()
    __args__['accessType'] = access_type
    __args__['id'] = id
    __args__['mostRecent'] = most_recent
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['title'] = title
    __args__['type'] = type
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('upcloud:index/getStorage:getStorage', __args__, opts=opts, typ=GetStorageResult).value

    return AwaitableGetStorageResult(
        access_type=pulumi.get(__ret__, 'access_type'),
        encrypt=pulumi.get(__ret__, 'encrypt'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        most_recent=pulumi.get(__ret__, 'most_recent'),
        name=pulumi.get(__ret__, 'name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        size=pulumi.get(__ret__, 'size'),
        state=pulumi.get(__ret__, 'state'),
        system_labels=pulumi.get(__ret__, 'system_labels'),
        tier=pulumi.get(__ret__, 'tier'),
        title=pulumi.get(__ret__, 'title'),
        type=pulumi.get(__ret__, 'type'),
        zone=pulumi.get(__ret__, 'zone'))
def get_storage_output(access_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       most_recent: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                       name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       name_regex: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       title: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStorageResult]:
    """
    Provides information on UpCloud [Block Storage](https://upcloud.com/products/block-storage) devices.

    Data source can be used to map storage to other resource based on the ID or just to read some other storage property like zone information. Storage types are: `normal`, `backup`, `cdrom`, and `template`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_upcloud as upcloud

    # Build server with your latest custom image 
    #
    # Note that when applied new updated image will cause replacement of the old server (debian.example.tld) 
    # with the new server created based on the updated image.This can cause posible data loss 
    # if it hasn't been taken into account when planning the service.
    app_image = upcloud.get_storage(type="template",
        name_regex="^app_image.*",
        most_recent=True)
    example = upcloud.Server("example",
        hostname="debian.example.tld",
        zone="fi-hel1",
        network_interfaces=[{
            "type": "public",
        }],
        template={
            "storage": app_image.id,
        })
    # Build only new servers with your latest custom image 
    #
    # Use the lifecycle meta-argument to ignore changes in server's template triggered by new image version
    example2 = upcloud.Server("example2",
        hostname="debian.example2.tld",
        zone="fi-hel1",
        network_interfaces=[{
            "type": "public",
        }],
        template={
            "storage": app_image.id,
        })
    ```
    """
    __args__ = dict()
    __args__['accessType'] = access_type
    __args__['id'] = id
    __args__['mostRecent'] = most_recent
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['title'] = title
    __args__['type'] = type
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('upcloud:index/getStorage:getStorage', __args__, opts=opts, typ=GetStorageResult)
    return __ret__.apply(lambda __response__: GetStorageResult(
        access_type=pulumi.get(__response__, 'access_type'),
        encrypt=pulumi.get(__response__, 'encrypt'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        most_recent=pulumi.get(__response__, 'most_recent'),
        name=pulumi.get(__response__, 'name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        size=pulumi.get(__response__, 'size'),
        state=pulumi.get(__response__, 'state'),
        system_labels=pulumi.get(__response__, 'system_labels'),
        tier=pulumi.get(__response__, 'tier'),
        title=pulumi.get(__response__, 'title'),
        type=pulumi.get(__response__, 'type'),
        zone=pulumi.get(__response__, 'zone')))
