# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesNodeGroupArgs', 'KubernetesNodeGroup']

@pulumi.input_type
class KubernetesNodeGroupArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[builtins.str],
                 node_count: pulumi.Input[builtins.int],
                 plan: pulumi.Input[builtins.str],
                 anti_affinity: Optional[pulumi.Input[builtins.bool]] = None,
                 cloud_native_plan: Optional[pulumi.Input['KubernetesNodeGroupCloudNativePlanArgs']] = None,
                 custom_plan: Optional[pulumi.Input['KubernetesNodeGroupCustomPlanArgs']] = None,
                 gpu_plan: Optional[pulumi.Input['KubernetesNodeGroupGpuPlanArgs']] = None,
                 kubelet_args: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupKubeletArgArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 storage_encryption: Optional[pulumi.Input[builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupTaintArgs']]]] = None,
                 utility_network_access: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a KubernetesNodeGroup resource.
        :param pulumi.Input[builtins.str] cluster: UUID of the cluster.
        :param pulumi.Input[builtins.int] node_count: Amount of nodes to provision in the node group.
        :param pulumi.Input[builtins.str] plan: The server plan used for the node group. You can list available plans with `upctl server plans`
        :param pulumi.Input[builtins.bool] anti_affinity: If set to true, nodes in this group will be placed on separate compute hosts. Please note that anti-affinity policy is
               considered 'best effort' and enabling it does not fully guarantee that the nodes will end up on different hardware.
        :param pulumi.Input['KubernetesNodeGroupCloudNativePlanArgs'] cloud_native_plan: Resource properties for Cloud Native plan storage configuration. This block is optional for Cloud Native plans.
        :param pulumi.Input['KubernetesNodeGroupCustomPlanArgs'] custom_plan: Resource properties for custom plan. This block is required for `custom` plans only.
        :param pulumi.Input['KubernetesNodeGroupGpuPlanArgs'] gpu_plan: Resource properties for GPU plan storage configuration. This block is optional for GPU plans.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupKubeletArgArgs']]] kubelet_args: Additional arguments for kubelet for the nodes in this group. Configure the arguments without leading `--`. The API will
               prefix the arguments with `--` when preparing kubelet call. Note that these arguments will be passed directly to kubelet
               CLI on each worker node without any validation. Passing invalid arguments can break your whole cluster. Be extra careful
               when adding kubelet args.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User defined key-value pairs to classify the node_group.
        :param pulumi.Input[builtins.str] name: The name of the node group. Needs to be unique within a cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssh_keys: You can optionally select SSH keys to be added as authorized keys to the nodes in this node group. This allows you to
               connect to the nodes via SSH once they are running.
        :param pulumi.Input[builtins.str] storage_encryption: The storage encryption strategy to use for the nodes in this group. If not set, the cluster's storage encryption
               strategy will be used, if applicable.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupTaintArgs']]] taints: Taints for the nodes in this group.
        :param pulumi.Input[builtins.bool] utility_network_access: If set to false, nodes in this group will not have access to utility network.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "plan", plan)
        if anti_affinity is not None:
            pulumi.set(__self__, "anti_affinity", anti_affinity)
        if cloud_native_plan is not None:
            pulumi.set(__self__, "cloud_native_plan", cloud_native_plan)
        if custom_plan is not None:
            pulumi.set(__self__, "custom_plan", custom_plan)
        if gpu_plan is not None:
            pulumi.set(__self__, "gpu_plan", gpu_plan)
        if kubelet_args is not None:
            pulumi.set(__self__, "kubelet_args", kubelet_args)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)
        if storage_encryption is not None:
            pulumi.set(__self__, "storage_encryption", storage_encryption)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if utility_network_access is not None:
            pulumi.set(__self__, "utility_network_access", utility_network_access)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[builtins.str]:
        """
        UUID of the cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[builtins.int]:
        """
        Amount of nodes to provision in the node group.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input[builtins.str]:
        """
        The server plan used for the node group. You can list available plans with `upctl server plans`
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, nodes in this group will be placed on separate compute hosts. Please note that anti-affinity policy is
        considered 'best effort' and enabling it does not fully guarantee that the nodes will end up on different hardware.
        """
        return pulumi.get(self, "anti_affinity")

    @anti_affinity.setter
    def anti_affinity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "anti_affinity", value)

    @property
    @pulumi.getter(name="cloudNativePlan")
    def cloud_native_plan(self) -> Optional[pulumi.Input['KubernetesNodeGroupCloudNativePlanArgs']]:
        """
        Resource properties for Cloud Native plan storage configuration. This block is optional for Cloud Native plans.
        """
        return pulumi.get(self, "cloud_native_plan")

    @cloud_native_plan.setter
    def cloud_native_plan(self, value: Optional[pulumi.Input['KubernetesNodeGroupCloudNativePlanArgs']]):
        pulumi.set(self, "cloud_native_plan", value)

    @property
    @pulumi.getter(name="customPlan")
    def custom_plan(self) -> Optional[pulumi.Input['KubernetesNodeGroupCustomPlanArgs']]:
        """
        Resource properties for custom plan. This block is required for `custom` plans only.
        """
        return pulumi.get(self, "custom_plan")

    @custom_plan.setter
    def custom_plan(self, value: Optional[pulumi.Input['KubernetesNodeGroupCustomPlanArgs']]):
        pulumi.set(self, "custom_plan", value)

    @property
    @pulumi.getter(name="gpuPlan")
    def gpu_plan(self) -> Optional[pulumi.Input['KubernetesNodeGroupGpuPlanArgs']]:
        """
        Resource properties for GPU plan storage configuration. This block is optional for GPU plans.
        """
        return pulumi.get(self, "gpu_plan")

    @gpu_plan.setter
    def gpu_plan(self, value: Optional[pulumi.Input['KubernetesNodeGroupGpuPlanArgs']]):
        pulumi.set(self, "gpu_plan", value)

    @property
    @pulumi.getter(name="kubeletArgs")
    def kubelet_args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupKubeletArgArgs']]]]:
        """
        Additional arguments for kubelet for the nodes in this group. Configure the arguments without leading `--`. The API will
        prefix the arguments with `--` when preparing kubelet call. Note that these arguments will be passed directly to kubelet
        CLI on each worker node without any validation. Passing invalid arguments can break your whole cluster. Be extra careful
        when adding kubelet args.
        """
        return pulumi.get(self, "kubelet_args")

    @kubelet_args.setter
    def kubelet_args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupKubeletArgArgs']]]]):
        pulumi.set(self, "kubelet_args", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User defined key-value pairs to classify the node_group.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the node group. Needs to be unique within a cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        You can optionally select SSH keys to be added as authorized keys to the nodes in this node group. This allows you to
        connect to the nodes via SSH once they are running.
        """
        return pulumi.get(self, "ssh_keys")

    @ssh_keys.setter
    def ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ssh_keys", value)

    @property
    @pulumi.getter(name="storageEncryption")
    def storage_encryption(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage encryption strategy to use for the nodes in this group. If not set, the cluster's storage encryption
        strategy will be used, if applicable.
        """
        return pulumi.get(self, "storage_encryption")

    @storage_encryption.setter
    def storage_encryption(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_encryption", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupTaintArgs']]]]:
        """
        Taints for the nodes in this group.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="utilityNetworkAccess")
    def utility_network_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to false, nodes in this group will not have access to utility network.
        """
        return pulumi.get(self, "utility_network_access")

    @utility_network_access.setter
    def utility_network_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "utility_network_access", value)


@pulumi.input_type
class _KubernetesNodeGroupState:
    def __init__(__self__, *,
                 anti_affinity: Optional[pulumi.Input[builtins.bool]] = None,
                 cloud_native_plan: Optional[pulumi.Input['KubernetesNodeGroupCloudNativePlanArgs']] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 custom_plan: Optional[pulumi.Input['KubernetesNodeGroupCustomPlanArgs']] = None,
                 gpu_plan: Optional[pulumi.Input['KubernetesNodeGroupGpuPlanArgs']] = None,
                 kubelet_args: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupKubeletArgArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 storage_encryption: Optional[pulumi.Input[builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupTaintArgs']]]] = None,
                 utility_network_access: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering KubernetesNodeGroup resources.
        :param pulumi.Input[builtins.bool] anti_affinity: If set to true, nodes in this group will be placed on separate compute hosts. Please note that anti-affinity policy is
               considered 'best effort' and enabling it does not fully guarantee that the nodes will end up on different hardware.
        :param pulumi.Input['KubernetesNodeGroupCloudNativePlanArgs'] cloud_native_plan: Resource properties for Cloud Native plan storage configuration. This block is optional for Cloud Native plans.
        :param pulumi.Input[builtins.str] cluster: UUID of the cluster.
        :param pulumi.Input['KubernetesNodeGroupCustomPlanArgs'] custom_plan: Resource properties for custom plan. This block is required for `custom` plans only.
        :param pulumi.Input['KubernetesNodeGroupGpuPlanArgs'] gpu_plan: Resource properties for GPU plan storage configuration. This block is optional for GPU plans.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupKubeletArgArgs']]] kubelet_args: Additional arguments for kubelet for the nodes in this group. Configure the arguments without leading `--`. The API will
               prefix the arguments with `--` when preparing kubelet call. Note that these arguments will be passed directly to kubelet
               CLI on each worker node without any validation. Passing invalid arguments can break your whole cluster. Be extra careful
               when adding kubelet args.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User defined key-value pairs to classify the node_group.
        :param pulumi.Input[builtins.str] name: The name of the node group. Needs to be unique within a cluster.
        :param pulumi.Input[builtins.int] node_count: Amount of nodes to provision in the node group.
        :param pulumi.Input[builtins.str] plan: The server plan used for the node group. You can list available plans with `upctl server plans`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssh_keys: You can optionally select SSH keys to be added as authorized keys to the nodes in this node group. This allows you to
               connect to the nodes via SSH once they are running.
        :param pulumi.Input[builtins.str] storage_encryption: The storage encryption strategy to use for the nodes in this group. If not set, the cluster's storage encryption
               strategy will be used, if applicable.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupTaintArgs']]] taints: Taints for the nodes in this group.
        :param pulumi.Input[builtins.bool] utility_network_access: If set to false, nodes in this group will not have access to utility network.
        """
        if anti_affinity is not None:
            pulumi.set(__self__, "anti_affinity", anti_affinity)
        if cloud_native_plan is not None:
            pulumi.set(__self__, "cloud_native_plan", cloud_native_plan)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if custom_plan is not None:
            pulumi.set(__self__, "custom_plan", custom_plan)
        if gpu_plan is not None:
            pulumi.set(__self__, "gpu_plan", gpu_plan)
        if kubelet_args is not None:
            pulumi.set(__self__, "kubelet_args", kubelet_args)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)
        if storage_encryption is not None:
            pulumi.set(__self__, "storage_encryption", storage_encryption)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if utility_network_access is not None:
            pulumi.set(__self__, "utility_network_access", utility_network_access)

    @property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, nodes in this group will be placed on separate compute hosts. Please note that anti-affinity policy is
        considered 'best effort' and enabling it does not fully guarantee that the nodes will end up on different hardware.
        """
        return pulumi.get(self, "anti_affinity")

    @anti_affinity.setter
    def anti_affinity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "anti_affinity", value)

    @property
    @pulumi.getter(name="cloudNativePlan")
    def cloud_native_plan(self) -> Optional[pulumi.Input['KubernetesNodeGroupCloudNativePlanArgs']]:
        """
        Resource properties for Cloud Native plan storage configuration. This block is optional for Cloud Native plans.
        """
        return pulumi.get(self, "cloud_native_plan")

    @cloud_native_plan.setter
    def cloud_native_plan(self, value: Optional[pulumi.Input['KubernetesNodeGroupCloudNativePlanArgs']]):
        pulumi.set(self, "cloud_native_plan", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID of the cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="customPlan")
    def custom_plan(self) -> Optional[pulumi.Input['KubernetesNodeGroupCustomPlanArgs']]:
        """
        Resource properties for custom plan. This block is required for `custom` plans only.
        """
        return pulumi.get(self, "custom_plan")

    @custom_plan.setter
    def custom_plan(self, value: Optional[pulumi.Input['KubernetesNodeGroupCustomPlanArgs']]):
        pulumi.set(self, "custom_plan", value)

    @property
    @pulumi.getter(name="gpuPlan")
    def gpu_plan(self) -> Optional[pulumi.Input['KubernetesNodeGroupGpuPlanArgs']]:
        """
        Resource properties for GPU plan storage configuration. This block is optional for GPU plans.
        """
        return pulumi.get(self, "gpu_plan")

    @gpu_plan.setter
    def gpu_plan(self, value: Optional[pulumi.Input['KubernetesNodeGroupGpuPlanArgs']]):
        pulumi.set(self, "gpu_plan", value)

    @property
    @pulumi.getter(name="kubeletArgs")
    def kubelet_args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupKubeletArgArgs']]]]:
        """
        Additional arguments for kubelet for the nodes in this group. Configure the arguments without leading `--`. The API will
        prefix the arguments with `--` when preparing kubelet call. Note that these arguments will be passed directly to kubelet
        CLI on each worker node without any validation. Passing invalid arguments can break your whole cluster. Be extra careful
        when adding kubelet args.
        """
        return pulumi.get(self, "kubelet_args")

    @kubelet_args.setter
    def kubelet_args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupKubeletArgArgs']]]]):
        pulumi.set(self, "kubelet_args", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User defined key-value pairs to classify the node_group.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the node group. Needs to be unique within a cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of nodes to provision in the node group.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The server plan used for the node group. You can list available plans with `upctl server plans`
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        You can optionally select SSH keys to be added as authorized keys to the nodes in this node group. This allows you to
        connect to the nodes via SSH once they are running.
        """
        return pulumi.get(self, "ssh_keys")

    @ssh_keys.setter
    def ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ssh_keys", value)

    @property
    @pulumi.getter(name="storageEncryption")
    def storage_encryption(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage encryption strategy to use for the nodes in this group. If not set, the cluster's storage encryption
        strategy will be used, if applicable.
        """
        return pulumi.get(self, "storage_encryption")

    @storage_encryption.setter
    def storage_encryption(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_encryption", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupTaintArgs']]]]:
        """
        Taints for the nodes in this group.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="utilityNetworkAccess")
    def utility_network_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to false, nodes in this group will not have access to utility network.
        """
        return pulumi.get(self, "utility_network_access")

    @utility_network_access.setter
    def utility_network_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "utility_network_access", value)


class KubernetesNodeGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anti_affinity: Optional[pulumi.Input[builtins.bool]] = None,
                 cloud_native_plan: Optional[pulumi.Input[Union['KubernetesNodeGroupCloudNativePlanArgs', 'KubernetesNodeGroupCloudNativePlanArgsDict']]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 custom_plan: Optional[pulumi.Input[Union['KubernetesNodeGroupCustomPlanArgs', 'KubernetesNodeGroupCustomPlanArgsDict']]] = None,
                 gpu_plan: Optional[pulumi.Input[Union['KubernetesNodeGroupGpuPlanArgs', 'KubernetesNodeGroupGpuPlanArgsDict']]] = None,
                 kubelet_args: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupKubeletArgArgs', 'KubernetesNodeGroupKubeletArgArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 storage_encryption: Optional[pulumi.Input[builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupTaintArgs', 'KubernetesNodeGroupTaintArgsDict']]]]] = None,
                 utility_network_access: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource represents a [Managed Kubernetes](https://upcloud.com/products/managed-kubernetes) cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Create a network for the Kubernetes cluster
        example = upcloud.Network("example",
            name="example-network",
            zone="de-fra1",
            ip_network={
                "address": "172.16.1.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        # Create a Kubernetes cluster
        example_kubernetes_cluster = upcloud.KubernetesCluster("example",
            control_plane_ip_filters=["0.0.0.0/0"],
            name="exampleapp",
            network=example.id,
            zone="de-fra1")
        # Create a Kubernetes cluster node group
        group = upcloud.KubernetesNodeGroup("group",
            cluster=upcloud_kubernetes_cluster["example"]["id"],
            node_count=2,
            name="medium",
            plan="2xCPU-4GB",
            labels={
                "managedBy": "terraform",
            },
            taints=[{
                "effect": "NoExecute",
                "key": "taintKey",
                "value": "taintValue",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] anti_affinity: If set to true, nodes in this group will be placed on separate compute hosts. Please note that anti-affinity policy is
               considered 'best effort' and enabling it does not fully guarantee that the nodes will end up on different hardware.
        :param pulumi.Input[Union['KubernetesNodeGroupCloudNativePlanArgs', 'KubernetesNodeGroupCloudNativePlanArgsDict']] cloud_native_plan: Resource properties for Cloud Native plan storage configuration. This block is optional for Cloud Native plans.
        :param pulumi.Input[builtins.str] cluster: UUID of the cluster.
        :param pulumi.Input[Union['KubernetesNodeGroupCustomPlanArgs', 'KubernetesNodeGroupCustomPlanArgsDict']] custom_plan: Resource properties for custom plan. This block is required for `custom` plans only.
        :param pulumi.Input[Union['KubernetesNodeGroupGpuPlanArgs', 'KubernetesNodeGroupGpuPlanArgsDict']] gpu_plan: Resource properties for GPU plan storage configuration. This block is optional for GPU plans.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupKubeletArgArgs', 'KubernetesNodeGroupKubeletArgArgsDict']]]] kubelet_args: Additional arguments for kubelet for the nodes in this group. Configure the arguments without leading `--`. The API will
               prefix the arguments with `--` when preparing kubelet call. Note that these arguments will be passed directly to kubelet
               CLI on each worker node without any validation. Passing invalid arguments can break your whole cluster. Be extra careful
               when adding kubelet args.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User defined key-value pairs to classify the node_group.
        :param pulumi.Input[builtins.str] name: The name of the node group. Needs to be unique within a cluster.
        :param pulumi.Input[builtins.int] node_count: Amount of nodes to provision in the node group.
        :param pulumi.Input[builtins.str] plan: The server plan used for the node group. You can list available plans with `upctl server plans`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssh_keys: You can optionally select SSH keys to be added as authorized keys to the nodes in this node group. This allows you to
               connect to the nodes via SSH once they are running.
        :param pulumi.Input[builtins.str] storage_encryption: The storage encryption strategy to use for the nodes in this group. If not set, the cluster's storage encryption
               strategy will be used, if applicable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupTaintArgs', 'KubernetesNodeGroupTaintArgsDict']]]] taints: Taints for the nodes in this group.
        :param pulumi.Input[builtins.bool] utility_network_access: If set to false, nodes in this group will not have access to utility network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesNodeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents a [Managed Kubernetes](https://upcloud.com/products/managed-kubernetes) cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Create a network for the Kubernetes cluster
        example = upcloud.Network("example",
            name="example-network",
            zone="de-fra1",
            ip_network={
                "address": "172.16.1.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        # Create a Kubernetes cluster
        example_kubernetes_cluster = upcloud.KubernetesCluster("example",
            control_plane_ip_filters=["0.0.0.0/0"],
            name="exampleapp",
            network=example.id,
            zone="de-fra1")
        # Create a Kubernetes cluster node group
        group = upcloud.KubernetesNodeGroup("group",
            cluster=upcloud_kubernetes_cluster["example"]["id"],
            node_count=2,
            name="medium",
            plan="2xCPU-4GB",
            labels={
                "managedBy": "terraform",
            },
            taints=[{
                "effect": "NoExecute",
                "key": "taintKey",
                "value": "taintValue",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesNodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesNodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anti_affinity: Optional[pulumi.Input[builtins.bool]] = None,
                 cloud_native_plan: Optional[pulumi.Input[Union['KubernetesNodeGroupCloudNativePlanArgs', 'KubernetesNodeGroupCloudNativePlanArgsDict']]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 custom_plan: Optional[pulumi.Input[Union['KubernetesNodeGroupCustomPlanArgs', 'KubernetesNodeGroupCustomPlanArgsDict']]] = None,
                 gpu_plan: Optional[pulumi.Input[Union['KubernetesNodeGroupGpuPlanArgs', 'KubernetesNodeGroupGpuPlanArgsDict']]] = None,
                 kubelet_args: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupKubeletArgArgs', 'KubernetesNodeGroupKubeletArgArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 storage_encryption: Optional[pulumi.Input[builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupTaintArgs', 'KubernetesNodeGroupTaintArgsDict']]]]] = None,
                 utility_network_access: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesNodeGroupArgs.__new__(KubernetesNodeGroupArgs)

            __props__.__dict__["anti_affinity"] = anti_affinity
            __props__.__dict__["cloud_native_plan"] = cloud_native_plan
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["custom_plan"] = custom_plan
            __props__.__dict__["gpu_plan"] = gpu_plan
            __props__.__dict__["kubelet_args"] = kubelet_args
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if node_count is None and not opts.urn:
                raise TypeError("Missing required property 'node_count'")
            __props__.__dict__["node_count"] = node_count
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            __props__.__dict__["ssh_keys"] = ssh_keys
            __props__.__dict__["storage_encryption"] = storage_encryption
            __props__.__dict__["taints"] = taints
            __props__.__dict__["utility_network_access"] = utility_network_access
        super(KubernetesNodeGroup, __self__).__init__(
            'upcloud:index/kubernetesNodeGroup:KubernetesNodeGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anti_affinity: Optional[pulumi.Input[builtins.bool]] = None,
            cloud_native_plan: Optional[pulumi.Input[Union['KubernetesNodeGroupCloudNativePlanArgs', 'KubernetesNodeGroupCloudNativePlanArgsDict']]] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            custom_plan: Optional[pulumi.Input[Union['KubernetesNodeGroupCustomPlanArgs', 'KubernetesNodeGroupCustomPlanArgsDict']]] = None,
            gpu_plan: Optional[pulumi.Input[Union['KubernetesNodeGroupGpuPlanArgs', 'KubernetesNodeGroupGpuPlanArgsDict']]] = None,
            kubelet_args: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupKubeletArgArgs', 'KubernetesNodeGroupKubeletArgArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_count: Optional[pulumi.Input[builtins.int]] = None,
            plan: Optional[pulumi.Input[builtins.str]] = None,
            ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            storage_encryption: Optional[pulumi.Input[builtins.str]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupTaintArgs', 'KubernetesNodeGroupTaintArgsDict']]]]] = None,
            utility_network_access: Optional[pulumi.Input[builtins.bool]] = None) -> 'KubernetesNodeGroup':
        """
        Get an existing KubernetesNodeGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] anti_affinity: If set to true, nodes in this group will be placed on separate compute hosts. Please note that anti-affinity policy is
               considered 'best effort' and enabling it does not fully guarantee that the nodes will end up on different hardware.
        :param pulumi.Input[Union['KubernetesNodeGroupCloudNativePlanArgs', 'KubernetesNodeGroupCloudNativePlanArgsDict']] cloud_native_plan: Resource properties for Cloud Native plan storage configuration. This block is optional for Cloud Native plans.
        :param pulumi.Input[builtins.str] cluster: UUID of the cluster.
        :param pulumi.Input[Union['KubernetesNodeGroupCustomPlanArgs', 'KubernetesNodeGroupCustomPlanArgsDict']] custom_plan: Resource properties for custom plan. This block is required for `custom` plans only.
        :param pulumi.Input[Union['KubernetesNodeGroupGpuPlanArgs', 'KubernetesNodeGroupGpuPlanArgsDict']] gpu_plan: Resource properties for GPU plan storage configuration. This block is optional for GPU plans.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupKubeletArgArgs', 'KubernetesNodeGroupKubeletArgArgsDict']]]] kubelet_args: Additional arguments for kubelet for the nodes in this group. Configure the arguments without leading `--`. The API will
               prefix the arguments with `--` when preparing kubelet call. Note that these arguments will be passed directly to kubelet
               CLI on each worker node without any validation. Passing invalid arguments can break your whole cluster. Be extra careful
               when adding kubelet args.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User defined key-value pairs to classify the node_group.
        :param pulumi.Input[builtins.str] name: The name of the node group. Needs to be unique within a cluster.
        :param pulumi.Input[builtins.int] node_count: Amount of nodes to provision in the node group.
        :param pulumi.Input[builtins.str] plan: The server plan used for the node group. You can list available plans with `upctl server plans`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssh_keys: You can optionally select SSH keys to be added as authorized keys to the nodes in this node group. This allows you to
               connect to the nodes via SSH once they are running.
        :param pulumi.Input[builtins.str] storage_encryption: The storage encryption strategy to use for the nodes in this group. If not set, the cluster's storage encryption
               strategy will be used, if applicable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupTaintArgs', 'KubernetesNodeGroupTaintArgsDict']]]] taints: Taints for the nodes in this group.
        :param pulumi.Input[builtins.bool] utility_network_access: If set to false, nodes in this group will not have access to utility network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesNodeGroupState.__new__(_KubernetesNodeGroupState)

        __props__.__dict__["anti_affinity"] = anti_affinity
        __props__.__dict__["cloud_native_plan"] = cloud_native_plan
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["custom_plan"] = custom_plan
        __props__.__dict__["gpu_plan"] = gpu_plan
        __props__.__dict__["kubelet_args"] = kubelet_args
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["plan"] = plan
        __props__.__dict__["ssh_keys"] = ssh_keys
        __props__.__dict__["storage_encryption"] = storage_encryption
        __props__.__dict__["taints"] = taints
        __props__.__dict__["utility_network_access"] = utility_network_access
        return KubernetesNodeGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> pulumi.Output[builtins.bool]:
        """
        If set to true, nodes in this group will be placed on separate compute hosts. Please note that anti-affinity policy is
        considered 'best effort' and enabling it does not fully guarantee that the nodes will end up on different hardware.
        """
        return pulumi.get(self, "anti_affinity")

    @property
    @pulumi.getter(name="cloudNativePlan")
    def cloud_native_plan(self) -> pulumi.Output[Optional['outputs.KubernetesNodeGroupCloudNativePlan']]:
        """
        Resource properties for Cloud Native plan storage configuration. This block is optional for Cloud Native plans.
        """
        return pulumi.get(self, "cloud_native_plan")

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[builtins.str]:
        """
        UUID of the cluster.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="customPlan")
    def custom_plan(self) -> pulumi.Output[Optional['outputs.KubernetesNodeGroupCustomPlan']]:
        """
        Resource properties for custom plan. This block is required for `custom` plans only.
        """
        return pulumi.get(self, "custom_plan")

    @property
    @pulumi.getter(name="gpuPlan")
    def gpu_plan(self) -> pulumi.Output[Optional['outputs.KubernetesNodeGroupGpuPlan']]:
        """
        Resource properties for GPU plan storage configuration. This block is optional for GPU plans.
        """
        return pulumi.get(self, "gpu_plan")

    @property
    @pulumi.getter(name="kubeletArgs")
    def kubelet_args(self) -> pulumi.Output[Optional[Sequence['outputs.KubernetesNodeGroupKubeletArg']]]:
        """
        Additional arguments for kubelet for the nodes in this group. Configure the arguments without leading `--`. The API will
        prefix the arguments with `--` when preparing kubelet call. Note that these arguments will be passed directly to kubelet
        CLI on each worker node without any validation. Passing invalid arguments can break your whole cluster. Be extra careful
        when adding kubelet args.
        """
        return pulumi.get(self, "kubelet_args")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        User defined key-value pairs to classify the node_group.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the node group. Needs to be unique within a cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[builtins.int]:
        """
        Amount of nodes to provision in the node group.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[builtins.str]:
        """
        The server plan used for the node group. You can list available plans with `upctl server plans`
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        You can optionally select SSH keys to be added as authorized keys to the nodes in this node group. This allows you to
        connect to the nodes via SSH once they are running.
        """
        return pulumi.get(self, "ssh_keys")

    @property
    @pulumi.getter(name="storageEncryption")
    def storage_encryption(self) -> pulumi.Output[builtins.str]:
        """
        The storage encryption strategy to use for the nodes in this group. If not set, the cluster's storage encryption
        strategy will be used, if applicable.
        """
        return pulumi.get(self, "storage_encryption")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.KubernetesNodeGroupTaint']]]:
        """
        Taints for the nodes in this group.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="utilityNetworkAccess")
    def utility_network_access(self) -> pulumi.Output[builtins.bool]:
        """
        If set to false, nodes in this group will not have access to utility network.
        """
        return pulumi.get(self, "utility_network_access")

