# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LoadbalancerBackendTlsConfigArgs', 'LoadbalancerBackendTlsConfig']

@pulumi.input_type
class LoadbalancerBackendTlsConfigArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[builtins.str],
                 certificate_bundle: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LoadbalancerBackendTlsConfig resource.
        :param pulumi.Input[builtins.str] backend: ID of the load balancer backend to which the TLS config is connected.
        :param pulumi.Input[builtins.str] certificate_bundle: Reference to certificate bundle ID.
        :param pulumi.Input[builtins.str] name: The name of the TLS config. Must be unique within customer account.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "certificate_bundle", certificate_bundle)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[builtins.str]:
        """
        ID of the load balancer backend to which the TLS config is connected.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="certificateBundle")
    def certificate_bundle(self) -> pulumi.Input[builtins.str]:
        """
        Reference to certificate bundle ID.
        """
        return pulumi.get(self, "certificate_bundle")

    @certificate_bundle.setter
    def certificate_bundle(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_bundle", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the TLS config. Must be unique within customer account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LoadbalancerBackendTlsConfigState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_bundle: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadbalancerBackendTlsConfig resources.
        :param pulumi.Input[builtins.str] backend: ID of the load balancer backend to which the TLS config is connected.
        :param pulumi.Input[builtins.str] certificate_bundle: Reference to certificate bundle ID.
        :param pulumi.Input[builtins.str] name: The name of the TLS config. Must be unique within customer account.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if certificate_bundle is not None:
            pulumi.set(__self__, "certificate_bundle", certificate_bundle)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the load balancer backend to which the TLS config is connected.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="certificateBundle")
    def certificate_bundle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reference to certificate bundle ID.
        """
        return pulumi.get(self, "certificate_bundle")

    @certificate_bundle.setter
    def certificate_bundle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_bundle", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the TLS config. Must be unique within customer account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


class LoadbalancerBackendTlsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_bundle: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource represents backend TLS config

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend: ID of the load balancer backend to which the TLS config is connected.
        :param pulumi.Input[builtins.str] certificate_bundle: Reference to certificate bundle ID.
        :param pulumi.Input[builtins.str] name: The name of the TLS config. Must be unique within customer account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerBackendTlsConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents backend TLS config

        :param str resource_name: The name of the resource.
        :param LoadbalancerBackendTlsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerBackendTlsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_bundle: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerBackendTlsConfigArgs.__new__(LoadbalancerBackendTlsConfigArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if certificate_bundle is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_bundle'")
            __props__.__dict__["certificate_bundle"] = certificate_bundle
            __props__.__dict__["name"] = name
        super(LoadbalancerBackendTlsConfig, __self__).__init__(
            'upcloud:index/loadbalancerBackendTlsConfig:LoadbalancerBackendTlsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[builtins.str]] = None,
            certificate_bundle: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'LoadbalancerBackendTlsConfig':
        """
        Get an existing LoadbalancerBackendTlsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend: ID of the load balancer backend to which the TLS config is connected.
        :param pulumi.Input[builtins.str] certificate_bundle: Reference to certificate bundle ID.
        :param pulumi.Input[builtins.str] name: The name of the TLS config. Must be unique within customer account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerBackendTlsConfigState.__new__(_LoadbalancerBackendTlsConfigState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["certificate_bundle"] = certificate_bundle
        __props__.__dict__["name"] = name
        return LoadbalancerBackendTlsConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[builtins.str]:
        """
        ID of the load balancer backend to which the TLS config is connected.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="certificateBundle")
    def certificate_bundle(self) -> pulumi.Output[builtins.str]:
        """
        Reference to certificate bundle ID.
        """
        return pulumi.get(self, "certificate_bundle")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the TLS config. Must be unique within customer account.
        """
        return pulumi.get(self, "name")

