# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LoadbalancerStaticBackendMemberArgs', 'LoadbalancerStaticBackendMember']

@pulumi.input_type
class LoadbalancerStaticBackendMemberArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[builtins.str],
                 max_sessions: pulumi.Input[builtins.int],
                 weight: pulumi.Input[builtins.int],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a LoadbalancerStaticBackendMember resource.
        :param pulumi.Input[builtins.str] backend: ID of the load balancer backend to which the member is connected.
        :param pulumi.Input[builtins.int] max_sessions: Maximum number of sessions before queueing.
        :param pulumi.Input[builtins.int] weight: Weight of the member. The higher the weight, the more traffic the member receives.
        :param pulumi.Input[builtins.bool] enabled: Indicates if the member is enabled. Disabled members are excluded from load balancing.
        :param pulumi.Input[builtins.str] ip: Optional fallback IP address in case of failure on DNS resolving.
        :param pulumi.Input[builtins.str] name: The name of the member. Must be unique within within the load balancer backend.
        :param pulumi.Input[builtins.int] port: Server port. Port is optional and can be specified in DNS SRV record.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "max_sessions", max_sessions)
        pulumi.set(__self__, "weight", weight)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[builtins.str]:
        """
        ID of the load balancer backend to which the member is connected.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="maxSessions")
    def max_sessions(self) -> pulumi.Input[builtins.int]:
        """
        Maximum number of sessions before queueing.
        """
        return pulumi.get(self, "max_sessions")

    @max_sessions.setter
    def max_sessions(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_sessions", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[builtins.int]:
        """
        Weight of the member. The higher the weight, the more traffic the member receives.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "weight", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if the member is enabled. Disabled members are excluded from load balancing.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional fallback IP address in case of failure on DNS resolving.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the member. Must be unique within within the load balancer backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Server port. Port is optional and can be specified in DNS SRV record.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class _LoadbalancerStaticBackendMemberState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 max_sessions: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering LoadbalancerStaticBackendMember resources.
        :param pulumi.Input[builtins.str] backend: ID of the load balancer backend to which the member is connected.
        :param pulumi.Input[builtins.bool] enabled: Indicates if the member is enabled. Disabled members are excluded from load balancing.
        :param pulumi.Input[builtins.str] ip: Optional fallback IP address in case of failure on DNS resolving.
        :param pulumi.Input[builtins.int] max_sessions: Maximum number of sessions before queueing.
        :param pulumi.Input[builtins.str] name: The name of the member. Must be unique within within the load balancer backend.
        :param pulumi.Input[builtins.int] port: Server port. Port is optional and can be specified in DNS SRV record.
        :param pulumi.Input[builtins.int] weight: Weight of the member. The higher the weight, the more traffic the member receives.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if max_sessions is not None:
            pulumi.set(__self__, "max_sessions", max_sessions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the load balancer backend to which the member is connected.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if the member is enabled. Disabled members are excluded from load balancing.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional fallback IP address in case of failure on DNS resolving.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="maxSessions")
    def max_sessions(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of sessions before queueing.
        """
        return pulumi.get(self, "max_sessions")

    @max_sessions.setter
    def max_sessions(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_sessions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the member. Must be unique within within the load balancer backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Server port. Port is optional and can be specified in DNS SRV record.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Weight of the member. The higher the weight, the more traffic the member receives.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


class LoadbalancerStaticBackendMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 max_sessions: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource represents load balancer static backend member

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        config = pulumi.Config()
        lb_zone = config.get("lbZone")
        if lb_zone is None:
            lb_zone = "fi-hel2"
        lb_network = upcloud.Network("lb_network",
            name="lb-test-net",
            zone=lb_zone,
            ip_network={
                "address": "10.0.0.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        lb = upcloud.Loadbalancer("lb",
            configured_status="started",
            name="lb-test",
            plan="development",
            zone=lb_zone,
            network=upcloud_network["lbNetwork"]["id"])
        lb_be1 = upcloud.LoadbalancerBackend("lb_be_1",
            loadbalancer=upcloud_loadbalancer["lb"]["id"],
            name="lb-be-1-test")
        lb_be1_sm1 = upcloud.LoadbalancerStaticBackendMember("lb_be_1_sm_1",
            backend=upcloud_loadbalancer_backend["lbBe1"]["id"],
            name="lb-be-1-sm-1-test",
            ip="10.0.0.10",
            port=8000,
            weight=0,
            max_sessions=0,
            enabled=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend: ID of the load balancer backend to which the member is connected.
        :param pulumi.Input[builtins.bool] enabled: Indicates if the member is enabled. Disabled members are excluded from load balancing.
        :param pulumi.Input[builtins.str] ip: Optional fallback IP address in case of failure on DNS resolving.
        :param pulumi.Input[builtins.int] max_sessions: Maximum number of sessions before queueing.
        :param pulumi.Input[builtins.str] name: The name of the member. Must be unique within within the load balancer backend.
        :param pulumi.Input[builtins.int] port: Server port. Port is optional and can be specified in DNS SRV record.
        :param pulumi.Input[builtins.int] weight: Weight of the member. The higher the weight, the more traffic the member receives.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerStaticBackendMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents load balancer static backend member

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        config = pulumi.Config()
        lb_zone = config.get("lbZone")
        if lb_zone is None:
            lb_zone = "fi-hel2"
        lb_network = upcloud.Network("lb_network",
            name="lb-test-net",
            zone=lb_zone,
            ip_network={
                "address": "10.0.0.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        lb = upcloud.Loadbalancer("lb",
            configured_status="started",
            name="lb-test",
            plan="development",
            zone=lb_zone,
            network=upcloud_network["lbNetwork"]["id"])
        lb_be1 = upcloud.LoadbalancerBackend("lb_be_1",
            loadbalancer=upcloud_loadbalancer["lb"]["id"],
            name="lb-be-1-test")
        lb_be1_sm1 = upcloud.LoadbalancerStaticBackendMember("lb_be_1_sm_1",
            backend=upcloud_loadbalancer_backend["lbBe1"]["id"],
            name="lb-be-1-sm-1-test",
            ip="10.0.0.10",
            port=8000,
            weight=0,
            max_sessions=0,
            enabled=True)
        ```

        :param str resource_name: The name of the resource.
        :param LoadbalancerStaticBackendMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerStaticBackendMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 max_sessions: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerStaticBackendMemberArgs.__new__(LoadbalancerStaticBackendMemberArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ip"] = ip
            if max_sessions is None and not opts.urn:
                raise TypeError("Missing required property 'max_sessions'")
            __props__.__dict__["max_sessions"] = max_sessions
            __props__.__dict__["name"] = name
            __props__.__dict__["port"] = port
            if weight is None and not opts.urn:
                raise TypeError("Missing required property 'weight'")
            __props__.__dict__["weight"] = weight
        super(LoadbalancerStaticBackendMember, __self__).__init__(
            'upcloud:index/loadbalancerStaticBackendMember:LoadbalancerStaticBackendMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            ip: Optional[pulumi.Input[builtins.str]] = None,
            max_sessions: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            weight: Optional[pulumi.Input[builtins.int]] = None) -> 'LoadbalancerStaticBackendMember':
        """
        Get an existing LoadbalancerStaticBackendMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend: ID of the load balancer backend to which the member is connected.
        :param pulumi.Input[builtins.bool] enabled: Indicates if the member is enabled. Disabled members are excluded from load balancing.
        :param pulumi.Input[builtins.str] ip: Optional fallback IP address in case of failure on DNS resolving.
        :param pulumi.Input[builtins.int] max_sessions: Maximum number of sessions before queueing.
        :param pulumi.Input[builtins.str] name: The name of the member. Must be unique within within the load balancer backend.
        :param pulumi.Input[builtins.int] port: Server port. Port is optional and can be specified in DNS SRV record.
        :param pulumi.Input[builtins.int] weight: Weight of the member. The higher the weight, the more traffic the member receives.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerStaticBackendMemberState.__new__(_LoadbalancerStaticBackendMemberState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ip"] = ip
        __props__.__dict__["max_sessions"] = max_sessions
        __props__.__dict__["name"] = name
        __props__.__dict__["port"] = port
        __props__.__dict__["weight"] = weight
        return LoadbalancerStaticBackendMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[builtins.str]:
        """
        ID of the load balancer backend to which the member is connected.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates if the member is enabled. Disabled members are excluded from load balancing.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[builtins.str]:
        """
        Optional fallback IP address in case of failure on DNS resolving.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="maxSessions")
    def max_sessions(self) -> pulumi.Output[builtins.int]:
        """
        Maximum number of sessions before queueing.
        """
        return pulumi.get(self, "max_sessions")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the member. Must be unique within within the load balancer backend.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        Server port. Port is optional and can be specified in DNS SRV record.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Output[builtins.int]:
        """
        Weight of the member. The higher the weight, the more traffic the member receives.
        """
        return pulumi.get(self, "weight")

