# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedDatabaseRedisArgs', 'ManagedDatabaseRedis']

@pulumi.input_type
class ManagedDatabaseRedisArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 zone: pulumi.Input[builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNetworkArgs']]]] = None,
                 powered: Optional[pulumi.Input[builtins.bool]] = None,
                 properties: Optional[pulumi.Input['ManagedDatabaseRedisPropertiesArgs']] = None,
                 termination_protection: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ManagedDatabaseRedis resource.
        :param pulumi.Input[builtins.str] plan: Service plan to use. This determines how much resources the instance will have. You can list available plans with `upctl
               database plans <type>`.
        :param pulumi.Input[builtins.str] title: Title of a managed database instance
        :param pulumi.Input[builtins.str] zone: Zone where the instance resides, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User defined key-value pairs to classify the managed database.
        :param pulumi.Input[builtins.str] maintenance_window_dow: Maintenance window day of week. Lower case weekday name (monday, tuesday, ...)
        :param pulumi.Input[builtins.str] maintenance_window_time: Maintenance window UTC time in hh:mm:ss format
        :param pulumi.Input[builtins.str] name: Name of the service. The name is used as a prefix for the logical hostname. Must be unique within an account
        :param pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNetworkArgs']]] networks: Private networks attached to the managed database
        :param pulumi.Input[builtins.bool] powered: The administrative power state of the service
        :param pulumi.Input['ManagedDatabaseRedisPropertiesArgs'] properties: Database Engine properties for Redis
        :param pulumi.Input[builtins.bool] termination_protection: If set to true, prevents the managed service from being powered off, or deleted.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "zone", zone)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window_dow is not None:
            pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if powered is not None:
            pulumi.set(__self__, "powered", powered)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input[builtins.str]:
        """
        Service plan to use. This determines how much resources the instance will have. You can list available plans with `upctl
        database plans <type>`.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        Title of a managed database instance
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[builtins.str]:
        """
        Zone where the instance resides, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User defined key-value pairs to classify the managed database.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maintenance window day of week. Lower case weekday name (monday, tuesday, ...)
        """
        return pulumi.get(self, "maintenance_window_dow")

    @maintenance_window_dow.setter
    def maintenance_window_dow(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_window_dow", value)

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maintenance window UTC time in hh:mm:ss format
        """
        return pulumi.get(self, "maintenance_window_time")

    @maintenance_window_time.setter
    def maintenance_window_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_window_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the service. The name is used as a prefix for the logical hostname. Must be unique within an account
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNetworkArgs']]]]:
        """
        Private networks attached to the managed database
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def powered(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The administrative power state of the service
        """
        return pulumi.get(self, "powered")

    @powered.setter
    def powered(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "powered", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ManagedDatabaseRedisPropertiesArgs']]:
        """
        Database Engine properties for Redis
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ManagedDatabaseRedisPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, prevents the managed service from being powered off, or deleted.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "termination_protection", value)


@pulumi.input_type
class _ManagedDatabaseRedisState:
    def __init__(__self__, *,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisComponentArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNetworkArgs']]]] = None,
                 node_states: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNodeStateArgs']]]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 powered: Optional[pulumi.Input[builtins.bool]] = None,
                 primary_database: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input['ManagedDatabaseRedisPropertiesArgs']] = None,
                 service_host: Optional[pulumi.Input[builtins.str]] = None,
                 service_password: Optional[pulumi.Input[builtins.str]] = None,
                 service_port: Optional[pulumi.Input[builtins.str]] = None,
                 service_uri: Optional[pulumi.Input[builtins.str]] = None,
                 service_username: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 termination_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedDatabaseRedis resources.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisComponentArgs']]] components: Service component information
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User defined key-value pairs to classify the managed database.
        :param pulumi.Input[builtins.str] maintenance_window_dow: Maintenance window day of week. Lower case weekday name (monday, tuesday, ...)
        :param pulumi.Input[builtins.str] maintenance_window_time: Maintenance window UTC time in hh:mm:ss format
        :param pulumi.Input[builtins.str] name: Name of the service. The name is used as a prefix for the logical hostname. Must be unique within an account
        :param pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNetworkArgs']]] networks: Private networks attached to the managed database
        :param pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNodeStateArgs']]] node_states: Information about nodes providing the managed service
        :param pulumi.Input[builtins.str] plan: Service plan to use. This determines how much resources the instance will have. You can list available plans with `upctl
               database plans <type>`.
        :param pulumi.Input[builtins.bool] powered: The administrative power state of the service
        :param pulumi.Input[builtins.str] primary_database: Primary database name
        :param pulumi.Input['ManagedDatabaseRedisPropertiesArgs'] properties: Database Engine properties for Redis
        :param pulumi.Input[builtins.str] service_host: Hostname to the service instance
        :param pulumi.Input[builtins.str] service_password: Primary username's password to the service instance
        :param pulumi.Input[builtins.str] service_port: Port to the service instance
        :param pulumi.Input[builtins.str] service_uri: URI to the service instance
        :param pulumi.Input[builtins.str] service_username: Primary username to the service instance
        :param pulumi.Input[builtins.str] state: State of the service
        :param pulumi.Input[builtins.bool] termination_protection: If set to true, prevents the managed service from being powered off, or deleted.
        :param pulumi.Input[builtins.str] title: Title of a managed database instance
        :param pulumi.Input[builtins.str] type: Type of the service
        :param pulumi.Input[builtins.str] zone: Zone where the instance resides, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        if components is not None:
            pulumi.set(__self__, "components", components)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window_dow is not None:
            pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if node_states is not None:
            pulumi.set(__self__, "node_states", node_states)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if powered is not None:
            pulumi.set(__self__, "powered", powered)
        if primary_database is not None:
            pulumi.set(__self__, "primary_database", primary_database)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if service_host is not None:
            pulumi.set(__self__, "service_host", service_host)
        if service_password is not None:
            pulumi.set(__self__, "service_password", service_password)
        if service_port is not None:
            pulumi.set(__self__, "service_port", service_port)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)
        if service_username is not None:
            pulumi.set(__self__, "service_username", service_username)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisComponentArgs']]]]:
        """
        Service component information
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User defined key-value pairs to classify the managed database.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maintenance window day of week. Lower case weekday name (monday, tuesday, ...)
        """
        return pulumi.get(self, "maintenance_window_dow")

    @maintenance_window_dow.setter
    def maintenance_window_dow(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_window_dow", value)

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maintenance window UTC time in hh:mm:ss format
        """
        return pulumi.get(self, "maintenance_window_time")

    @maintenance_window_time.setter
    def maintenance_window_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_window_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the service. The name is used as a prefix for the logical hostname. Must be unique within an account
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNetworkArgs']]]]:
        """
        Private networks attached to the managed database
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="nodeStates")
    def node_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNodeStateArgs']]]]:
        """
        Information about nodes providing the managed service
        """
        return pulumi.get(self, "node_states")

    @node_states.setter
    def node_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseRedisNodeStateArgs']]]]):
        pulumi.set(self, "node_states", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service plan to use. This determines how much resources the instance will have. You can list available plans with `upctl
        database plans <type>`.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def powered(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The administrative power state of the service
        """
        return pulumi.get(self, "powered")

    @powered.setter
    def powered(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "powered", value)

    @property
    @pulumi.getter(name="primaryDatabase")
    def primary_database(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary database name
        """
        return pulumi.get(self, "primary_database")

    @primary_database.setter
    def primary_database(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_database", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ManagedDatabaseRedisPropertiesArgs']]:
        """
        Database Engine properties for Redis
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ManagedDatabaseRedisPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname to the service instance
        """
        return pulumi.get(self, "service_host")

    @service_host.setter
    def service_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_host", value)

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary username's password to the service instance
        """
        return pulumi.get(self, "service_password")

    @service_password.setter
    def service_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_password", value)

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Port to the service instance
        """
        return pulumi.get(self, "service_port")

    @service_port.setter
    def service_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_port", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URI to the service instance
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary username to the service instance
        """
        return pulumi.get(self, "service_username")

    @service_username.setter
    def service_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_username", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State of the service
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, prevents the managed service from being powered off, or deleted.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "termination_protection", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Title of a managed database instance
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the service
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Zone where the instance resides, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


class ManagedDatabaseRedis(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseRedisNetworkArgs', 'ManagedDatabaseRedisNetworkArgsDict']]]]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 powered: Optional[pulumi.Input[builtins.bool]] = None,
                 properties: Optional[pulumi.Input[Union['ManagedDatabaseRedisPropertiesArgs', 'ManagedDatabaseRedisPropertiesArgsDict']]] = None,
                 termination_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > Redis is deprecated in favor of Valkey. Please use Valkey for new key value store instances.

        This resource represents Redis managed database. See UpCloud [Managed Databases](https://upcloud.com/products/managed-databases) product page for more details about the service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Minimal config
        example1 = upcloud.ManagedDatabaseRedis("example_1",
            name="redis-1",
            title="redis-1-example-2",
            plan="1x1xCPU-2GB",
            zone="fi-hel2")
        # Service with custom properties
        example2 = upcloud.ManagedDatabaseRedis("example_2",
            name="redis-2",
            title="redis-2-example-2",
            plan="1x1xCPU-2GB",
            zone="fi-hel1",
            properties={
                "public_access": False,
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User defined key-value pairs to classify the managed database.
        :param pulumi.Input[builtins.str] maintenance_window_dow: Maintenance window day of week. Lower case weekday name (monday, tuesday, ...)
        :param pulumi.Input[builtins.str] maintenance_window_time: Maintenance window UTC time in hh:mm:ss format
        :param pulumi.Input[builtins.str] name: Name of the service. The name is used as a prefix for the logical hostname. Must be unique within an account
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseRedisNetworkArgs', 'ManagedDatabaseRedisNetworkArgsDict']]]] networks: Private networks attached to the managed database
        :param pulumi.Input[builtins.str] plan: Service plan to use. This determines how much resources the instance will have. You can list available plans with `upctl
               database plans <type>`.
        :param pulumi.Input[builtins.bool] powered: The administrative power state of the service
        :param pulumi.Input[Union['ManagedDatabaseRedisPropertiesArgs', 'ManagedDatabaseRedisPropertiesArgsDict']] properties: Database Engine properties for Redis
        :param pulumi.Input[builtins.bool] termination_protection: If set to true, prevents the managed service from being powered off, or deleted.
        :param pulumi.Input[builtins.str] title: Title of a managed database instance
        :param pulumi.Input[builtins.str] zone: Zone where the instance resides, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedDatabaseRedisArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > Redis is deprecated in favor of Valkey. Please use Valkey for new key value store instances.

        This resource represents Redis managed database. See UpCloud [Managed Databases](https://upcloud.com/products/managed-databases) product page for more details about the service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Minimal config
        example1 = upcloud.ManagedDatabaseRedis("example_1",
            name="redis-1",
            title="redis-1-example-2",
            plan="1x1xCPU-2GB",
            zone="fi-hel2")
        # Service with custom properties
        example2 = upcloud.ManagedDatabaseRedis("example_2",
            name="redis-2",
            title="redis-2-example-2",
            plan="1x1xCPU-2GB",
            zone="fi-hel1",
            properties={
                "public_access": False,
            })
        ```

        :param str resource_name: The name of the resource.
        :param ManagedDatabaseRedisArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedDatabaseRedisArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseRedisNetworkArgs', 'ManagedDatabaseRedisNetworkArgsDict']]]]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 powered: Optional[pulumi.Input[builtins.bool]] = None,
                 properties: Optional[pulumi.Input[Union['ManagedDatabaseRedisPropertiesArgs', 'ManagedDatabaseRedisPropertiesArgsDict']]] = None,
                 termination_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedDatabaseRedisArgs.__new__(ManagedDatabaseRedisArgs)

            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_window_dow"] = maintenance_window_dow
            __props__.__dict__["maintenance_window_time"] = maintenance_window_time
            __props__.__dict__["name"] = name
            __props__.__dict__["networks"] = networks
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            __props__.__dict__["powered"] = powered
            __props__.__dict__["properties"] = properties
            __props__.__dict__["termination_protection"] = termination_protection
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["components"] = None
            __props__.__dict__["node_states"] = None
            __props__.__dict__["primary_database"] = None
            __props__.__dict__["service_host"] = None
            __props__.__dict__["service_password"] = None
            __props__.__dict__["service_port"] = None
            __props__.__dict__["service_uri"] = None
            __props__.__dict__["service_username"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["servicePassword", "serviceUri"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedDatabaseRedis, __self__).__init__(
            'upcloud:index/managedDatabaseRedis:ManagedDatabaseRedis',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseRedisComponentArgs', 'ManagedDatabaseRedisComponentArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            maintenance_window_dow: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_window_time: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseRedisNetworkArgs', 'ManagedDatabaseRedisNetworkArgsDict']]]]] = None,
            node_states: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseRedisNodeStateArgs', 'ManagedDatabaseRedisNodeStateArgsDict']]]]] = None,
            plan: Optional[pulumi.Input[builtins.str]] = None,
            powered: Optional[pulumi.Input[builtins.bool]] = None,
            primary_database: Optional[pulumi.Input[builtins.str]] = None,
            properties: Optional[pulumi.Input[Union['ManagedDatabaseRedisPropertiesArgs', 'ManagedDatabaseRedisPropertiesArgsDict']]] = None,
            service_host: Optional[pulumi.Input[builtins.str]] = None,
            service_password: Optional[pulumi.Input[builtins.str]] = None,
            service_port: Optional[pulumi.Input[builtins.str]] = None,
            service_uri: Optional[pulumi.Input[builtins.str]] = None,
            service_username: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            termination_protection: Optional[pulumi.Input[builtins.bool]] = None,
            title: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagedDatabaseRedis':
        """
        Get an existing ManagedDatabaseRedis resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseRedisComponentArgs', 'ManagedDatabaseRedisComponentArgsDict']]]] components: Service component information
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User defined key-value pairs to classify the managed database.
        :param pulumi.Input[builtins.str] maintenance_window_dow: Maintenance window day of week. Lower case weekday name (monday, tuesday, ...)
        :param pulumi.Input[builtins.str] maintenance_window_time: Maintenance window UTC time in hh:mm:ss format
        :param pulumi.Input[builtins.str] name: Name of the service. The name is used as a prefix for the logical hostname. Must be unique within an account
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseRedisNetworkArgs', 'ManagedDatabaseRedisNetworkArgsDict']]]] networks: Private networks attached to the managed database
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseRedisNodeStateArgs', 'ManagedDatabaseRedisNodeStateArgsDict']]]] node_states: Information about nodes providing the managed service
        :param pulumi.Input[builtins.str] plan: Service plan to use. This determines how much resources the instance will have. You can list available plans with `upctl
               database plans <type>`.
        :param pulumi.Input[builtins.bool] powered: The administrative power state of the service
        :param pulumi.Input[builtins.str] primary_database: Primary database name
        :param pulumi.Input[Union['ManagedDatabaseRedisPropertiesArgs', 'ManagedDatabaseRedisPropertiesArgsDict']] properties: Database Engine properties for Redis
        :param pulumi.Input[builtins.str] service_host: Hostname to the service instance
        :param pulumi.Input[builtins.str] service_password: Primary username's password to the service instance
        :param pulumi.Input[builtins.str] service_port: Port to the service instance
        :param pulumi.Input[builtins.str] service_uri: URI to the service instance
        :param pulumi.Input[builtins.str] service_username: Primary username to the service instance
        :param pulumi.Input[builtins.str] state: State of the service
        :param pulumi.Input[builtins.bool] termination_protection: If set to true, prevents the managed service from being powered off, or deleted.
        :param pulumi.Input[builtins.str] title: Title of a managed database instance
        :param pulumi.Input[builtins.str] type: Type of the service
        :param pulumi.Input[builtins.str] zone: Zone where the instance resides, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedDatabaseRedisState.__new__(_ManagedDatabaseRedisState)

        __props__.__dict__["components"] = components
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_window_dow"] = maintenance_window_dow
        __props__.__dict__["maintenance_window_time"] = maintenance_window_time
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["node_states"] = node_states
        __props__.__dict__["plan"] = plan
        __props__.__dict__["powered"] = powered
        __props__.__dict__["primary_database"] = primary_database
        __props__.__dict__["properties"] = properties
        __props__.__dict__["service_host"] = service_host
        __props__.__dict__["service_password"] = service_password
        __props__.__dict__["service_port"] = service_port
        __props__.__dict__["service_uri"] = service_uri
        __props__.__dict__["service_username"] = service_username
        __props__.__dict__["state"] = state
        __props__.__dict__["termination_protection"] = termination_protection
        __props__.__dict__["title"] = title
        __props__.__dict__["type"] = type
        __props__.__dict__["zone"] = zone
        return ManagedDatabaseRedis(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def components(self) -> pulumi.Output[Sequence['outputs.ManagedDatabaseRedisComponent']]:
        """
        Service component information
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User defined key-value pairs to classify the managed database.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> pulumi.Output[builtins.str]:
        """
        Maintenance window day of week. Lower case weekday name (monday, tuesday, ...)
        """
        return pulumi.get(self, "maintenance_window_dow")

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> pulumi.Output[builtins.str]:
        """
        Maintenance window UTC time in hh:mm:ss format
        """
        return pulumi.get(self, "maintenance_window_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the service. The name is used as a prefix for the logical hostname. Must be unique within an account
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional[Sequence['outputs.ManagedDatabaseRedisNetwork']]]:
        """
        Private networks attached to the managed database
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="nodeStates")
    def node_states(self) -> pulumi.Output[Sequence['outputs.ManagedDatabaseRedisNodeState']]:
        """
        Information about nodes providing the managed service
        """
        return pulumi.get(self, "node_states")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[builtins.str]:
        """
        Service plan to use. This determines how much resources the instance will have. You can list available plans with `upctl
        database plans <type>`.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def powered(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The administrative power state of the service
        """
        return pulumi.get(self, "powered")

    @property
    @pulumi.getter(name="primaryDatabase")
    def primary_database(self) -> pulumi.Output[builtins.str]:
        """
        Primary database name
        """
        return pulumi.get(self, "primary_database")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.ManagedDatabaseRedisProperties']:
        """
        Database Engine properties for Redis
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> pulumi.Output[builtins.str]:
        """
        Hostname to the service instance
        """
        return pulumi.get(self, "service_host")

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> pulumi.Output[builtins.str]:
        """
        Primary username's password to the service instance
        """
        return pulumi.get(self, "service_password")

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> pulumi.Output[builtins.str]:
        """
        Port to the service instance
        """
        return pulumi.get(self, "service_port")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> pulumi.Output[builtins.str]:
        """
        URI to the service instance
        """
        return pulumi.get(self, "service_uri")

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> pulumi.Output[builtins.str]:
        """
        Primary username to the service instance
        """
        return pulumi.get(self, "service_username")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        State of the service
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to true, prevents the managed service from being powered off, or deleted.
        """
        return pulumi.get(self, "termination_protection")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[builtins.str]:
        """
        Title of a managed database instance
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of the service
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        Zone where the instance resides, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

