# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ManagedObjectStorageCustomDomainArgs', 'ManagedObjectStorageCustomDomain']

@pulumi.input_type
class ManagedObjectStorageCustomDomainArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[builtins.str],
                 service_uuid: pulumi.Input[builtins.str],
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedObjectStorageCustomDomain resource.
        :param pulumi.Input[builtins.str] domain_name: Must be a subdomain and consist of 3 to 5 parts such as objects.example.com. Cannot be root-level domain e.g.
               example.com.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] type: At the moment only `public` is accepted.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "service_uuid", service_uuid)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        Must be a subdomain and consist of 3 to 5 parts such as objects.example.com. Cannot be root-level domain e.g.
        example.com.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="serviceUuid")
    def service_uuid(self) -> pulumi.Input[builtins.str]:
        """
        Managed Object Storage service UUID.
        """
        return pulumi.get(self, "service_uuid")

    @service_uuid.setter
    def service_uuid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_uuid", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        At the moment only `public` is accepted.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ManagedObjectStorageCustomDomainState:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedObjectStorageCustomDomain resources.
        :param pulumi.Input[builtins.str] domain_name: Must be a subdomain and consist of 3 to 5 parts such as objects.example.com. Cannot be root-level domain e.g.
               example.com.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] type: At the moment only `public` is accepted.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if service_uuid is not None:
            pulumi.set(__self__, "service_uuid", service_uuid)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Must be a subdomain and consist of 3 to 5 parts such as objects.example.com. Cannot be root-level domain e.g.
        example.com.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="serviceUuid")
    def service_uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Managed Object Storage service UUID.
        """
        return pulumi.get(self, "service_uuid")

    @service_uuid.setter
    def service_uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_uuid", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        At the moment only `public` is accepted.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


class ManagedObjectStorageCustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource represents an UpCloud Managed Object Storage custom domain. Note that DNS settings for the custom domain should be configured before creating this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        this_managed_object_storage = upcloud.ManagedObjectStorage("this",
            name="object-storage-custom-domain-example",
            region="europe-1",
            configured_status="started",
            networks=[{
                "family": "IPv4",
                "name": "public",
                "type": "public",
            }])
        this = upcloud.get_load_balancer_dns_challenge_domain()
        # Before creating the custom domain, configure the DNS settings for your custom domain. For example, if your custom domain is objects.example.com, you should configure the following DNS records:
        # - "_acme-challenge.objects IN CNAME ${data.upcloud_load_balancer_dns_challenge_domain.this.domain}"
        # - "objects IN CNAME ${[for i in upcloud_managed_object_storage.this.endpoint: i.domain_name if i.type == "public"][0]}"
        # - "*.objects IN CNAME ${[for i in upcloud_managed_object_storage.this.endpoint: i.domain_name if i.type == "public"][0]}"
        this_managed_object_storage_custom_domain = upcloud.ManagedObjectStorageCustomDomain("this",
            service_uuid=this_managed_object_storage.id,
            domain_name="objects.example.com")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_name: Must be a subdomain and consist of 3 to 5 parts such as objects.example.com. Cannot be root-level domain e.g.
               example.com.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] type: At the moment only `public` is accepted.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedObjectStorageCustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents an UpCloud Managed Object Storage custom domain. Note that DNS settings for the custom domain should be configured before creating this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        this_managed_object_storage = upcloud.ManagedObjectStorage("this",
            name="object-storage-custom-domain-example",
            region="europe-1",
            configured_status="started",
            networks=[{
                "family": "IPv4",
                "name": "public",
                "type": "public",
            }])
        this = upcloud.get_load_balancer_dns_challenge_domain()
        # Before creating the custom domain, configure the DNS settings for your custom domain. For example, if your custom domain is objects.example.com, you should configure the following DNS records:
        # - "_acme-challenge.objects IN CNAME ${data.upcloud_load_balancer_dns_challenge_domain.this.domain}"
        # - "objects IN CNAME ${[for i in upcloud_managed_object_storage.this.endpoint: i.domain_name if i.type == "public"][0]}"
        # - "*.objects IN CNAME ${[for i in upcloud_managed_object_storage.this.endpoint: i.domain_name if i.type == "public"][0]}"
        this_managed_object_storage_custom_domain = upcloud.ManagedObjectStorageCustomDomain("this",
            service_uuid=this_managed_object_storage.id,
            domain_name="objects.example.com")
        ```

        :param str resource_name: The name of the resource.
        :param ManagedObjectStorageCustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedObjectStorageCustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedObjectStorageCustomDomainArgs.__new__(ManagedObjectStorageCustomDomainArgs)

            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            if service_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'service_uuid'")
            __props__.__dict__["service_uuid"] = service_uuid
            __props__.__dict__["type"] = type
        super(ManagedObjectStorageCustomDomain, __self__).__init__(
            'upcloud:index/managedObjectStorageCustomDomain:ManagedObjectStorageCustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_name: Optional[pulumi.Input[builtins.str]] = None,
            service_uuid: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagedObjectStorageCustomDomain':
        """
        Get an existing ManagedObjectStorageCustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_name: Must be a subdomain and consist of 3 to 5 parts such as objects.example.com. Cannot be root-level domain e.g.
               example.com.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] type: At the moment only `public` is accepted.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedObjectStorageCustomDomainState.__new__(_ManagedObjectStorageCustomDomainState)

        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["service_uuid"] = service_uuid
        __props__.__dict__["type"] = type
        return ManagedObjectStorageCustomDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        Must be a subdomain and consist of 3 to 5 parts such as objects.example.com. Cannot be root-level domain e.g.
        example.com.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="serviceUuid")
    def service_uuid(self) -> pulumi.Output[builtins.str]:
        """
        Managed Object Storage service UUID.
        """
        return pulumi.get(self, "service_uuid")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        At the moment only `public` is accepted.
        """
        return pulumi.get(self, "type")

