# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ManagedObjectStorageUserArgs', 'ManagedObjectStorageUser']

@pulumi.input_type
class ManagedObjectStorageUserArgs:
    def __init__(__self__, *,
                 service_uuid: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ManagedObjectStorageUser resource.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] username: Custom usernames for accessing the object storage. No relation to UpCloud API accounts. See
               `ManagedObjectStorageUserAccessKey` for managing access keys and `ManagedObjectStorageUserPolicy` for managing policies.
        """
        pulumi.set(__self__, "service_uuid", service_uuid)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="serviceUuid")
    def service_uuid(self) -> pulumi.Input[builtins.str]:
        """
        Managed Object Storage service UUID.
        """
        return pulumi.get(self, "service_uuid")

    @service_uuid.setter
    def service_uuid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_uuid", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        Custom usernames for accessing the object storage. No relation to UpCloud API accounts. See
        `ManagedObjectStorageUserAccessKey` for managing access keys and `ManagedObjectStorageUserPolicy` for managing policies.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _ManagedObjectStorageUserState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 service_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedObjectStorageUser resources.
        :param pulumi.Input[builtins.str] arn: User ARN.
        :param pulumi.Input[builtins.str] created_at: Creation time.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] username: Custom usernames for accessing the object storage. No relation to UpCloud API accounts. See
               `ManagedObjectStorageUserAccessKey` for managing access keys and `ManagedObjectStorageUserPolicy` for managing policies.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if service_uuid is not None:
            pulumi.set(__self__, "service_uuid", service_uuid)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="serviceUuid")
    def service_uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Managed Object Storage service UUID.
        """
        return pulumi.get(self, "service_uuid")

    @service_uuid.setter
    def service_uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_uuid", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom usernames for accessing the object storage. No relation to UpCloud API accounts. See
        `ManagedObjectStorageUserAccessKey` for managing access keys and `ManagedObjectStorageUserPolicy` for managing policies.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


class ManagedObjectStorageUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 service_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource represents an UpCloud Managed Object Storage user. No relation to UpCloud API accounts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        this = upcloud.ManagedObjectStorage("this",
            name="example",
            region="europe-1",
            configured_status="started")
        this_managed_object_storage_user = upcloud.ManagedObjectStorageUser("this",
            username="example",
            service_uuid=this.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] username: Custom usernames for accessing the object storage. No relation to UpCloud API accounts. See
               `ManagedObjectStorageUserAccessKey` for managing access keys and `ManagedObjectStorageUserPolicy` for managing policies.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedObjectStorageUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents an UpCloud Managed Object Storage user. No relation to UpCloud API accounts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        this = upcloud.ManagedObjectStorage("this",
            name="example",
            region="europe-1",
            configured_status="started")
        this_managed_object_storage_user = upcloud.ManagedObjectStorageUser("this",
            username="example",
            service_uuid=this.id)
        ```

        :param str resource_name: The name of the resource.
        :param ManagedObjectStorageUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedObjectStorageUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 service_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedObjectStorageUserArgs.__new__(ManagedObjectStorageUserArgs)

            if service_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'service_uuid'")
            __props__.__dict__["service_uuid"] = service_uuid
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
        super(ManagedObjectStorageUser, __self__).__init__(
            'upcloud:index/managedObjectStorageUser:ManagedObjectStorageUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            service_uuid: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagedObjectStorageUser':
        """
        Get an existing ManagedObjectStorageUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: User ARN.
        :param pulumi.Input[builtins.str] created_at: Creation time.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] username: Custom usernames for accessing the object storage. No relation to UpCloud API accounts. See
               `ManagedObjectStorageUserAccessKey` for managing access keys and `ManagedObjectStorageUserPolicy` for managing policies.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedObjectStorageUserState.__new__(_ManagedObjectStorageUserState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["service_uuid"] = service_uuid
        __props__.__dict__["username"] = username
        return ManagedObjectStorageUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        User ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Creation time.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="serviceUuid")
    def service_uuid(self) -> pulumi.Output[builtins.str]:
        """
        Managed Object Storage service UUID.
        """
        return pulumi.get(self, "service_uuid")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        Custom usernames for accessing the object storage. No relation to UpCloud API accounts. See
        `ManagedObjectStorageUserAccessKey` for managing access keys and `ManagedObjectStorageUserPolicy` for managing policies.
        """
        return pulumi.get(self, "username")

