# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ManagedObjectStorageUserPolicyArgs', 'ManagedObjectStorageUserPolicy']

@pulumi.input_type
class ManagedObjectStorageUserPolicyArgs:
    def __init__(__self__, *,
                 service_uuid: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedObjectStorageUserPolicy resource.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] username: Username.
        :param pulumi.Input[builtins.str] name: Policy name.
        """
        pulumi.set(__self__, "service_uuid", service_uuid)
        pulumi.set(__self__, "username", username)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="serviceUuid")
    def service_uuid(self) -> pulumi.Input[builtins.str]:
        """
        Managed Object Storage service UUID.
        """
        return pulumi.get(self, "service_uuid")

    @service_uuid.setter
    def service_uuid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_uuid", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ManagedObjectStorageUserPolicyState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedObjectStorageUserPolicy resources.
        :param pulumi.Input[builtins.str] name: Policy name.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] username: Username.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_uuid is not None:
            pulumi.set(__self__, "service_uuid", service_uuid)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceUuid")
    def service_uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Managed Object Storage service UUID.
        """
        return pulumi.get(self, "service_uuid")

    @service_uuid.setter
    def service_uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_uuid", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


class ManagedObjectStorageUserPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource represents an UpCloud Managed Object Storage user policy attachment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        this = upcloud.ManagedObjectStorage("this",
            name="example",
            region="europe-1",
            configured_status="started")
        this_managed_object_storage_policy = upcloud.ManagedObjectStoragePolicy("this",
            name="example",
            description="example description",
            document="%7B%22Version%22%3A%20%222012-10-17%22%2C%20%20%22Statement%22%3A%20%5B%7B%22Action%22%3A%20%5B%22iam%3AGetUser%22%5D%2C%20%22Resource%22%3A%20%22%2A%22%2C%20%22Effect%22%3A%20%22Allow%22%2C%20%22Sid%22%3A%20%22editor%22%7D%5D%7D",
            service_uuid=this.id)
        this_managed_object_storage_user = upcloud.ManagedObjectStorageUser("this",
            username="example",
            service_uuid=this.id)
        this_managed_object_storage_user_policy = upcloud.ManagedObjectStorageUserPolicy("this",
            username=this_managed_object_storage_user.username,
            service_uuid=this.id,
            name=this_managed_object_storage_policy.name)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Policy name.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] username: Username.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedObjectStorageUserPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents an UpCloud Managed Object Storage user policy attachment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        this = upcloud.ManagedObjectStorage("this",
            name="example",
            region="europe-1",
            configured_status="started")
        this_managed_object_storage_policy = upcloud.ManagedObjectStoragePolicy("this",
            name="example",
            description="example description",
            document="%7B%22Version%22%3A%20%222012-10-17%22%2C%20%20%22Statement%22%3A%20%5B%7B%22Action%22%3A%20%5B%22iam%3AGetUser%22%5D%2C%20%22Resource%22%3A%20%22%2A%22%2C%20%22Effect%22%3A%20%22Allow%22%2C%20%22Sid%22%3A%20%22editor%22%7D%5D%7D",
            service_uuid=this.id)
        this_managed_object_storage_user = upcloud.ManagedObjectStorageUser("this",
            username="example",
            service_uuid=this.id)
        this_managed_object_storage_user_policy = upcloud.ManagedObjectStorageUserPolicy("this",
            username=this_managed_object_storage_user.username,
            service_uuid=this.id,
            name=this_managed_object_storage_policy.name)
        ```

        :param str resource_name: The name of the resource.
        :param ManagedObjectStorageUserPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedObjectStorageUserPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedObjectStorageUserPolicyArgs.__new__(ManagedObjectStorageUserPolicyArgs)

            __props__.__dict__["name"] = name
            if service_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'service_uuid'")
            __props__.__dict__["service_uuid"] = service_uuid
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        super(ManagedObjectStorageUserPolicy, __self__).__init__(
            'upcloud:index/managedObjectStorageUserPolicy:ManagedObjectStorageUserPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            service_uuid: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagedObjectStorageUserPolicy':
        """
        Get an existing ManagedObjectStorageUserPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Policy name.
        :param pulumi.Input[builtins.str] service_uuid: Managed Object Storage service UUID.
        :param pulumi.Input[builtins.str] username: Username.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedObjectStorageUserPolicyState.__new__(_ManagedObjectStorageUserPolicyState)

        __props__.__dict__["name"] = name
        __props__.__dict__["service_uuid"] = service_uuid
        __props__.__dict__["username"] = username
        return ManagedObjectStorageUserPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Policy name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceUuid")
    def service_uuid(self) -> pulumi.Output[builtins.str]:
        """
        Managed Object Storage service UUID.
        """
        return pulumi.get(self, "service_uuid")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        Username.
        """
        return pulumi.get(self, "username")

