# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObjectStorageArgs', 'ObjectStorage']

@pulumi.input_type
class ObjectStorageArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[builtins.str],
                 description: pulumi.Input[builtins.str],
                 secret_key: pulumi.Input[builtins.str],
                 size: pulumi.Input[builtins.int],
                 zone: pulumi.Input[builtins.str],
                 buckets: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ObjectStorage resource.
        :param pulumi.Input[builtins.str] access_key: The access key used to identify user. Can be set to an empty string, which will tell the provider to get the access key
               from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_{name}". {name} is the
               name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-) should
               be replaced with underscores (_). For example, object storage named "my-files" would use environment variable named
               "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_MY_FILES".
        :param pulumi.Input[builtins.str] description: The description of the object storage instance to be created
        :param pulumi.Input[builtins.str] secret_key: The secret key used to authenticate user. Can be set to an empty string, which will tell the provider to get the secret
               key from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_{name}". {name} is
               the name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-)
               should be replaced with underscores (_). For example, object storage named "my-files" would use environment variable
               named "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_MY_FILES".
        :param pulumi.Input[builtins.int] size: The size of the object storage instance in gigabytes
        :param pulumi.Input[builtins.str] zone: The zone in which the object storage instance will be created, e.g. `de-fra1`. You can list available zones with `upctl
               zone list`.
        :param pulumi.Input[builtins.str] name: The name of the object storage instance to be created
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "zone", zone)
        if buckets is not None:
            pulumi.set(__self__, "buckets", buckets)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[builtins.str]:
        """
        The access key used to identify user. Can be set to an empty string, which will tell the provider to get the access key
        from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_{name}". {name} is the
        name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-) should
        be replaced with underscores (_). For example, object storage named "my-files" would use environment variable named
        "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_MY_FILES".
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the object storage instance to be created
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[builtins.str]:
        """
        The secret key used to authenticate user. Can be set to an empty string, which will tell the provider to get the secret
        key from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_{name}". {name} is
        the name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-)
        should be replaced with underscores (_). For example, object storage named "my-files" would use environment variable
        named "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_MY_FILES".
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[builtins.int]:
        """
        The size of the object storage instance in gigabytes
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[builtins.str]:
        """
        The zone in which the object storage instance will be created, e.g. `de-fra1`. You can list available zones with `upctl
        zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter
    def buckets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketArgs']]]]:
        return pulumi.get(self, "buckets")

    @buckets.setter
    def buckets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketArgs']]]]):
        pulumi.set(self, "buckets", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the object storage instance to be created
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ObjectStorageState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 buckets: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketArgs']]]] = None,
                 created: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 used_space: Optional[pulumi.Input[builtins.int]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObjectStorage resources.
        :param pulumi.Input[builtins.str] access_key: The access key used to identify user. Can be set to an empty string, which will tell the provider to get the access key
               from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_{name}". {name} is the
               name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-) should
               be replaced with underscores (_). For example, object storage named "my-files" would use environment variable named
               "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_MY_FILES".
        :param pulumi.Input[builtins.str] description: The description of the object storage instance to be created
        :param pulumi.Input[builtins.str] name: The name of the object storage instance to be created
        :param pulumi.Input[builtins.str] secret_key: The secret key used to authenticate user. Can be set to an empty string, which will tell the provider to get the secret
               key from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_{name}". {name} is
               the name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-)
               should be replaced with underscores (_). For example, object storage named "my-files" would use environment variable
               named "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_MY_FILES".
        :param pulumi.Input[builtins.int] size: The size of the object storage instance in gigabytes
        :param pulumi.Input[builtins.str] zone: The zone in which the object storage instance will be created, e.g. `de-fra1`. You can list available zones with `upctl
               zone list`.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if buckets is not None:
            pulumi.set(__self__, "buckets", buckets)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if used_space is not None:
            pulumi.set(__self__, "used_space", used_space)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key used to identify user. Can be set to an empty string, which will tell the provider to get the access key
        from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_{name}". {name} is the
        name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-) should
        be replaced with underscores (_). For example, object storage named "my-files" would use environment variable named
        "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_MY_FILES".
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def buckets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketArgs']]]]:
        return pulumi.get(self, "buckets")

    @buckets.setter
    def buckets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketArgs']]]]):
        pulumi.set(self, "buckets", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the object storage instance to be created
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the object storage instance to be created
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret key used to authenticate user. Can be set to an empty string, which will tell the provider to get the secret
        key from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_{name}". {name} is
        the name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-)
        should be replaced with underscores (_). For example, object storage named "my-files" would use environment variable
        named "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_MY_FILES".
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size of the object storage instance in gigabytes
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="usedSpace")
    def used_space(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "used_space")

    @used_space.setter
    def used_space(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "used_space", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone in which the object storage instance will be created, e.g. `de-fra1`. You can list available zones with `upctl
        zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


class ObjectStorage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 buckets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStorageBucketArgs', 'ObjectStorageBucketArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > The `ObjectStorage` resource manages previous generatation object storage instances that will reach end of life (EOL) by the end of 2024. For new instances, consider using the new Object Storage product managed with `ManagedObjectStorage` resource.

        This resource represents an UpCloud Object Storage instance, which provides S3 compatible storage.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Object storage instance called storage-name in the fi-hel2 zone, with 2 buckets called "products" and "images".
        my_object_storage = upcloud.ObjectStorage("my_object_storage",
            size=250,
            name="storage-name",
            zone="fi-hel2",
            access_key="admin",
            secret_key="changeme",
            description="catalogue",
            buckets=[
                {
                    "name": "products",
                },
                {
                    "name": "images",
                },
            ])
        ```

        ## Import

        For object storage import to work properly, you need to set environment variables for access and secret key.

        The environment variables names are UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_{name} and UPCLOUD_OBJECT_STORAGE_SECRET_KEY_{name}

        where {name} is the name of your object storage instance (not the resource label!), all uppercased, and with all dashes (-)

        replaced with underscores (_). So importing an object storage that is named "my-storage" will look like this:

        UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_MY_STORAGE=accesskey \\

        UPCLOUD_OBJECT_STORAGE_SECRET_KEY_MY_STORAGE=supersecret \\

        ```sh
        $ pulumi import upcloud:index/objectStorage:ObjectStorage example_storage 06c1f4b6-faf2-47d0-8896-1d941092b009
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key: The access key used to identify user. Can be set to an empty string, which will tell the provider to get the access key
               from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_{name}". {name} is the
               name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-) should
               be replaced with underscores (_). For example, object storage named "my-files" would use environment variable named
               "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_MY_FILES".
        :param pulumi.Input[builtins.str] description: The description of the object storage instance to be created
        :param pulumi.Input[builtins.str] name: The name of the object storage instance to be created
        :param pulumi.Input[builtins.str] secret_key: The secret key used to authenticate user. Can be set to an empty string, which will tell the provider to get the secret
               key from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_{name}". {name} is
               the name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-)
               should be replaced with underscores (_). For example, object storage named "my-files" would use environment variable
               named "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_MY_FILES".
        :param pulumi.Input[builtins.int] size: The size of the object storage instance in gigabytes
        :param pulumi.Input[builtins.str] zone: The zone in which the object storage instance will be created, e.g. `de-fra1`. You can list available zones with `upctl
               zone list`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectStorageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > The `ObjectStorage` resource manages previous generatation object storage instances that will reach end of life (EOL) by the end of 2024. For new instances, consider using the new Object Storage product managed with `ManagedObjectStorage` resource.

        This resource represents an UpCloud Object Storage instance, which provides S3 compatible storage.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Object storage instance called storage-name in the fi-hel2 zone, with 2 buckets called "products" and "images".
        my_object_storage = upcloud.ObjectStorage("my_object_storage",
            size=250,
            name="storage-name",
            zone="fi-hel2",
            access_key="admin",
            secret_key="changeme",
            description="catalogue",
            buckets=[
                {
                    "name": "products",
                },
                {
                    "name": "images",
                },
            ])
        ```

        ## Import

        For object storage import to work properly, you need to set environment variables for access and secret key.

        The environment variables names are UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_{name} and UPCLOUD_OBJECT_STORAGE_SECRET_KEY_{name}

        where {name} is the name of your object storage instance (not the resource label!), all uppercased, and with all dashes (-)

        replaced with underscores (_). So importing an object storage that is named "my-storage" will look like this:

        UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_MY_STORAGE=accesskey \\

        UPCLOUD_OBJECT_STORAGE_SECRET_KEY_MY_STORAGE=supersecret \\

        ```sh
        $ pulumi import upcloud:index/objectStorage:ObjectStorage example_storage 06c1f4b6-faf2-47d0-8896-1d941092b009
        ```

        :param str resource_name: The name of the resource.
        :param ObjectStorageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectStorageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 buckets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStorageBucketArgs', 'ObjectStorageBucketArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectStorageArgs.__new__(ObjectStorageArgs)

            if access_key is None and not opts.urn:
                raise TypeError("Missing required property 'access_key'")
            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["buckets"] = buckets
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if secret_key is None and not opts.urn:
                raise TypeError("Missing required property 'secret_key'")
            __props__.__dict__["secret_key"] = secret_key
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["url"] = None
            __props__.__dict__["used_space"] = None
        super(ObjectStorage, __self__).__init__(
            'upcloud:index/objectStorage:ObjectStorage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[builtins.str]] = None,
            buckets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStorageBucketArgs', 'ObjectStorageBucketArgsDict']]]]] = None,
            created: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            secret_key: Optional[pulumi.Input[builtins.str]] = None,
            size: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None,
            used_space: Optional[pulumi.Input[builtins.int]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'ObjectStorage':
        """
        Get an existing ObjectStorage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key: The access key used to identify user. Can be set to an empty string, which will tell the provider to get the access key
               from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_{name}". {name} is the
               name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-) should
               be replaced with underscores (_). For example, object storage named "my-files" would use environment variable named
               "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_MY_FILES".
        :param pulumi.Input[builtins.str] description: The description of the object storage instance to be created
        :param pulumi.Input[builtins.str] name: The name of the object storage instance to be created
        :param pulumi.Input[builtins.str] secret_key: The secret key used to authenticate user. Can be set to an empty string, which will tell the provider to get the secret
               key from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_{name}". {name} is
               the name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-)
               should be replaced with underscores (_). For example, object storage named "my-files" would use environment variable
               named "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_MY_FILES".
        :param pulumi.Input[builtins.int] size: The size of the object storage instance in gigabytes
        :param pulumi.Input[builtins.str] zone: The zone in which the object storage instance will be created, e.g. `de-fra1`. You can list available zones with `upctl
               zone list`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectStorageState.__new__(_ObjectStorageState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["buckets"] = buckets
        __props__.__dict__["created"] = created
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["size"] = size
        __props__.__dict__["state"] = state
        __props__.__dict__["url"] = url
        __props__.__dict__["used_space"] = used_space
        __props__.__dict__["zone"] = zone
        return ObjectStorage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[builtins.str]:
        """
        The access key used to identify user. Can be set to an empty string, which will tell the provider to get the access key
        from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_{name}". {name} is the
        name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-) should
        be replaced with underscores (_). For example, object storage named "my-files" would use environment variable named
        "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_MY_FILES".
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def buckets(self) -> pulumi.Output[Optional[Sequence['outputs.ObjectStorageBucket']]]:
        return pulumi.get(self, "buckets")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the object storage instance to be created
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the object storage instance to be created
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[builtins.str]:
        """
        The secret key used to authenticate user. Can be set to an empty string, which will tell the provider to get the secret
        key from environment variable. The environment variable should be "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_{name}". {name} is
        the name given to object storage instance (so not the resource label), it should be all uppercased and all dashes (-)
        should be replaced with underscores (_). For example, object storage named "my-files" would use environment variable
        named "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_MY_FILES".
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[builtins.int]:
        """
        The size of the object storage instance in gigabytes
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="usedSpace")
    def used_space(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "used_space")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        The zone in which the object storage instance will be created, e.g. `de-fra1`. You can list available zones with `upctl
        zone list`.
        """
        return pulumi.get(self, "zone")

