"""add organization id to jobs model

Revision ID: 5d27a719b24d
Revises: 18ff61fbc034
Create Date: 2025-09-10 23:01:45.214589

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "5d27a719b24d"
down_revision: Union[str, None] = "18ff61fbc034"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.add_column(sa.Column("organization_id", sa.String(), nullable=True))
        batch_op.create_foreign_key("fk_jobs_organization_id", "organizations", ["organization_id"], ["id"])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_constraint("fk_jobs_organization_id", type_="foreignkey")
        batch_op.drop_column("organization_id")
    # ### end Alembic commands ###
