"""Add error tracking to steps table

Revision ID: f7f757414d20
Revises: 05c3bc564286
Create Date: 2025-08-05 18:17:06.026153

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "f7f757414d20"
down_revision: Union[str, None] = "05c3bc564286"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    # Create the enum type first
    stepstatus = sa.Enum("PENDING", "SUCCESS", "FAILED", "CANCELLED", name="stepstatus")
    stepstatus.create(op.get_bind(), checkfirst=True)

    op.add_column("steps", sa.Column("error_type", sa.String(), nullable=True))
    op.add_column("steps", sa.Column("error_data", sa.JSON(), nullable=True))
    op.add_column("steps", sa.Column("status", stepstatus, nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("steps", "status")
    op.drop_column("steps", "error_data")
    op.drop_column("steps", "error_type")

    # Drop the enum type
    stepstatus = sa.Enum("PENDING", "SUCCESS", "FAILED", "CANCELLED", name="stepstatus")
    stepstatus.drop(op.get_bind(), checkfirst=True)
    # ### end Alembic commands ###
