import * as cdk from 'aws-cdk-lib';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
export interface ImmuKVStackProps extends cdk.StackProps {
    /**
     * Name of the S3 bucket for ImmuKV storage
     * @default - Auto-generated bucket name
     */
    readonly bucketName?: string;
    /**
     * S3 prefix for all ImmuKV objects
     * @default - No prefix (root of bucket)
     */
    readonly s3Prefix?: string;
    /**
     * Number of days to retain old log versions
     * @default 365
     */
    readonly logVersionRetentionDays?: number;
    /**
     * Number of old log versions to retain
     * @default 1000
     */
    readonly logVersionsToRetain?: number;
    /**
     * Number of days to retain old key object versions
     * @default 365
     */
    readonly keyVersionRetentionDays?: number;
    /**
     * Number of old key versions to retain per key
     * @default 100
     */
    readonly keyVersionsToRetain?: number;
    /**
     * Enable KMS encryption instead of S3-managed encryption
     * @default false
     */
    readonly useKmsEncryption?: boolean;
}
/**
 * AWS CDK Stack for ImmuKV infrastructure
 *
 * Creates an S3 bucket with versioning enabled and IAM policies for
 * read/write and read-only access.
 */
export declare class ImmuKVStack extends cdk.Stack {
    /**
     * The S3 bucket used for ImmuKV storage
     */
    readonly bucket: s3.Bucket;
    /**
     * IAM managed policy for read/write access
     */
    readonly readWritePolicy: iam.ManagedPolicy;
    /**
     * IAM managed policy for read-only access
     */
    readonly readOnlyPolicy: iam.ManagedPolicy;
    constructor(scope: Construct, id: string, props?: ImmuKVStackProps);
}
