from .imports import *

def get_initial_caller() -> str:
    """
    Return the TRUE original caller: the entrypoint script that launched the program.
    """
    main_mod = sys.modules.get('__main__')
    
    # interactive environments (REPL) may have no __file__
    if not main_mod or not hasattr(main_mod, '__file__'):
        return None

    return os.path.realpath(main_mod.__file__)
def get_initial_caller_dir() -> str:
    """
    Return the directory of the TRUE original entrypoint script.
    """
    caller = get_initial_caller()
    return os.path.dirname(caller) if caller else None
def get_initial_caller_dir(_INITIAL_CALLER_DIR=None) -> str:
    """
    Return the directory of the script that FIRST started execution.
    Works even when this function is called from imported modules.
    """


    # Cache it after first calculation
    if _INITIAL_CALLER_DIR is not None:
        return _INITIAL_CALLER_DIR

    main_mod = sys.modules.get('__main__')

    # If Python was run in an interactive environment
    if not main_mod or not hasattr(main_mod, '__file__'):
        _INITIAL_CALLER_DIR = os.getcwd()
        return _INITIAL_CALLER_DIR

    # RESOLVE the true initial script location
    initial_file = os.path.realpath(main_mod.__file__)
    _INITIAL_CALLER_DIR = os.path.dirname(initial_file)
    return _INITIAL_CALLER_DIR
def get_caller(i: Optional[int] = None) -> str:
    """
    Return the filename of the calling frame.

    Args:
        i: Optional stack depth offset. 
           None = immediate caller (depth 1).

    Returns:
        Absolute path of the file for the stack frame.
    """
    depth = 1 if i is None else int(i)
    stack = inspect.stack()
    if depth >= len(stack):
        depth = len(stack) - 1
    return stack[depth].filename


def get_caller_path(i: Optional[int] = None) -> str:
    """
    Return the absolute path of the caller's file.
    """
    depth = 1 if i is None else int(i)
    file_path = get_caller(depth + 1)
    return os.path.realpath(file_path)


def get_caller_dir(i: Optional[int] = None) -> str:
    """
    Return the absolute directory of the caller's file.
    """
    depth = 1 if i is None else int(i)
    abspath = get_caller_path(depth + 1)
    return os.path.dirname(abspath)
