# This file was auto-generated by Fern from our API Definition.

# isort: skip_file

import typing
from importlib import import_module

if typing.TYPE_CHECKING:
    from .types import (
        Account,
        AccountAccountType,
        AccountAccountTypeEnum,
        AccountClassification,
        AccountCurrency,
        AccountDetails,
        AccountDetailsAndActions,
        AccountDetailsAndActionsCategory,
        AccountDetailsAndActionsIntegration,
        AccountDetailsAndActionsStatus,
        AccountDetailsAndActionsStatusEnum,
        AccountDetailsCategory,
        AccountIntegration,
        AccountRequest,
        AccountRequestAccountType,
        AccountRequestClassification,
        AccountRequestCurrency,
        AccountRequestStatus,
        AccountResponse,
        AccountStatus,
        AccountStatusEnum,
        AccountToken,
        AccountingAttachment,
        AccountingAttachmentRequest,
        AccountingAttachmentResponse,
        AccountingPeriod,
        AccountingPeriodStatus,
        AccountingPhoneNumber,
        AccountingPhoneNumberRequest,
        Address,
        AddressCountry,
        AddressRequest,
        AddressRequestCountry,
        AddressRequestType,
        AddressType,
        AddressTypeEnum,
        AdvancedMetadata,
        AsyncPassthroughReciept,
        AsyncPostTask,
        AsyncPostTaskResult,
        AsyncPostTaskStatus,
        AsyncPostTaskStatusEnum,
        AuditLogEvent,
        AuditLogEventEventType,
        AuditLogEventRole,
        AvailableActions,
        BalanceSheet,
        BalanceSheetCompany,
        BalanceSheetCurrency,
        BankFeedAccount,
        BankFeedAccountAccountType,
        BankFeedAccountAccountTypeEnum,
        BankFeedAccountCurrency,
        BankFeedAccountFeedStatus,
        BankFeedAccountRequest,
        BankFeedAccountRequestAccountType,
        BankFeedAccountRequestCurrency,
        BankFeedAccountRequestFeedStatus,
        BankFeedAccountResponse,
        BankFeedTransaction,
        BankFeedTransactionBankFeedAccount,
        BankFeedTransactionCreditOrDebit,
        BankFeedTransactionRequestRequest,
        BankFeedTransactionRequestRequestBankFeedAccount,
        BankFeedTransactionRequestRequestCreditOrDebit,
        BankFeedTransactionResponse,
        CashFlowStatement,
        CashFlowStatementCompany,
        CashFlowStatementCurrency,
        CategoriesEnum,
        CategoryEnum,
        CategoryTypeEnum,
        ClassificationEnum,
        CommonModelScopeApi,
        CommonModelScopesBodyRequest,
        CompanyInfo,
        CompanyInfoCurrency,
        ComponentTypeEnum,
        Contact,
        ContactAddressesItem,
        ContactRequest,
        ContactRequestAddressesItem,
        ContactRequestStatus,
        ContactResponse,
        ContactStatus,
        CountryEnum,
        CreditNote,
        CreditNoteAccountingPeriod,
        CreditNoteAppliedPaymentsItem,
        CreditNoteApplyLineForCreditNote,
        CreditNoteApplyLineForCreditNoteInvoice,
        CreditNoteApplyLineForCreditNoteRequest,
        CreditNoteApplyLineForCreditNoteRequestInvoice,
        CreditNoteApplyLineForInvoice,
        CreditNoteApplyLineForInvoiceCreditNote,
        CreditNoteCompany,
        CreditNoteContact,
        CreditNoteCurrency,
        CreditNoteLineItem,
        CreditNoteLineItemCompany,
        CreditNoteLineItemContact,
        CreditNoteLineItemItem,
        CreditNoteLineItemProject,
        CreditNoteLineItemRequest,
        CreditNoteLineItemRequestCompany,
        CreditNoteLineItemRequestContact,
        CreditNoteLineItemRequestItem,
        CreditNoteLineItemRequestProject,
        CreditNotePaymentsItem,
        CreditNoteRequest,
        CreditNoteRequestAccountingPeriod,
        CreditNoteRequestAppliedPaymentsItem,
        CreditNoteRequestCompany,
        CreditNoteRequestContact,
        CreditNoteRequestCurrency,
        CreditNoteRequestLineItemsItem,
        CreditNoteRequestPaymentsItem,
        CreditNoteRequestStatus,
        CreditNoteRequestTrackingCategoriesItem,
        CreditNoteResponse,
        CreditNoteStatus,
        CreditNoteStatusEnum,
        CreditNoteTrackingCategoriesItem,
        CreditOrDebitEnum,
        DataPassthroughRequest,
        DataPassthroughRequestMethod,
        DebugModeLog,
        DebugModelLogSummary,
        Employee,
        EmployeeCompany,
        EmployeeStatus,
        EnabledActionsEnum,
        EncodingEnum,
        ErrorValidationProblem,
        EventTypeEnum,
        Expense,
        ExpenseAccount,
        ExpenseAccountingPeriod,
        ExpenseCompany,
        ExpenseContact,
        ExpenseCurrency,
        ExpenseEmployee,
        ExpenseLine,
        ExpenseLineAccount,
        ExpenseLineContact,
        ExpenseLineCurrency,
        ExpenseLineEmployee,
        ExpenseLineItem,
        ExpenseLineProject,
        ExpenseLineRequest,
        ExpenseLineRequestAccount,
        ExpenseLineRequestContact,
        ExpenseLineRequestCurrency,
        ExpenseLineRequestEmployee,
        ExpenseLineRequestItem,
        ExpenseLineRequestProject,
        ExpenseLineRequestTrackingCategoriesItem,
        ExpenseLineRequestTrackingCategory,
        ExpenseLineTrackingCategoriesItem,
        ExpenseLineTrackingCategory,
        ExpenseReport,
        ExpenseReportCompany,
        ExpenseReportLine,
        ExpenseReportLineAccount,
        ExpenseReportLineCompany,
        ExpenseReportLineContact,
        ExpenseReportLineEmployee,
        ExpenseReportLineProject,
        ExpenseReportLineRequest,
        ExpenseReportLineRequestAccount,
        ExpenseReportLineRequestCompany,
        ExpenseReportLineRequestContact,
        ExpenseReportLineRequestEmployee,
        ExpenseReportLineRequestProject,
        ExpenseReportLineRequestTaxRate,
        ExpenseReportLineTaxRate,
        ExpenseReportRequest,
        ExpenseReportRequestAccountingPeriod,
        ExpenseReportRequestCompany,
        ExpenseReportRequestEmployee,
        ExpenseReportResponse,
        ExpenseReportStatus,
        ExpenseReportStatusEnum,
        ExpenseRequest,
        ExpenseRequestAccount,
        ExpenseRequestAccountingPeriod,
        ExpenseRequestCompany,
        ExpenseRequestContact,
        ExpenseRequestCurrency,
        ExpenseRequestEmployee,
        ExpenseRequestTrackingCategoriesItem,
        ExpenseResponse,
        ExpenseTrackingCategoriesItem,
        ExternalTargetFieldApi,
        ExternalTargetFieldApiResponse,
        FeedStatusEnum,
        FieldFormatEnum,
        FieldMappingApiInstance,
        FieldMappingApiInstanceRemoteField,
        FieldMappingApiInstanceRemoteFieldRemoteEndpointInfo,
        FieldMappingApiInstanceResponse,
        FieldMappingApiInstanceTargetField,
        FieldMappingInstanceResponse,
        FieldPermissionDeserializer,
        FieldPermissionDeserializerRequest,
        FieldTypeEnum,
        GeneralLedgerTransaction,
        GeneralLedgerTransactionAccountingPeriod,
        GeneralLedgerTransactionCompany,
        GeneralLedgerTransactionGeneralLedgerTransactionLinesItem,
        GeneralLedgerTransactionLine,
        GeneralLedgerTransactionLineAccount,
        GeneralLedgerTransactionLineBaseCurrency,
        GeneralLedgerTransactionLineCompany,
        GeneralLedgerTransactionLineContact,
        GeneralLedgerTransactionLineEmployee,
        GeneralLedgerTransactionLineItem,
        GeneralLedgerTransactionLineProject,
        GeneralLedgerTransactionLineTrackingCategoriesItem,
        GeneralLedgerTransactionLineTransactionCurrency,
        GeneralLedgerTransactionTrackingCategoriesItem,
        GeneralLedgerTransactionUnderlyingTransactionType,
        IncomeStatement,
        IncomeStatementCompany,
        IncomeStatementCurrency,
        IndividualCommonModelScopeDeserializer,
        IndividualCommonModelScopeDeserializerRequest,
        Invoice,
        InvoiceAccountingPeriod,
        InvoiceAppliedCreditNotesItem,
        InvoiceAppliedPaymentsItem,
        InvoiceAppliedVendorCreditsItem,
        InvoiceCompany,
        InvoiceContact,
        InvoiceCurrency,
        InvoiceEmployee,
        InvoiceLineItem,
        InvoiceLineItemAccount,
        InvoiceLineItemContact,
        InvoiceLineItemCurrency,
        InvoiceLineItemEmployee,
        InvoiceLineItemItem,
        InvoiceLineItemProject,
        InvoiceLineItemRequest,
        InvoiceLineItemRequestAccount,
        InvoiceLineItemRequestContact,
        InvoiceLineItemRequestCurrency,
        InvoiceLineItemRequestEmployee,
        InvoiceLineItemRequestItem,
        InvoiceLineItemRequestProject,
        InvoiceLineItemRequestTrackingCategoriesItem,
        InvoiceLineItemRequestTrackingCategory,
        InvoiceLineItemTrackingCategoriesItem,
        InvoiceLineItemTrackingCategory,
        InvoicePaymentTerm,
        InvoicePaymentsItem,
        InvoicePurchaseOrdersItem,
        InvoiceRequest,
        InvoiceRequestCompany,
        InvoiceRequestContact,
        InvoiceRequestCurrency,
        InvoiceRequestEmployee,
        InvoiceRequestPaymentTerm,
        InvoiceRequestPaymentsItem,
        InvoiceRequestPurchaseOrdersItem,
        InvoiceRequestStatus,
        InvoiceRequestTrackingCategoriesItem,
        InvoiceRequestType,
        InvoiceResponse,
        InvoiceStatus,
        InvoiceStatusEnum,
        InvoiceTrackingCategoriesItem,
        InvoiceType,
        InvoiceTypeEnum,
        Issue,
        IssueStatus,
        IssueStatusEnum,
        Item,
        ItemCompany,
        ItemFormatEnum,
        ItemPurchaseAccount,
        ItemPurchaseTaxRate,
        ItemRequestRequest,
        ItemRequestRequestCompany,
        ItemRequestRequestPurchaseAccount,
        ItemRequestRequestPurchaseTaxRate,
        ItemRequestRequestSalesAccount,
        ItemRequestRequestSalesTaxRate,
        ItemRequestRequestStatus,
        ItemRequestRequestType,
        ItemResponse,
        ItemSalesAccount,
        ItemSalesTaxRate,
        ItemSchema,
        ItemStatus,
        ItemType,
        ItemTypeEnum,
        JournalEntry,
        JournalEntryAccountingPeriod,
        JournalEntryAppliedPaymentsItem,
        JournalEntryCompany,
        JournalEntryCurrency,
        JournalEntryPaymentsItem,
        JournalEntryPostingStatus,
        JournalEntryRequest,
        JournalEntryRequestCompany,
        JournalEntryRequestCurrency,
        JournalEntryRequestPaymentsItem,
        JournalEntryRequestPostingStatus,
        JournalEntryRequestTrackingCategoriesItem,
        JournalEntryResponse,
        JournalEntryTrackingCategoriesItem,
        JournalLine,
        JournalLineAccount,
        JournalLineCurrency,
        JournalLineProject,
        JournalLineRequest,
        JournalLineRequestAccount,
        JournalLineRequestCurrency,
        JournalLineRequestProject,
        JournalLineRequestTrackingCategoriesItem,
        JournalLineRequestTrackingCategory,
        JournalLineTrackingCategoriesItem,
        JournalLineTrackingCategory,
        LanguageEnum,
        LastSyncResultEnum,
        LinkToken,
        LinkedAccountStatus,
        MetaResponse,
        MethodEnum,
        MethodTypeEnum,
        ModelOperation,
        ModelPermissionDeserializer,
        ModelPermissionDeserializerRequest,
        MultipartFormFieldRequest,
        MultipartFormFieldRequestEncoding,
        PaginatedAccountDetailsAndActionsList,
        PaginatedAccountList,
        PaginatedAccountingAttachmentList,
        PaginatedAccountingPeriodList,
        PaginatedAuditLogEventList,
        PaginatedBalanceSheetList,
        PaginatedBankFeedAccountList,
        PaginatedBankFeedTransactionList,
        PaginatedCashFlowStatementList,
        PaginatedCompanyInfoList,
        PaginatedContactList,
        PaginatedCreditNoteList,
        PaginatedEmployeeList,
        PaginatedExpenseList,
        PaginatedExpenseReportLineList,
        PaginatedExpenseReportList,
        PaginatedGeneralLedgerTransactionList,
        PaginatedIncomeStatementList,
        PaginatedInvoiceList,
        PaginatedIssueList,
        PaginatedItemList,
        PaginatedJournalEntryList,
        PaginatedPaymentList,
        PaginatedPaymentMethodList,
        PaginatedPaymentTermList,
        PaginatedProjectList,
        PaginatedPurchaseOrderList,
        PaginatedRemoteFieldClassList,
        PaginatedSyncStatusList,
        PaginatedTaxRateList,
        PaginatedTrackingCategoryList,
        PaginatedTransactionList,
        PaginatedVendorCreditList,
        PatchedContactRequest,
        PatchedContactRequestAddressesItem,
        PatchedItemRequestRequest,
        PatchedItemRequestRequestStatus,
        PatchedItemRequestRequestType,
        PatchedPaymentRequest,
        PatchedPaymentRequestAccount,
        PatchedPaymentRequestAccountingPeriod,
        PatchedPaymentRequestAppliedToLinesItem,
        PatchedPaymentRequestCompany,
        PatchedPaymentRequestContact,
        PatchedPaymentRequestCurrency,
        PatchedPaymentRequestPaymentMethod,
        PatchedPaymentRequestTrackingCategoriesItem,
        PatchedPaymentRequestType,
        Payment,
        PaymentAccount,
        PaymentAccountingPeriod,
        PaymentAppliedToLinesItem,
        PaymentCompany,
        PaymentContact,
        PaymentCurrency,
        PaymentLineItem,
        PaymentLineItemRequest,
        PaymentMethod,
        PaymentMethodMethodType,
        PaymentPaymentMethod,
        PaymentRequest,
        PaymentRequestAccount,
        PaymentRequestAccountingPeriod,
        PaymentRequestAppliedToLinesItem,
        PaymentRequestCompany,
        PaymentRequestContact,
        PaymentRequestCurrency,
        PaymentRequestPaymentMethod,
        PaymentRequestTrackingCategoriesItem,
        PaymentRequestType,
        PaymentResponse,
        PaymentTerm,
        PaymentTermCompany,
        PaymentTrackingCategoriesItem,
        PaymentType,
        PaymentTypeEnum,
        PostingStatusEnum,
        Project,
        ProjectCompany,
        ProjectContact,
        PurchaseOrder,
        PurchaseOrderAccountingPeriod,
        PurchaseOrderCompany,
        PurchaseOrderCurrency,
        PurchaseOrderDeliveryAddress,
        PurchaseOrderLineItem,
        PurchaseOrderLineItemCurrency,
        PurchaseOrderLineItemItem,
        PurchaseOrderLineItemRequest,
        PurchaseOrderLineItemRequestCurrency,
        PurchaseOrderLineItemRequestItem,
        PurchaseOrderPaymentTerm,
        PurchaseOrderRequest,
        PurchaseOrderRequestCompany,
        PurchaseOrderRequestCurrency,
        PurchaseOrderRequestDeliveryAddress,
        PurchaseOrderRequestPaymentTerm,
        PurchaseOrderRequestStatus,
        PurchaseOrderRequestTrackingCategoriesItem,
        PurchaseOrderRequestVendor,
        PurchaseOrderResponse,
        PurchaseOrderStatus,
        PurchaseOrderStatusEnum,
        PurchaseOrderTrackingCategoriesItem,
        PurchaseOrderVendor,
        RemoteData,
        RemoteEndpointInfo,
        RemoteField,
        RemoteFieldApi,
        RemoteFieldApiCoverage,
        RemoteFieldApiResponse,
        RemoteFieldClass,
        RemoteFieldRemoteFieldClass,
        RemoteFieldRequest,
        RemoteFieldRequestRemoteFieldClass,
        RemoteKey,
        RemoteResponse,
        ReportItem,
        RequestFormatEnum,
        ResponseTypeEnum,
        RoleEnum,
        SelectiveSyncConfigurationsUsageEnum,
        Status7D1Enum,
        Status895Enum,
        StatusFd5Enum,
        SyncStatus,
        SyncStatusStatus,
        TaxComponent,
        TaxComponentComponentType,
        TaxRate,
        TaxRateCompany,
        TaxRateStatus,
        TaxRateTaxComponentsItem,
        TrackingCategory,
        TrackingCategoryCategoryType,
        TrackingCategoryCompany,
        TrackingCategoryStatus,
        Transaction,
        TransactionAccount,
        TransactionAccountingPeriod,
        TransactionContact,
        TransactionCurrency,
        TransactionCurrencyEnum,
        TransactionLineItem,
        TransactionLineItemCurrency,
        TransactionLineItemItem,
        TransactionTrackingCategoriesItem,
        Type2BbEnum,
        UnderlyingTransactionTypeEnum,
        ValidationProblemSource,
        VendorCredit,
        VendorCreditAccountingPeriod,
        VendorCreditApplyLineForInvoice,
        VendorCreditApplyLineForInvoiceVendorCredit,
        VendorCreditApplyLineForVendorCredit,
        VendorCreditApplyLineForVendorCreditInvoice,
        VendorCreditApplyLineForVendorCreditRequest,
        VendorCreditApplyLineForVendorCreditRequestInvoice,
        VendorCreditCompany,
        VendorCreditCurrency,
        VendorCreditLine,
        VendorCreditLineAccount,
        VendorCreditLineContact,
        VendorCreditLineProject,
        VendorCreditLineRequest,
        VendorCreditLineRequestAccount,
        VendorCreditLineRequestContact,
        VendorCreditLineRequestProject,
        VendorCreditRequest,
        VendorCreditRequestAccountingPeriod,
        VendorCreditRequestCompany,
        VendorCreditRequestCurrency,
        VendorCreditRequestTrackingCategoriesItem,
        VendorCreditRequestVendor,
        VendorCreditResponse,
        VendorCreditTrackingCategoriesItem,
        VendorCreditVendor,
        WarningValidationProblem,
        WebhookReceiver,
    )
    from .resources import (
        AccountsListRequestRemoteFields,
        AccountsListRequestShowEnumOrigins,
        AccountsRetrieveRequestRemoteFields,
        AccountsRetrieveRequestShowEnumOrigins,
        AsyncPassthroughRetrieveResponse,
        CompanyInfoListRequestExpand,
        CompanyInfoRetrieveRequestExpand,
        ContactsListRequestExpand,
        ContactsRetrieveRequestExpand,
        CreditNotesListRequestExpand,
        CreditNotesListRequestRemoteFields,
        CreditNotesListRequestShowEnumOrigins,
        CreditNotesRetrieveRequestExpand,
        CreditNotesRetrieveRequestRemoteFields,
        CreditNotesRetrieveRequestShowEnumOrigins,
        EndUserDetailsRequestLanguage,
        ExpenseReportsLinesListRequestExpand,
        ExpenseReportsListRequestExpand,
        ExpenseReportsRetrieveRequestExpand,
        ExpensesListRequestExpand,
        ExpensesRetrieveRequestExpand,
        GeneralLedgerTransactionsListRequestExpand,
        GeneralLedgerTransactionsRetrieveRequestExpand,
        InvoicesListRequestExpand,
        InvoicesListRequestStatus,
        InvoicesListRequestType,
        InvoicesRetrieveRequestExpand,
        IssuesListRequestStatus,
        ItemsListRequestExpand,
        ItemsRetrieveRequestExpand,
        JournalEntriesListRequestExpand,
        JournalEntriesRetrieveRequestExpand,
        LinkedAccountsListRequestCategory,
        PaymentsListRequestExpand,
        PaymentsRetrieveRequestExpand,
        ProjectsListRequestExpand,
        ProjectsRetrieveRequestExpand,
        PurchaseOrdersListRequestExpand,
        PurchaseOrdersRetrieveRequestExpand,
        TransactionsListRequestExpand,
        TransactionsRetrieveRequestExpand,
        VendorCreditsListRequestExpand,
        VendorCreditsRetrieveRequestExpand,
        account_details,
        account_token,
        accounting_periods,
        accounts,
        addresses,
        async_passthrough,
        async_tasks,
        attachments,
        audit_trail,
        available_actions,
        balance_sheets,
        bank_feed_accounts,
        bank_feed_transactions,
        cash_flow_statements,
        company_info,
        contacts,
        credit_notes,
        delete_account,
        employees,
        expense_reports,
        expenses,
        field_mapping,
        force_resync,
        general_ledger_transactions,
        generate_key,
        income_statements,
        invoices,
        issues,
        items,
        journal_entries,
        link_token,
        linked_accounts,
        passthrough,
        payment_methods,
        payment_terms,
        payments,
        phone_numbers,
        projects,
        purchase_orders,
        regenerate_key,
        scopes,
        sync_status,
        tax_rates,
        tracking_categories,
        transactions,
        vendor_credits,
        webhook_receivers,
    )
_dynamic_imports: typing.Dict[str, str] = {
    "Account": ".types",
    "AccountAccountType": ".types",
    "AccountAccountTypeEnum": ".types",
    "AccountClassification": ".types",
    "AccountCurrency": ".types",
    "AccountDetails": ".types",
    "AccountDetailsAndActions": ".types",
    "AccountDetailsAndActionsCategory": ".types",
    "AccountDetailsAndActionsIntegration": ".types",
    "AccountDetailsAndActionsStatus": ".types",
    "AccountDetailsAndActionsStatusEnum": ".types",
    "AccountDetailsCategory": ".types",
    "AccountIntegration": ".types",
    "AccountRequest": ".types",
    "AccountRequestAccountType": ".types",
    "AccountRequestClassification": ".types",
    "AccountRequestCurrency": ".types",
    "AccountRequestStatus": ".types",
    "AccountResponse": ".types",
    "AccountStatus": ".types",
    "AccountStatusEnum": ".types",
    "AccountToken": ".types",
    "AccountingAttachment": ".types",
    "AccountingAttachmentRequest": ".types",
    "AccountingAttachmentResponse": ".types",
    "AccountingPeriod": ".types",
    "AccountingPeriodStatus": ".types",
    "AccountingPhoneNumber": ".types",
    "AccountingPhoneNumberRequest": ".types",
    "AccountsListRequestRemoteFields": ".resources",
    "AccountsListRequestShowEnumOrigins": ".resources",
    "AccountsRetrieveRequestRemoteFields": ".resources",
    "AccountsRetrieveRequestShowEnumOrigins": ".resources",
    "Address": ".types",
    "AddressCountry": ".types",
    "AddressRequest": ".types",
    "AddressRequestCountry": ".types",
    "AddressRequestType": ".types",
    "AddressType": ".types",
    "AddressTypeEnum": ".types",
    "AdvancedMetadata": ".types",
    "AsyncPassthroughReciept": ".types",
    "AsyncPassthroughRetrieveResponse": ".resources",
    "AsyncPostTask": ".types",
    "AsyncPostTaskResult": ".types",
    "AsyncPostTaskStatus": ".types",
    "AsyncPostTaskStatusEnum": ".types",
    "AuditLogEvent": ".types",
    "AuditLogEventEventType": ".types",
    "AuditLogEventRole": ".types",
    "AvailableActions": ".types",
    "BalanceSheet": ".types",
    "BalanceSheetCompany": ".types",
    "BalanceSheetCurrency": ".types",
    "BankFeedAccount": ".types",
    "BankFeedAccountAccountType": ".types",
    "BankFeedAccountAccountTypeEnum": ".types",
    "BankFeedAccountCurrency": ".types",
    "BankFeedAccountFeedStatus": ".types",
    "BankFeedAccountRequest": ".types",
    "BankFeedAccountRequestAccountType": ".types",
    "BankFeedAccountRequestCurrency": ".types",
    "BankFeedAccountRequestFeedStatus": ".types",
    "BankFeedAccountResponse": ".types",
    "BankFeedTransaction": ".types",
    "BankFeedTransactionBankFeedAccount": ".types",
    "BankFeedTransactionCreditOrDebit": ".types",
    "BankFeedTransactionRequestRequest": ".types",
    "BankFeedTransactionRequestRequestBankFeedAccount": ".types",
    "BankFeedTransactionRequestRequestCreditOrDebit": ".types",
    "BankFeedTransactionResponse": ".types",
    "CashFlowStatement": ".types",
    "CashFlowStatementCompany": ".types",
    "CashFlowStatementCurrency": ".types",
    "CategoriesEnum": ".types",
    "CategoryEnum": ".types",
    "CategoryTypeEnum": ".types",
    "ClassificationEnum": ".types",
    "CommonModelScopeApi": ".types",
    "CommonModelScopesBodyRequest": ".types",
    "CompanyInfo": ".types",
    "CompanyInfoCurrency": ".types",
    "CompanyInfoListRequestExpand": ".resources",
    "CompanyInfoRetrieveRequestExpand": ".resources",
    "ComponentTypeEnum": ".types",
    "Contact": ".types",
    "ContactAddressesItem": ".types",
    "ContactRequest": ".types",
    "ContactRequestAddressesItem": ".types",
    "ContactRequestStatus": ".types",
    "ContactResponse": ".types",
    "ContactStatus": ".types",
    "ContactsListRequestExpand": ".resources",
    "ContactsRetrieveRequestExpand": ".resources",
    "CountryEnum": ".types",
    "CreditNote": ".types",
    "CreditNoteAccountingPeriod": ".types",
    "CreditNoteAppliedPaymentsItem": ".types",
    "CreditNoteApplyLineForCreditNote": ".types",
    "CreditNoteApplyLineForCreditNoteInvoice": ".types",
    "CreditNoteApplyLineForCreditNoteRequest": ".types",
    "CreditNoteApplyLineForCreditNoteRequestInvoice": ".types",
    "CreditNoteApplyLineForInvoice": ".types",
    "CreditNoteApplyLineForInvoiceCreditNote": ".types",
    "CreditNoteCompany": ".types",
    "CreditNoteContact": ".types",
    "CreditNoteCurrency": ".types",
    "CreditNoteLineItem": ".types",
    "CreditNoteLineItemCompany": ".types",
    "CreditNoteLineItemContact": ".types",
    "CreditNoteLineItemItem": ".types",
    "CreditNoteLineItemProject": ".types",
    "CreditNoteLineItemRequest": ".types",
    "CreditNoteLineItemRequestCompany": ".types",
    "CreditNoteLineItemRequestContact": ".types",
    "CreditNoteLineItemRequestItem": ".types",
    "CreditNoteLineItemRequestProject": ".types",
    "CreditNotePaymentsItem": ".types",
    "CreditNoteRequest": ".types",
    "CreditNoteRequestAccountingPeriod": ".types",
    "CreditNoteRequestAppliedPaymentsItem": ".types",
    "CreditNoteRequestCompany": ".types",
    "CreditNoteRequestContact": ".types",
    "CreditNoteRequestCurrency": ".types",
    "CreditNoteRequestLineItemsItem": ".types",
    "CreditNoteRequestPaymentsItem": ".types",
    "CreditNoteRequestStatus": ".types",
    "CreditNoteRequestTrackingCategoriesItem": ".types",
    "CreditNoteResponse": ".types",
    "CreditNoteStatus": ".types",
    "CreditNoteStatusEnum": ".types",
    "CreditNoteTrackingCategoriesItem": ".types",
    "CreditNotesListRequestExpand": ".resources",
    "CreditNotesListRequestRemoteFields": ".resources",
    "CreditNotesListRequestShowEnumOrigins": ".resources",
    "CreditNotesRetrieveRequestExpand": ".resources",
    "CreditNotesRetrieveRequestRemoteFields": ".resources",
    "CreditNotesRetrieveRequestShowEnumOrigins": ".resources",
    "CreditOrDebitEnum": ".types",
    "DataPassthroughRequest": ".types",
    "DataPassthroughRequestMethod": ".types",
    "DebugModeLog": ".types",
    "DebugModelLogSummary": ".types",
    "Employee": ".types",
    "EmployeeCompany": ".types",
    "EmployeeStatus": ".types",
    "EnabledActionsEnum": ".types",
    "EncodingEnum": ".types",
    "EndUserDetailsRequestLanguage": ".resources",
    "ErrorValidationProblem": ".types",
    "EventTypeEnum": ".types",
    "Expense": ".types",
    "ExpenseAccount": ".types",
    "ExpenseAccountingPeriod": ".types",
    "ExpenseCompany": ".types",
    "ExpenseContact": ".types",
    "ExpenseCurrency": ".types",
    "ExpenseEmployee": ".types",
    "ExpenseLine": ".types",
    "ExpenseLineAccount": ".types",
    "ExpenseLineContact": ".types",
    "ExpenseLineCurrency": ".types",
    "ExpenseLineEmployee": ".types",
    "ExpenseLineItem": ".types",
    "ExpenseLineProject": ".types",
    "ExpenseLineRequest": ".types",
    "ExpenseLineRequestAccount": ".types",
    "ExpenseLineRequestContact": ".types",
    "ExpenseLineRequestCurrency": ".types",
    "ExpenseLineRequestEmployee": ".types",
    "ExpenseLineRequestItem": ".types",
    "ExpenseLineRequestProject": ".types",
    "ExpenseLineRequestTrackingCategoriesItem": ".types",
    "ExpenseLineRequestTrackingCategory": ".types",
    "ExpenseLineTrackingCategoriesItem": ".types",
    "ExpenseLineTrackingCategory": ".types",
    "ExpenseReport": ".types",
    "ExpenseReportCompany": ".types",
    "ExpenseReportLine": ".types",
    "ExpenseReportLineAccount": ".types",
    "ExpenseReportLineCompany": ".types",
    "ExpenseReportLineContact": ".types",
    "ExpenseReportLineEmployee": ".types",
    "ExpenseReportLineProject": ".types",
    "ExpenseReportLineRequest": ".types",
    "ExpenseReportLineRequestAccount": ".types",
    "ExpenseReportLineRequestCompany": ".types",
    "ExpenseReportLineRequestContact": ".types",
    "ExpenseReportLineRequestEmployee": ".types",
    "ExpenseReportLineRequestProject": ".types",
    "ExpenseReportLineRequestTaxRate": ".types",
    "ExpenseReportLineTaxRate": ".types",
    "ExpenseReportRequest": ".types",
    "ExpenseReportRequestAccountingPeriod": ".types",
    "ExpenseReportRequestCompany": ".types",
    "ExpenseReportRequestEmployee": ".types",
    "ExpenseReportResponse": ".types",
    "ExpenseReportStatus": ".types",
    "ExpenseReportStatusEnum": ".types",
    "ExpenseReportsLinesListRequestExpand": ".resources",
    "ExpenseReportsListRequestExpand": ".resources",
    "ExpenseReportsRetrieveRequestExpand": ".resources",
    "ExpenseRequest": ".types",
    "ExpenseRequestAccount": ".types",
    "ExpenseRequestAccountingPeriod": ".types",
    "ExpenseRequestCompany": ".types",
    "ExpenseRequestContact": ".types",
    "ExpenseRequestCurrency": ".types",
    "ExpenseRequestEmployee": ".types",
    "ExpenseRequestTrackingCategoriesItem": ".types",
    "ExpenseResponse": ".types",
    "ExpenseTrackingCategoriesItem": ".types",
    "ExpensesListRequestExpand": ".resources",
    "ExpensesRetrieveRequestExpand": ".resources",
    "ExternalTargetFieldApi": ".types",
    "ExternalTargetFieldApiResponse": ".types",
    "FeedStatusEnum": ".types",
    "FieldFormatEnum": ".types",
    "FieldMappingApiInstance": ".types",
    "FieldMappingApiInstanceRemoteField": ".types",
    "FieldMappingApiInstanceRemoteFieldRemoteEndpointInfo": ".types",
    "FieldMappingApiInstanceResponse": ".types",
    "FieldMappingApiInstanceTargetField": ".types",
    "FieldMappingInstanceResponse": ".types",
    "FieldPermissionDeserializer": ".types",
    "FieldPermissionDeserializerRequest": ".types",
    "FieldTypeEnum": ".types",
    "GeneralLedgerTransaction": ".types",
    "GeneralLedgerTransactionAccountingPeriod": ".types",
    "GeneralLedgerTransactionCompany": ".types",
    "GeneralLedgerTransactionGeneralLedgerTransactionLinesItem": ".types",
    "GeneralLedgerTransactionLine": ".types",
    "GeneralLedgerTransactionLineAccount": ".types",
    "GeneralLedgerTransactionLineBaseCurrency": ".types",
    "GeneralLedgerTransactionLineCompany": ".types",
    "GeneralLedgerTransactionLineContact": ".types",
    "GeneralLedgerTransactionLineEmployee": ".types",
    "GeneralLedgerTransactionLineItem": ".types",
    "GeneralLedgerTransactionLineProject": ".types",
    "GeneralLedgerTransactionLineTrackingCategoriesItem": ".types",
    "GeneralLedgerTransactionLineTransactionCurrency": ".types",
    "GeneralLedgerTransactionTrackingCategoriesItem": ".types",
    "GeneralLedgerTransactionUnderlyingTransactionType": ".types",
    "GeneralLedgerTransactionsListRequestExpand": ".resources",
    "GeneralLedgerTransactionsRetrieveRequestExpand": ".resources",
    "IncomeStatement": ".types",
    "IncomeStatementCompany": ".types",
    "IncomeStatementCurrency": ".types",
    "IndividualCommonModelScopeDeserializer": ".types",
    "IndividualCommonModelScopeDeserializerRequest": ".types",
    "Invoice": ".types",
    "InvoiceAccountingPeriod": ".types",
    "InvoiceAppliedCreditNotesItem": ".types",
    "InvoiceAppliedPaymentsItem": ".types",
    "InvoiceAppliedVendorCreditsItem": ".types",
    "InvoiceCompany": ".types",
    "InvoiceContact": ".types",
    "InvoiceCurrency": ".types",
    "InvoiceEmployee": ".types",
    "InvoiceLineItem": ".types",
    "InvoiceLineItemAccount": ".types",
    "InvoiceLineItemContact": ".types",
    "InvoiceLineItemCurrency": ".types",
    "InvoiceLineItemEmployee": ".types",
    "InvoiceLineItemItem": ".types",
    "InvoiceLineItemProject": ".types",
    "InvoiceLineItemRequest": ".types",
    "InvoiceLineItemRequestAccount": ".types",
    "InvoiceLineItemRequestContact": ".types",
    "InvoiceLineItemRequestCurrency": ".types",
    "InvoiceLineItemRequestEmployee": ".types",
    "InvoiceLineItemRequestItem": ".types",
    "InvoiceLineItemRequestProject": ".types",
    "InvoiceLineItemRequestTrackingCategoriesItem": ".types",
    "InvoiceLineItemRequestTrackingCategory": ".types",
    "InvoiceLineItemTrackingCategoriesItem": ".types",
    "InvoiceLineItemTrackingCategory": ".types",
    "InvoicePaymentTerm": ".types",
    "InvoicePaymentsItem": ".types",
    "InvoicePurchaseOrdersItem": ".types",
    "InvoiceRequest": ".types",
    "InvoiceRequestCompany": ".types",
    "InvoiceRequestContact": ".types",
    "InvoiceRequestCurrency": ".types",
    "InvoiceRequestEmployee": ".types",
    "InvoiceRequestPaymentTerm": ".types",
    "InvoiceRequestPaymentsItem": ".types",
    "InvoiceRequestPurchaseOrdersItem": ".types",
    "InvoiceRequestStatus": ".types",
    "InvoiceRequestTrackingCategoriesItem": ".types",
    "InvoiceRequestType": ".types",
    "InvoiceResponse": ".types",
    "InvoiceStatus": ".types",
    "InvoiceStatusEnum": ".types",
    "InvoiceTrackingCategoriesItem": ".types",
    "InvoiceType": ".types",
    "InvoiceTypeEnum": ".types",
    "InvoicesListRequestExpand": ".resources",
    "InvoicesListRequestStatus": ".resources",
    "InvoicesListRequestType": ".resources",
    "InvoicesRetrieveRequestExpand": ".resources",
    "Issue": ".types",
    "IssueStatus": ".types",
    "IssueStatusEnum": ".types",
    "IssuesListRequestStatus": ".resources",
    "Item": ".types",
    "ItemCompany": ".types",
    "ItemFormatEnum": ".types",
    "ItemPurchaseAccount": ".types",
    "ItemPurchaseTaxRate": ".types",
    "ItemRequestRequest": ".types",
    "ItemRequestRequestCompany": ".types",
    "ItemRequestRequestPurchaseAccount": ".types",
    "ItemRequestRequestPurchaseTaxRate": ".types",
    "ItemRequestRequestSalesAccount": ".types",
    "ItemRequestRequestSalesTaxRate": ".types",
    "ItemRequestRequestStatus": ".types",
    "ItemRequestRequestType": ".types",
    "ItemResponse": ".types",
    "ItemSalesAccount": ".types",
    "ItemSalesTaxRate": ".types",
    "ItemSchema": ".types",
    "ItemStatus": ".types",
    "ItemType": ".types",
    "ItemTypeEnum": ".types",
    "ItemsListRequestExpand": ".resources",
    "ItemsRetrieveRequestExpand": ".resources",
    "JournalEntriesListRequestExpand": ".resources",
    "JournalEntriesRetrieveRequestExpand": ".resources",
    "JournalEntry": ".types",
    "JournalEntryAccountingPeriod": ".types",
    "JournalEntryAppliedPaymentsItem": ".types",
    "JournalEntryCompany": ".types",
    "JournalEntryCurrency": ".types",
    "JournalEntryPaymentsItem": ".types",
    "JournalEntryPostingStatus": ".types",
    "JournalEntryRequest": ".types",
    "JournalEntryRequestCompany": ".types",
    "JournalEntryRequestCurrency": ".types",
    "JournalEntryRequestPaymentsItem": ".types",
    "JournalEntryRequestPostingStatus": ".types",
    "JournalEntryRequestTrackingCategoriesItem": ".types",
    "JournalEntryResponse": ".types",
    "JournalEntryTrackingCategoriesItem": ".types",
    "JournalLine": ".types",
    "JournalLineAccount": ".types",
    "JournalLineCurrency": ".types",
    "JournalLineProject": ".types",
    "JournalLineRequest": ".types",
    "JournalLineRequestAccount": ".types",
    "JournalLineRequestCurrency": ".types",
    "JournalLineRequestProject": ".types",
    "JournalLineRequestTrackingCategoriesItem": ".types",
    "JournalLineRequestTrackingCategory": ".types",
    "JournalLineTrackingCategoriesItem": ".types",
    "JournalLineTrackingCategory": ".types",
    "LanguageEnum": ".types",
    "LastSyncResultEnum": ".types",
    "LinkToken": ".types",
    "LinkedAccountStatus": ".types",
    "LinkedAccountsListRequestCategory": ".resources",
    "MetaResponse": ".types",
    "MethodEnum": ".types",
    "MethodTypeEnum": ".types",
    "ModelOperation": ".types",
    "ModelPermissionDeserializer": ".types",
    "ModelPermissionDeserializerRequest": ".types",
    "MultipartFormFieldRequest": ".types",
    "MultipartFormFieldRequestEncoding": ".types",
    "PaginatedAccountDetailsAndActionsList": ".types",
    "PaginatedAccountList": ".types",
    "PaginatedAccountingAttachmentList": ".types",
    "PaginatedAccountingPeriodList": ".types",
    "PaginatedAuditLogEventList": ".types",
    "PaginatedBalanceSheetList": ".types",
    "PaginatedBankFeedAccountList": ".types",
    "PaginatedBankFeedTransactionList": ".types",
    "PaginatedCashFlowStatementList": ".types",
    "PaginatedCompanyInfoList": ".types",
    "PaginatedContactList": ".types",
    "PaginatedCreditNoteList": ".types",
    "PaginatedEmployeeList": ".types",
    "PaginatedExpenseList": ".types",
    "PaginatedExpenseReportLineList": ".types",
    "PaginatedExpenseReportList": ".types",
    "PaginatedGeneralLedgerTransactionList": ".types",
    "PaginatedIncomeStatementList": ".types",
    "PaginatedInvoiceList": ".types",
    "PaginatedIssueList": ".types",
    "PaginatedItemList": ".types",
    "PaginatedJournalEntryList": ".types",
    "PaginatedPaymentList": ".types",
    "PaginatedPaymentMethodList": ".types",
    "PaginatedPaymentTermList": ".types",
    "PaginatedProjectList": ".types",
    "PaginatedPurchaseOrderList": ".types",
    "PaginatedRemoteFieldClassList": ".types",
    "PaginatedSyncStatusList": ".types",
    "PaginatedTaxRateList": ".types",
    "PaginatedTrackingCategoryList": ".types",
    "PaginatedTransactionList": ".types",
    "PaginatedVendorCreditList": ".types",
    "PatchedContactRequest": ".types",
    "PatchedContactRequestAddressesItem": ".types",
    "PatchedItemRequestRequest": ".types",
    "PatchedItemRequestRequestStatus": ".types",
    "PatchedItemRequestRequestType": ".types",
    "PatchedPaymentRequest": ".types",
    "PatchedPaymentRequestAccount": ".types",
    "PatchedPaymentRequestAccountingPeriod": ".types",
    "PatchedPaymentRequestAppliedToLinesItem": ".types",
    "PatchedPaymentRequestCompany": ".types",
    "PatchedPaymentRequestContact": ".types",
    "PatchedPaymentRequestCurrency": ".types",
    "PatchedPaymentRequestPaymentMethod": ".types",
    "PatchedPaymentRequestTrackingCategoriesItem": ".types",
    "PatchedPaymentRequestType": ".types",
    "Payment": ".types",
    "PaymentAccount": ".types",
    "PaymentAccountingPeriod": ".types",
    "PaymentAppliedToLinesItem": ".types",
    "PaymentCompany": ".types",
    "PaymentContact": ".types",
    "PaymentCurrency": ".types",
    "PaymentLineItem": ".types",
    "PaymentLineItemRequest": ".types",
    "PaymentMethod": ".types",
    "PaymentMethodMethodType": ".types",
    "PaymentPaymentMethod": ".types",
    "PaymentRequest": ".types",
    "PaymentRequestAccount": ".types",
    "PaymentRequestAccountingPeriod": ".types",
    "PaymentRequestAppliedToLinesItem": ".types",
    "PaymentRequestCompany": ".types",
    "PaymentRequestContact": ".types",
    "PaymentRequestCurrency": ".types",
    "PaymentRequestPaymentMethod": ".types",
    "PaymentRequestTrackingCategoriesItem": ".types",
    "PaymentRequestType": ".types",
    "PaymentResponse": ".types",
    "PaymentTerm": ".types",
    "PaymentTermCompany": ".types",
    "PaymentTrackingCategoriesItem": ".types",
    "PaymentType": ".types",
    "PaymentTypeEnum": ".types",
    "PaymentsListRequestExpand": ".resources",
    "PaymentsRetrieveRequestExpand": ".resources",
    "PostingStatusEnum": ".types",
    "Project": ".types",
    "ProjectCompany": ".types",
    "ProjectContact": ".types",
    "ProjectsListRequestExpand": ".resources",
    "ProjectsRetrieveRequestExpand": ".resources",
    "PurchaseOrder": ".types",
    "PurchaseOrderAccountingPeriod": ".types",
    "PurchaseOrderCompany": ".types",
    "PurchaseOrderCurrency": ".types",
    "PurchaseOrderDeliveryAddress": ".types",
    "PurchaseOrderLineItem": ".types",
    "PurchaseOrderLineItemCurrency": ".types",
    "PurchaseOrderLineItemItem": ".types",
    "PurchaseOrderLineItemRequest": ".types",
    "PurchaseOrderLineItemRequestCurrency": ".types",
    "PurchaseOrderLineItemRequestItem": ".types",
    "PurchaseOrderPaymentTerm": ".types",
    "PurchaseOrderRequest": ".types",
    "PurchaseOrderRequestCompany": ".types",
    "PurchaseOrderRequestCurrency": ".types",
    "PurchaseOrderRequestDeliveryAddress": ".types",
    "PurchaseOrderRequestPaymentTerm": ".types",
    "PurchaseOrderRequestStatus": ".types",
    "PurchaseOrderRequestTrackingCategoriesItem": ".types",
    "PurchaseOrderRequestVendor": ".types",
    "PurchaseOrderResponse": ".types",
    "PurchaseOrderStatus": ".types",
    "PurchaseOrderStatusEnum": ".types",
    "PurchaseOrderTrackingCategoriesItem": ".types",
    "PurchaseOrderVendor": ".types",
    "PurchaseOrdersListRequestExpand": ".resources",
    "PurchaseOrdersRetrieveRequestExpand": ".resources",
    "RemoteData": ".types",
    "RemoteEndpointInfo": ".types",
    "RemoteField": ".types",
    "RemoteFieldApi": ".types",
    "RemoteFieldApiCoverage": ".types",
    "RemoteFieldApiResponse": ".types",
    "RemoteFieldClass": ".types",
    "RemoteFieldRemoteFieldClass": ".types",
    "RemoteFieldRequest": ".types",
    "RemoteFieldRequestRemoteFieldClass": ".types",
    "RemoteKey": ".types",
    "RemoteResponse": ".types",
    "ReportItem": ".types",
    "RequestFormatEnum": ".types",
    "ResponseTypeEnum": ".types",
    "RoleEnum": ".types",
    "SelectiveSyncConfigurationsUsageEnum": ".types",
    "Status7D1Enum": ".types",
    "Status895Enum": ".types",
    "StatusFd5Enum": ".types",
    "SyncStatus": ".types",
    "SyncStatusStatus": ".types",
    "TaxComponent": ".types",
    "TaxComponentComponentType": ".types",
    "TaxRate": ".types",
    "TaxRateCompany": ".types",
    "TaxRateStatus": ".types",
    "TaxRateTaxComponentsItem": ".types",
    "TrackingCategory": ".types",
    "TrackingCategoryCategoryType": ".types",
    "TrackingCategoryCompany": ".types",
    "TrackingCategoryStatus": ".types",
    "Transaction": ".types",
    "TransactionAccount": ".types",
    "TransactionAccountingPeriod": ".types",
    "TransactionContact": ".types",
    "TransactionCurrency": ".types",
    "TransactionCurrencyEnum": ".types",
    "TransactionLineItem": ".types",
    "TransactionLineItemCurrency": ".types",
    "TransactionLineItemItem": ".types",
    "TransactionTrackingCategoriesItem": ".types",
    "TransactionsListRequestExpand": ".resources",
    "TransactionsRetrieveRequestExpand": ".resources",
    "Type2BbEnum": ".types",
    "UnderlyingTransactionTypeEnum": ".types",
    "ValidationProblemSource": ".types",
    "VendorCredit": ".types",
    "VendorCreditAccountingPeriod": ".types",
    "VendorCreditApplyLineForInvoice": ".types",
    "VendorCreditApplyLineForInvoiceVendorCredit": ".types",
    "VendorCreditApplyLineForVendorCredit": ".types",
    "VendorCreditApplyLineForVendorCreditInvoice": ".types",
    "VendorCreditApplyLineForVendorCreditRequest": ".types",
    "VendorCreditApplyLineForVendorCreditRequestInvoice": ".types",
    "VendorCreditCompany": ".types",
    "VendorCreditCurrency": ".types",
    "VendorCreditLine": ".types",
    "VendorCreditLineAccount": ".types",
    "VendorCreditLineContact": ".types",
    "VendorCreditLineProject": ".types",
    "VendorCreditLineRequest": ".types",
    "VendorCreditLineRequestAccount": ".types",
    "VendorCreditLineRequestContact": ".types",
    "VendorCreditLineRequestProject": ".types",
    "VendorCreditRequest": ".types",
    "VendorCreditRequestAccountingPeriod": ".types",
    "VendorCreditRequestCompany": ".types",
    "VendorCreditRequestCurrency": ".types",
    "VendorCreditRequestTrackingCategoriesItem": ".types",
    "VendorCreditRequestVendor": ".types",
    "VendorCreditResponse": ".types",
    "VendorCreditTrackingCategoriesItem": ".types",
    "VendorCreditVendor": ".types",
    "VendorCreditsListRequestExpand": ".resources",
    "VendorCreditsRetrieveRequestExpand": ".resources",
    "WarningValidationProblem": ".types",
    "WebhookReceiver": ".types",
    "account_details": ".resources",
    "account_token": ".resources",
    "accounting_periods": ".resources",
    "accounts": ".resources",
    "addresses": ".resources",
    "async_passthrough": ".resources",
    "async_tasks": ".resources",
    "attachments": ".resources",
    "audit_trail": ".resources",
    "available_actions": ".resources",
    "balance_sheets": ".resources",
    "bank_feed_accounts": ".resources",
    "bank_feed_transactions": ".resources",
    "cash_flow_statements": ".resources",
    "company_info": ".resources",
    "contacts": ".resources",
    "credit_notes": ".resources",
    "delete_account": ".resources",
    "employees": ".resources",
    "expense_reports": ".resources",
    "expenses": ".resources",
    "field_mapping": ".resources",
    "force_resync": ".resources",
    "general_ledger_transactions": ".resources",
    "generate_key": ".resources",
    "income_statements": ".resources",
    "invoices": ".resources",
    "issues": ".resources",
    "items": ".resources",
    "journal_entries": ".resources",
    "link_token": ".resources",
    "linked_accounts": ".resources",
    "passthrough": ".resources",
    "payment_methods": ".resources",
    "payment_terms": ".resources",
    "payments": ".resources",
    "phone_numbers": ".resources",
    "projects": ".resources",
    "purchase_orders": ".resources",
    "regenerate_key": ".resources",
    "scopes": ".resources",
    "sync_status": ".resources",
    "tax_rates": ".resources",
    "tracking_categories": ".resources",
    "transactions": ".resources",
    "vendor_credits": ".resources",
    "webhook_receivers": ".resources",
}


def __getattr__(attr_name: str) -> typing.Any:
    module_name = _dynamic_imports.get(attr_name)
    if module_name is None:
        raise AttributeError(f"No {attr_name} found in _dynamic_imports for module name -> {__name__}")
    try:
        module = import_module(module_name, __package__)
        result = getattr(module, attr_name)
        return result
    except ImportError as e:
        raise ImportError(f"Failed to import {attr_name} from {module_name}: {e}") from e
    except AttributeError as e:
        raise AttributeError(f"Failed to get {attr_name} from {module_name}: {e}") from e


def __dir__():
    lazy_attrs = list(_dynamic_imports.keys())
    return sorted(lazy_attrs)


__all__ = [
    "Account",
    "AccountAccountType",
    "AccountAccountTypeEnum",
    "AccountClassification",
    "AccountCurrency",
    "AccountDetails",
    "AccountDetailsAndActions",
    "AccountDetailsAndActionsCategory",
    "AccountDetailsAndActionsIntegration",
    "AccountDetailsAndActionsStatus",
    "AccountDetailsAndActionsStatusEnum",
    "AccountDetailsCategory",
    "AccountIntegration",
    "AccountRequest",
    "AccountRequestAccountType",
    "AccountRequestClassification",
    "AccountRequestCurrency",
    "AccountRequestStatus",
    "AccountResponse",
    "AccountStatus",
    "AccountStatusEnum",
    "AccountToken",
    "AccountingAttachment",
    "AccountingAttachmentRequest",
    "AccountingAttachmentResponse",
    "AccountingPeriod",
    "AccountingPeriodStatus",
    "AccountingPhoneNumber",
    "AccountingPhoneNumberRequest",
    "AccountsListRequestRemoteFields",
    "AccountsListRequestShowEnumOrigins",
    "AccountsRetrieveRequestRemoteFields",
    "AccountsRetrieveRequestShowEnumOrigins",
    "Address",
    "AddressCountry",
    "AddressRequest",
    "AddressRequestCountry",
    "AddressRequestType",
    "AddressType",
    "AddressTypeEnum",
    "AdvancedMetadata",
    "AsyncPassthroughReciept",
    "AsyncPassthroughRetrieveResponse",
    "AsyncPostTask",
    "AsyncPostTaskResult",
    "AsyncPostTaskStatus",
    "AsyncPostTaskStatusEnum",
    "AuditLogEvent",
    "AuditLogEventEventType",
    "AuditLogEventRole",
    "AvailableActions",
    "BalanceSheet",
    "BalanceSheetCompany",
    "BalanceSheetCurrency",
    "BankFeedAccount",
    "BankFeedAccountAccountType",
    "BankFeedAccountAccountTypeEnum",
    "BankFeedAccountCurrency",
    "BankFeedAccountFeedStatus",
    "BankFeedAccountRequest",
    "BankFeedAccountRequestAccountType",
    "BankFeedAccountRequestCurrency",
    "BankFeedAccountRequestFeedStatus",
    "BankFeedAccountResponse",
    "BankFeedTransaction",
    "BankFeedTransactionBankFeedAccount",
    "BankFeedTransactionCreditOrDebit",
    "BankFeedTransactionRequestRequest",
    "BankFeedTransactionRequestRequestBankFeedAccount",
    "BankFeedTransactionRequestRequestCreditOrDebit",
    "BankFeedTransactionResponse",
    "CashFlowStatement",
    "CashFlowStatementCompany",
    "CashFlowStatementCurrency",
    "CategoriesEnum",
    "CategoryEnum",
    "CategoryTypeEnum",
    "ClassificationEnum",
    "CommonModelScopeApi",
    "CommonModelScopesBodyRequest",
    "CompanyInfo",
    "CompanyInfoCurrency",
    "CompanyInfoListRequestExpand",
    "CompanyInfoRetrieveRequestExpand",
    "ComponentTypeEnum",
    "Contact",
    "ContactAddressesItem",
    "ContactRequest",
    "ContactRequestAddressesItem",
    "ContactRequestStatus",
    "ContactResponse",
    "ContactStatus",
    "ContactsListRequestExpand",
    "ContactsRetrieveRequestExpand",
    "CountryEnum",
    "CreditNote",
    "CreditNoteAccountingPeriod",
    "CreditNoteAppliedPaymentsItem",
    "CreditNoteApplyLineForCreditNote",
    "CreditNoteApplyLineForCreditNoteInvoice",
    "CreditNoteApplyLineForCreditNoteRequest",
    "CreditNoteApplyLineForCreditNoteRequestInvoice",
    "CreditNoteApplyLineForInvoice",
    "CreditNoteApplyLineForInvoiceCreditNote",
    "CreditNoteCompany",
    "CreditNoteContact",
    "CreditNoteCurrency",
    "CreditNoteLineItem",
    "CreditNoteLineItemCompany",
    "CreditNoteLineItemContact",
    "CreditNoteLineItemItem",
    "CreditNoteLineItemProject",
    "CreditNoteLineItemRequest",
    "CreditNoteLineItemRequestCompany",
    "CreditNoteLineItemRequestContact",
    "CreditNoteLineItemRequestItem",
    "CreditNoteLineItemRequestProject",
    "CreditNotePaymentsItem",
    "CreditNoteRequest",
    "CreditNoteRequestAccountingPeriod",
    "CreditNoteRequestAppliedPaymentsItem",
    "CreditNoteRequestCompany",
    "CreditNoteRequestContact",
    "CreditNoteRequestCurrency",
    "CreditNoteRequestLineItemsItem",
    "CreditNoteRequestPaymentsItem",
    "CreditNoteRequestStatus",
    "CreditNoteRequestTrackingCategoriesItem",
    "CreditNoteResponse",
    "CreditNoteStatus",
    "CreditNoteStatusEnum",
    "CreditNoteTrackingCategoriesItem",
    "CreditNotesListRequestExpand",
    "CreditNotesListRequestRemoteFields",
    "CreditNotesListRequestShowEnumOrigins",
    "CreditNotesRetrieveRequestExpand",
    "CreditNotesRetrieveRequestRemoteFields",
    "CreditNotesRetrieveRequestShowEnumOrigins",
    "CreditOrDebitEnum",
    "DataPassthroughRequest",
    "DataPassthroughRequestMethod",
    "DebugModeLog",
    "DebugModelLogSummary",
    "Employee",
    "EmployeeCompany",
    "EmployeeStatus",
    "EnabledActionsEnum",
    "EncodingEnum",
    "EndUserDetailsRequestLanguage",
    "ErrorValidationProblem",
    "EventTypeEnum",
    "Expense",
    "ExpenseAccount",
    "ExpenseAccountingPeriod",
    "ExpenseCompany",
    "ExpenseContact",
    "ExpenseCurrency",
    "ExpenseEmployee",
    "ExpenseLine",
    "ExpenseLineAccount",
    "ExpenseLineContact",
    "ExpenseLineCurrency",
    "ExpenseLineEmployee",
    "ExpenseLineItem",
    "ExpenseLineProject",
    "ExpenseLineRequest",
    "ExpenseLineRequestAccount",
    "ExpenseLineRequestContact",
    "ExpenseLineRequestCurrency",
    "ExpenseLineRequestEmployee",
    "ExpenseLineRequestItem",
    "ExpenseLineRequestProject",
    "ExpenseLineRequestTrackingCategoriesItem",
    "ExpenseLineRequestTrackingCategory",
    "ExpenseLineTrackingCategoriesItem",
    "ExpenseLineTrackingCategory",
    "ExpenseReport",
    "ExpenseReportCompany",
    "ExpenseReportLine",
    "ExpenseReportLineAccount",
    "ExpenseReportLineCompany",
    "ExpenseReportLineContact",
    "ExpenseReportLineEmployee",
    "ExpenseReportLineProject",
    "ExpenseReportLineRequest",
    "ExpenseReportLineRequestAccount",
    "ExpenseReportLineRequestCompany",
    "ExpenseReportLineRequestContact",
    "ExpenseReportLineRequestEmployee",
    "ExpenseReportLineRequestProject",
    "ExpenseReportLineRequestTaxRate",
    "ExpenseReportLineTaxRate",
    "ExpenseReportRequest",
    "ExpenseReportRequestAccountingPeriod",
    "ExpenseReportRequestCompany",
    "ExpenseReportRequestEmployee",
    "ExpenseReportResponse",
    "ExpenseReportStatus",
    "ExpenseReportStatusEnum",
    "ExpenseReportsLinesListRequestExpand",
    "ExpenseReportsListRequestExpand",
    "ExpenseReportsRetrieveRequestExpand",
    "ExpenseRequest",
    "ExpenseRequestAccount",
    "ExpenseRequestAccountingPeriod",
    "ExpenseRequestCompany",
    "ExpenseRequestContact",
    "ExpenseRequestCurrency",
    "ExpenseRequestEmployee",
    "ExpenseRequestTrackingCategoriesItem",
    "ExpenseResponse",
    "ExpenseTrackingCategoriesItem",
    "ExpensesListRequestExpand",
    "ExpensesRetrieveRequestExpand",
    "ExternalTargetFieldApi",
    "ExternalTargetFieldApiResponse",
    "FeedStatusEnum",
    "FieldFormatEnum",
    "FieldMappingApiInstance",
    "FieldMappingApiInstanceRemoteField",
    "FieldMappingApiInstanceRemoteFieldRemoteEndpointInfo",
    "FieldMappingApiInstanceResponse",
    "FieldMappingApiInstanceTargetField",
    "FieldMappingInstanceResponse",
    "FieldPermissionDeserializer",
    "FieldPermissionDeserializerRequest",
    "FieldTypeEnum",
    "GeneralLedgerTransaction",
    "GeneralLedgerTransactionAccountingPeriod",
    "GeneralLedgerTransactionCompany",
    "GeneralLedgerTransactionGeneralLedgerTransactionLinesItem",
    "GeneralLedgerTransactionLine",
    "GeneralLedgerTransactionLineAccount",
    "GeneralLedgerTransactionLineBaseCurrency",
    "GeneralLedgerTransactionLineCompany",
    "GeneralLedgerTransactionLineContact",
    "GeneralLedgerTransactionLineEmployee",
    "GeneralLedgerTransactionLineItem",
    "GeneralLedgerTransactionLineProject",
    "GeneralLedgerTransactionLineTrackingCategoriesItem",
    "GeneralLedgerTransactionLineTransactionCurrency",
    "GeneralLedgerTransactionTrackingCategoriesItem",
    "GeneralLedgerTransactionUnderlyingTransactionType",
    "GeneralLedgerTransactionsListRequestExpand",
    "GeneralLedgerTransactionsRetrieveRequestExpand",
    "IncomeStatement",
    "IncomeStatementCompany",
    "IncomeStatementCurrency",
    "IndividualCommonModelScopeDeserializer",
    "IndividualCommonModelScopeDeserializerRequest",
    "Invoice",
    "InvoiceAccountingPeriod",
    "InvoiceAppliedCreditNotesItem",
    "InvoiceAppliedPaymentsItem",
    "InvoiceAppliedVendorCreditsItem",
    "InvoiceCompany",
    "InvoiceContact",
    "InvoiceCurrency",
    "InvoiceEmployee",
    "InvoiceLineItem",
    "InvoiceLineItemAccount",
    "InvoiceLineItemContact",
    "InvoiceLineItemCurrency",
    "InvoiceLineItemEmployee",
    "InvoiceLineItemItem",
    "InvoiceLineItemProject",
    "InvoiceLineItemRequest",
    "InvoiceLineItemRequestAccount",
    "InvoiceLineItemRequestContact",
    "InvoiceLineItemRequestCurrency",
    "InvoiceLineItemRequestEmployee",
    "InvoiceLineItemRequestItem",
    "InvoiceLineItemRequestProject",
    "InvoiceLineItemRequestTrackingCategoriesItem",
    "InvoiceLineItemRequestTrackingCategory",
    "InvoiceLineItemTrackingCategoriesItem",
    "InvoiceLineItemTrackingCategory",
    "InvoicePaymentTerm",
    "InvoicePaymentsItem",
    "InvoicePurchaseOrdersItem",
    "InvoiceRequest",
    "InvoiceRequestCompany",
    "InvoiceRequestContact",
    "InvoiceRequestCurrency",
    "InvoiceRequestEmployee",
    "InvoiceRequestPaymentTerm",
    "InvoiceRequestPaymentsItem",
    "InvoiceRequestPurchaseOrdersItem",
    "InvoiceRequestStatus",
    "InvoiceRequestTrackingCategoriesItem",
    "InvoiceRequestType",
    "InvoiceResponse",
    "InvoiceStatus",
    "InvoiceStatusEnum",
    "InvoiceTrackingCategoriesItem",
    "InvoiceType",
    "InvoiceTypeEnum",
    "InvoicesListRequestExpand",
    "InvoicesListRequestStatus",
    "InvoicesListRequestType",
    "InvoicesRetrieveRequestExpand",
    "Issue",
    "IssueStatus",
    "IssueStatusEnum",
    "IssuesListRequestStatus",
    "Item",
    "ItemCompany",
    "ItemFormatEnum",
    "ItemPurchaseAccount",
    "ItemPurchaseTaxRate",
    "ItemRequestRequest",
    "ItemRequestRequestCompany",
    "ItemRequestRequestPurchaseAccount",
    "ItemRequestRequestPurchaseTaxRate",
    "ItemRequestRequestSalesAccount",
    "ItemRequestRequestSalesTaxRate",
    "ItemRequestRequestStatus",
    "ItemRequestRequestType",
    "ItemResponse",
    "ItemSalesAccount",
    "ItemSalesTaxRate",
    "ItemSchema",
    "ItemStatus",
    "ItemType",
    "ItemTypeEnum",
    "ItemsListRequestExpand",
    "ItemsRetrieveRequestExpand",
    "JournalEntriesListRequestExpand",
    "JournalEntriesRetrieveRequestExpand",
    "JournalEntry",
    "JournalEntryAccountingPeriod",
    "JournalEntryAppliedPaymentsItem",
    "JournalEntryCompany",
    "JournalEntryCurrency",
    "JournalEntryPaymentsItem",
    "JournalEntryPostingStatus",
    "JournalEntryRequest",
    "JournalEntryRequestCompany",
    "JournalEntryRequestCurrency",
    "JournalEntryRequestPaymentsItem",
    "JournalEntryRequestPostingStatus",
    "JournalEntryRequestTrackingCategoriesItem",
    "JournalEntryResponse",
    "JournalEntryTrackingCategoriesItem",
    "JournalLine",
    "JournalLineAccount",
    "JournalLineCurrency",
    "JournalLineProject",
    "JournalLineRequest",
    "JournalLineRequestAccount",
    "JournalLineRequestCurrency",
    "JournalLineRequestProject",
    "JournalLineRequestTrackingCategoriesItem",
    "JournalLineRequestTrackingCategory",
    "JournalLineTrackingCategoriesItem",
    "JournalLineTrackingCategory",
    "LanguageEnum",
    "LastSyncResultEnum",
    "LinkToken",
    "LinkedAccountStatus",
    "LinkedAccountsListRequestCategory",
    "MetaResponse",
    "MethodEnum",
    "MethodTypeEnum",
    "ModelOperation",
    "ModelPermissionDeserializer",
    "ModelPermissionDeserializerRequest",
    "MultipartFormFieldRequest",
    "MultipartFormFieldRequestEncoding",
    "PaginatedAccountDetailsAndActionsList",
    "PaginatedAccountList",
    "PaginatedAccountingAttachmentList",
    "PaginatedAccountingPeriodList",
    "PaginatedAuditLogEventList",
    "PaginatedBalanceSheetList",
    "PaginatedBankFeedAccountList",
    "PaginatedBankFeedTransactionList",
    "PaginatedCashFlowStatementList",
    "PaginatedCompanyInfoList",
    "PaginatedContactList",
    "PaginatedCreditNoteList",
    "PaginatedEmployeeList",
    "PaginatedExpenseList",
    "PaginatedExpenseReportLineList",
    "PaginatedExpenseReportList",
    "PaginatedGeneralLedgerTransactionList",
    "PaginatedIncomeStatementList",
    "PaginatedInvoiceList",
    "PaginatedIssueList",
    "PaginatedItemList",
    "PaginatedJournalEntryList",
    "PaginatedPaymentList",
    "PaginatedPaymentMethodList",
    "PaginatedPaymentTermList",
    "PaginatedProjectList",
    "PaginatedPurchaseOrderList",
    "PaginatedRemoteFieldClassList",
    "PaginatedSyncStatusList",
    "PaginatedTaxRateList",
    "PaginatedTrackingCategoryList",
    "PaginatedTransactionList",
    "PaginatedVendorCreditList",
    "PatchedContactRequest",
    "PatchedContactRequestAddressesItem",
    "PatchedItemRequestRequest",
    "PatchedItemRequestRequestStatus",
    "PatchedItemRequestRequestType",
    "PatchedPaymentRequest",
    "PatchedPaymentRequestAccount",
    "PatchedPaymentRequestAccountingPeriod",
    "PatchedPaymentRequestAppliedToLinesItem",
    "PatchedPaymentRequestCompany",
    "PatchedPaymentRequestContact",
    "PatchedPaymentRequestCurrency",
    "PatchedPaymentRequestPaymentMethod",
    "PatchedPaymentRequestTrackingCategoriesItem",
    "PatchedPaymentRequestType",
    "Payment",
    "PaymentAccount",
    "PaymentAccountingPeriod",
    "PaymentAppliedToLinesItem",
    "PaymentCompany",
    "PaymentContact",
    "PaymentCurrency",
    "PaymentLineItem",
    "PaymentLineItemRequest",
    "PaymentMethod",
    "PaymentMethodMethodType",
    "PaymentPaymentMethod",
    "PaymentRequest",
    "PaymentRequestAccount",
    "PaymentRequestAccountingPeriod",
    "PaymentRequestAppliedToLinesItem",
    "PaymentRequestCompany",
    "PaymentRequestContact",
    "PaymentRequestCurrency",
    "PaymentRequestPaymentMethod",
    "PaymentRequestTrackingCategoriesItem",
    "PaymentRequestType",
    "PaymentResponse",
    "PaymentTerm",
    "PaymentTermCompany",
    "PaymentTrackingCategoriesItem",
    "PaymentType",
    "PaymentTypeEnum",
    "PaymentsListRequestExpand",
    "PaymentsRetrieveRequestExpand",
    "PostingStatusEnum",
    "Project",
    "ProjectCompany",
    "ProjectContact",
    "ProjectsListRequestExpand",
    "ProjectsRetrieveRequestExpand",
    "PurchaseOrder",
    "PurchaseOrderAccountingPeriod",
    "PurchaseOrderCompany",
    "PurchaseOrderCurrency",
    "PurchaseOrderDeliveryAddress",
    "PurchaseOrderLineItem",
    "PurchaseOrderLineItemCurrency",
    "PurchaseOrderLineItemItem",
    "PurchaseOrderLineItemRequest",
    "PurchaseOrderLineItemRequestCurrency",
    "PurchaseOrderLineItemRequestItem",
    "PurchaseOrderPaymentTerm",
    "PurchaseOrderRequest",
    "PurchaseOrderRequestCompany",
    "PurchaseOrderRequestCurrency",
    "PurchaseOrderRequestDeliveryAddress",
    "PurchaseOrderRequestPaymentTerm",
    "PurchaseOrderRequestStatus",
    "PurchaseOrderRequestTrackingCategoriesItem",
    "PurchaseOrderRequestVendor",
    "PurchaseOrderResponse",
    "PurchaseOrderStatus",
    "PurchaseOrderStatusEnum",
    "PurchaseOrderTrackingCategoriesItem",
    "PurchaseOrderVendor",
    "PurchaseOrdersListRequestExpand",
    "PurchaseOrdersRetrieveRequestExpand",
    "RemoteData",
    "RemoteEndpointInfo",
    "RemoteField",
    "RemoteFieldApi",
    "RemoteFieldApiCoverage",
    "RemoteFieldApiResponse",
    "RemoteFieldClass",
    "RemoteFieldRemoteFieldClass",
    "RemoteFieldRequest",
    "RemoteFieldRequestRemoteFieldClass",
    "RemoteKey",
    "RemoteResponse",
    "ReportItem",
    "RequestFormatEnum",
    "ResponseTypeEnum",
    "RoleEnum",
    "SelectiveSyncConfigurationsUsageEnum",
    "Status7D1Enum",
    "Status895Enum",
    "StatusFd5Enum",
    "SyncStatus",
    "SyncStatusStatus",
    "TaxComponent",
    "TaxComponentComponentType",
    "TaxRate",
    "TaxRateCompany",
    "TaxRateStatus",
    "TaxRateTaxComponentsItem",
    "TrackingCategory",
    "TrackingCategoryCategoryType",
    "TrackingCategoryCompany",
    "TrackingCategoryStatus",
    "Transaction",
    "TransactionAccount",
    "TransactionAccountingPeriod",
    "TransactionContact",
    "TransactionCurrency",
    "TransactionCurrencyEnum",
    "TransactionLineItem",
    "TransactionLineItemCurrency",
    "TransactionLineItemItem",
    "TransactionTrackingCategoriesItem",
    "TransactionsListRequestExpand",
    "TransactionsRetrieveRequestExpand",
    "Type2BbEnum",
    "UnderlyingTransactionTypeEnum",
    "ValidationProblemSource",
    "VendorCredit",
    "VendorCreditAccountingPeriod",
    "VendorCreditApplyLineForInvoice",
    "VendorCreditApplyLineForInvoiceVendorCredit",
    "VendorCreditApplyLineForVendorCredit",
    "VendorCreditApplyLineForVendorCreditInvoice",
    "VendorCreditApplyLineForVendorCreditRequest",
    "VendorCreditApplyLineForVendorCreditRequestInvoice",
    "VendorCreditCompany",
    "VendorCreditCurrency",
    "VendorCreditLine",
    "VendorCreditLineAccount",
    "VendorCreditLineContact",
    "VendorCreditLineProject",
    "VendorCreditLineRequest",
    "VendorCreditLineRequestAccount",
    "VendorCreditLineRequestContact",
    "VendorCreditLineRequestProject",
    "VendorCreditRequest",
    "VendorCreditRequestAccountingPeriod",
    "VendorCreditRequestCompany",
    "VendorCreditRequestCurrency",
    "VendorCreditRequestTrackingCategoriesItem",
    "VendorCreditRequestVendor",
    "VendorCreditResponse",
    "VendorCreditTrackingCategoriesItem",
    "VendorCreditVendor",
    "VendorCreditsListRequestExpand",
    "VendorCreditsRetrieveRequestExpand",
    "WarningValidationProblem",
    "WebhookReceiver",
    "account_details",
    "account_token",
    "accounting_periods",
    "accounts",
    "addresses",
    "async_passthrough",
    "async_tasks",
    "attachments",
    "audit_trail",
    "available_actions",
    "balance_sheets",
    "bank_feed_accounts",
    "bank_feed_transactions",
    "cash_flow_statements",
    "company_info",
    "contacts",
    "credit_notes",
    "delete_account",
    "employees",
    "expense_reports",
    "expenses",
    "field_mapping",
    "force_resync",
    "general_ledger_transactions",
    "generate_key",
    "income_statements",
    "invoices",
    "issues",
    "items",
    "journal_entries",
    "link_token",
    "linked_accounts",
    "passthrough",
    "payment_methods",
    "payment_terms",
    "payments",
    "phone_numbers",
    "projects",
    "purchase_orders",
    "regenerate_key",
    "scopes",
    "sync_status",
    "tax_rates",
    "tracking_categories",
    "transactions",
    "vendor_credits",
    "webhook_receivers",
]
