# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .bank_feed_transaction_request_request_bank_feed_account import BankFeedTransactionRequestRequestBankFeedAccount
from .bank_feed_transaction_request_request_credit_or_debit import BankFeedTransactionRequestRequestCreditOrDebit


class BankFeedTransactionRequestRequest(UncheckedBaseModel):
    """
    # The BankFeedTransaction Object
    ### Description
    The `BankFeedTransaction` object is used to represent transactions linked to a bank feed account. This includes details about the transaction such as the date, amount, description, and type.

    ### Usage Example
    Fetch from the `GET BankFeedTransaction` endpoint to view details of a transaction associated with a bank feed account.
    """

    bank_feed_account: typing.Optional[BankFeedTransactionRequestRequestBankFeedAccount] = pydantic.Field(default=None)
    """
    The bank feed account associated with the transaction.
    """

    transaction_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date that the transaction occurred.
    """

    posted_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date the transaction was posted to the bank account.
    """

    amount: typing.Optional[float] = pydantic.Field(default=None)
    """
    The amount of the transaction.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the transaction.
    """

    transaction_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The underlying type of the transaction.
    """

    payee: typing.Optional[str] = pydantic.Field(default=None)
    """
    The person or merchant who initiated the transaction, or alternatively, to whom the transaction was paid.
    """

    credit_or_debit: typing.Optional[BankFeedTransactionRequestRequestCreditOrDebit] = pydantic.Field(default=None)
    """
    If the transaction is of type debit or credit.
    
    * `CREDIT` - CREDIT
    * `DEBIT` - DEBIT
    """

    source_transaction_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The customer’s identifier for the transaction.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
