# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .credit_note_line_item_request_company import CreditNoteLineItemRequestCompany
from .credit_note_line_item_request_contact import CreditNoteLineItemRequestContact
from .credit_note_line_item_request_item import CreditNoteLineItemRequestItem
from .credit_note_line_item_request_project import CreditNoteLineItemRequestProject


class CreditNoteLineItemRequest(UncheckedBaseModel):
    """
    # The CreditNoteLineItem Object
    ### Description
    The `CreditNoteLineItem` object is used to represent a credit note's line items.

    ### Usage Example
    Fetch from the `GET CreditNote` endpoint and view the credit note's line items.
    """

    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    item: typing.Optional[CreditNoteLineItemRequestItem] = None
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's name.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the item that is owed.
    """

    quantity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's quantity.
    """

    memo: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's memo.
    """

    unit_price: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's unit price.
    """

    tax_rate: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tax rate that applies to this line item.
    """

    total_line_amount: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's total.
    """

    tracking_category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's associated tracking category.
    """

    tracking_categories: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    The credit note line item's associated tracking categories.
    """

    account: typing.Optional[str] = pydantic.Field(default=None)
    """
    The credit note line item's account.
    """

    company: typing.Optional[CreditNoteLineItemRequestCompany] = pydantic.Field(default=None)
    """
    The company the credit note belongs to.
    """

    contact: typing.Optional[CreditNoteLineItemRequestContact] = pydantic.Field(default=None)
    """
    The credit note's contact.
    """

    project: typing.Optional[CreditNoteLineItemRequestProject] = None
    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
