# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .employee_company import EmployeeCompany
from .employee_status import EmployeeStatus
from .remote_data import RemoteData


class Employee(UncheckedBaseModel):
    """
    # The Employee Object
    ### Description
    An `Employee` is an individual who works for the company of the linked account. The `Employee` model contains both contractors and full time employees.
    * An `Employee` is a contractor if `is_contractor` property is `True`
    * An `Employee` is a full time employee if `is_contractor` property is `False`

    ### Usage Example
    Fetch from the `LIST Employees` endpoint and view a company's employees.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    first_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's first name.
    """

    last_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's last name.
    """

    is_contractor: typing.Optional[bool] = pydantic.Field(default=None)
    """
    `True` if the employee is a contractor, `False` if not.
    """

    employee_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's internal identification number.
    """

    email_address: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee's email address.
    """

    company: typing.Optional[EmployeeCompany] = pydantic.Field(default=None)
    """
    The subsidiary that the employee belongs to.
    """

    status: EmployeeStatus = pydantic.Field()
    """
    The employee's status in the accounting system.
    
    * `ACTIVE` - ACTIVE
    * `INACTIVE` - INACTIVE
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
