# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .accounting_phone_number_request import AccountingPhoneNumberRequest
from .patched_contact_request_addresses_item import PatchedContactRequestAddressesItem
from .remote_field_request import RemoteFieldRequest


class PatchedContactRequest(UncheckedBaseModel):
    """
    # The Contact Object
    ### Description
    A `Contact` is an individual or business entity to which products and services are sold to or purchased from. The `Contact` model contains both Customers, in which products and services are sold to, and Vendors (or Suppliers), in which products and services are purchased from.
    * A `Contact` is a Vendor/Supplier if the `is_supplier` property is true.
    * A `Contact` is a customer if the `is_customer` property is true.

    ### Usage Example
    Fetch from the `LIST Contacts` endpoint and view a company's contacts.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contact's name.
    """

    is_supplier: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the contact is a supplier.
    """

    is_customer: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the contact is a customer.
    """

    email_address: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contact's email address.
    """

    tax_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contact's tax number.
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contact's status
    
    * `ACTIVE` - ACTIVE
    * `ARCHIVED` - ARCHIVED
    """

    currency: typing.Optional[str] = pydantic.Field(default=None)
    """
    The currency the contact's transactions are in.
    """

    company: typing.Optional[str] = pydantic.Field(default=None)
    """
    The company the contact belongs to.
    """

    addresses: typing.Optional[typing.List[typing.Optional[PatchedContactRequestAddressesItem]]] = pydantic.Field(
        default=None
    )
    """
    `Address` object IDs for the given `Contacts` object.
    """

    phone_numbers: typing.Optional[typing.List[AccountingPhoneNumberRequest]] = pydantic.Field(default=None)
    """
    `AccountingPhoneNumber` object for the given `Contacts` object.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_fields: typing.Optional[typing.List[RemoteFieldRequest]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
