# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .payment_method_method_type import PaymentMethodMethodType
from .remote_data import RemoteData


class PaymentMethod(UncheckedBaseModel):
    """
    # The PaymentMethod Object
    ### Description
    The `PaymentMethod` object defines how a payment against an invoice is made.

    ### Usage Example
    Fetch from the `GET PaymentMethod` endpoint and view payment method information.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    method_type: PaymentMethodMethodType = pydantic.Field()
    """
    The type of the payment method.
    
    * `CREDIT_CARD` - CREDIT_CARD
    * `DEBIT_CARD` - DEBIT_CARD
    * `ACH` - ACH
    * `CASH` - CASH
    * `CHECK` - CHECK
    """

    name: str = pydantic.Field()
    """
    The payment method’s name
    """

    is_active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    `True` if the payment method is active, `False` if not.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's payment method was updated.
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
