# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .payment_term_company import PaymentTermCompany
from .remote_data import RemoteData


class PaymentTerm(UncheckedBaseModel):
    """
    # The PaymentTerm Object
    ### Description
    The `PaymentTerm` object is the agreed-upon conditions between a buyer and a seller that define the timing,
    amount, and conditions under which payment for goods or services must be made.

    ### Usage Example
    Fetch from the `GET PaymentTerm` endpoint and view payment term information.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: str = pydantic.Field()
    """
    The name of the payment term.
    """

    is_active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    `True` if the payment term is active, `False` if not.
    """

    company: typing.Optional[PaymentTermCompany] = pydantic.Field(default=None)
    """
    The subsidiary that the payment term belongs to.
    """

    days_until_due: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of days after the invoice date that payment is due.
    """

    discount_days: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of days the invoice must be paid before discounts expire.
    """

    remote_last_modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's payment term was modified.
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
