# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .project_company import ProjectCompany
from .project_contact import ProjectContact
from .remote_data import RemoteData


class Project(UncheckedBaseModel):
    """
    # The Project Object
    ### Description
    The `Project` object is used to track and manage time, costs, resources, and revenue for specific initiatives or work efforts.
    It provides classification on transactions for allocating expenses, revenue, and activities to a specific project for financial reporting.

    ### Usage Example
    Fetch from the `GET Project` endpoint and view project information.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: str = pydantic.Field()
    """
    The project’s name
    """

    is_active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    `True` if the project is active, `False` if the project is not active.
    """

    company: typing.Optional[ProjectCompany] = pydantic.Field(default=None)
    """
    The subsidiary that the project belongs to.
    """

    contact: typing.Optional[ProjectContact] = pydantic.Field(default=None)
    """
    The supplier, or customer involved in the project.
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
