# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .vendor_credit_line_account import VendorCreditLineAccount
from .vendor_credit_line_contact import VendorCreditLineContact
from .vendor_credit_line_project import VendorCreditLineProject


class VendorCreditLine(UncheckedBaseModel):
    """
    # The VendorCreditLine Object
    ### Description
    The `VendorCreditLine` object is used to represent a vendor credit's line items.

    ### Usage Example
    Fetch from the `GET VendorCredit` endpoint and view the vendor credit's line items.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    net_amount: typing.Optional[float] = pydantic.Field(default=None)
    """
    The full value of the credit.
    """

    tracking_category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The line's associated tracking category.
    """

    tracking_categories: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    The vendor credit line item's associated tracking categories.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The line's description.
    """

    account: typing.Optional[VendorCreditLineAccount] = pydantic.Field(default=None)
    """
    The line's account.
    """

    company: typing.Optional[str] = pydantic.Field(default=None)
    """
    The company the line belongs to.
    """

    project: typing.Optional[VendorCreditLineProject] = None
    contact: typing.Optional[VendorCreditLineContact] = None
    tax_rate: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tax rate that applies to this line item.
    """

    exchange_rate: typing.Optional[str] = pydantic.Field(default=None)
    """
    The vendor credit line item's exchange rate.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
