# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.external_target_field_api_response import ExternalTargetFieldApiResponse
from ...types.field_mapping_api_instance_response import FieldMappingApiInstanceResponse
from ...types.field_mapping_instance_response import FieldMappingInstanceResponse
from ...types.remote_field_api_response import RemoteFieldApiResponse
from .raw_client import AsyncRawFieldMappingClient, RawFieldMappingClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FieldMappingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFieldMappingClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFieldMappingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFieldMappingClient
        """
        return self._raw_client

    def field_mappings_retrieve(
        self,
        *,
        exclude_remote_field_metadata: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FieldMappingApiInstanceResponse:
        """
        Get all Field Mappings for this Linked Account. Field Mappings are mappings between third-party Remote Fields and user defined Merge fields. [Learn more](https://docs.merge.dev/supplemental-data/field-mappings/overview/).

        Parameters
        ----------
        exclude_remote_field_metadata : typing.Optional[bool]
            If `true`, remote fields metadata is excluded from each field mapping instance (i.e. `remote_fields.remote_key_name` and `remote_fields.schema` will be null). This will increase the speed of the request since these fields require some calculations.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FieldMappingApiInstanceResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.field_mapping.field_mappings_retrieve()
        """
        _response = self._raw_client.field_mappings_retrieve(
            exclude_remote_field_metadata=exclude_remote_field_metadata, request_options=request_options
        )
        return _response.data

    def field_mappings_create(
        self,
        *,
        target_field_name: str,
        target_field_description: str,
        remote_field_traversal_path: typing.Sequence[typing.Optional[typing.Any]],
        remote_method: str,
        remote_url_path: str,
        common_model_name: str,
        exclude_remote_field_metadata: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FieldMappingInstanceResponse:
        """
        Create new Field Mappings that will be available after the next scheduled sync. This will cause the next sync for this Linked Account to sync **ALL** data from start.

        Parameters
        ----------
        target_field_name : str
            The name of the target field you want this remote field to map to.

        target_field_description : str
            The description of the target field you want this remote field to map to.

        remote_field_traversal_path : typing.Sequence[typing.Optional[typing.Any]]
            The field traversal path of the remote field listed when you hit the GET /remote-fields endpoint.

        remote_method : str
            The method of the remote endpoint where the remote field is coming from.

        remote_url_path : str
            The path of the remote endpoint where the remote field is coming from.

        common_model_name : str
            The name of the Common Model that the remote field corresponds to in a given category.

        exclude_remote_field_metadata : typing.Optional[bool]
            If `true`, remote fields metadata is excluded from each field mapping instance (i.e. `remote_fields.remote_key_name` and `remote_fields.schema` will be null). This will increase the speed of the request since these fields require some calculations.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FieldMappingInstanceResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.field_mapping.field_mappings_create(
            target_field_name="example_target_field_name",
            target_field_description="this is a example description of the target field",
            remote_field_traversal_path=["example_remote_field"],
            remote_method="GET",
            remote_url_path="/example-url-path",
            common_model_name="ExampleCommonModel",
        )
        """
        _response = self._raw_client.field_mappings_create(
            target_field_name=target_field_name,
            target_field_description=target_field_description,
            remote_field_traversal_path=remote_field_traversal_path,
            remote_method=remote_method,
            remote_url_path=remote_url_path,
            common_model_name=common_model_name,
            exclude_remote_field_metadata=exclude_remote_field_metadata,
            request_options=request_options,
        )
        return _response.data

    def field_mappings_destroy(
        self, field_mapping_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FieldMappingInstanceResponse:
        """
        Deletes Field Mappings for a Linked Account. All data related to this Field Mapping will be deleted and these changes will be reflected after the next scheduled sync. This will cause the next sync for this Linked Account to sync **ALL** data from start.

        Parameters
        ----------
        field_mapping_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FieldMappingInstanceResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.field_mapping.field_mappings_destroy(
            field_mapping_id="field_mapping_id",
        )
        """
        _response = self._raw_client.field_mappings_destroy(field_mapping_id, request_options=request_options)
        return _response.data

    def field_mappings_partial_update(
        self,
        field_mapping_id: str,
        *,
        remote_field_traversal_path: typing.Optional[typing.Sequence[typing.Optional[typing.Any]]] = OMIT,
        remote_method: typing.Optional[str] = OMIT,
        remote_url_path: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FieldMappingInstanceResponse:
        """
        Create or update existing Field Mappings for a Linked Account. Changes will be reflected after the next scheduled sync. This will cause the next sync for this Linked Account to sync **ALL** data from start.

        Parameters
        ----------
        field_mapping_id : str

        remote_field_traversal_path : typing.Optional[typing.Sequence[typing.Optional[typing.Any]]]
            The field traversal path of the remote field listed when you hit the GET /remote-fields endpoint.

        remote_method : typing.Optional[str]
            The method of the remote endpoint where the remote field is coming from.

        remote_url_path : typing.Optional[str]
            The path of the remote endpoint where the remote field is coming from.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FieldMappingInstanceResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.field_mapping.field_mappings_partial_update(
            field_mapping_id="field_mapping_id",
        )
        """
        _response = self._raw_client.field_mappings_partial_update(
            field_mapping_id,
            remote_field_traversal_path=remote_field_traversal_path,
            remote_method=remote_method,
            remote_url_path=remote_url_path,
            request_options=request_options,
        )
        return _response.data

    def remote_fields_retrieve(
        self,
        *,
        common_models: typing.Optional[str] = None,
        include_example_values: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RemoteFieldApiResponse:
        """
        Get all remote fields for a Linked Account. Remote fields are third-party fields that are accessible after initial sync if remote_data is enabled. You can use remote fields to override existing Merge fields or map a new Merge field. [Learn more](https://docs.merge.dev/supplemental-data/field-mappings/overview/).

        Parameters
        ----------
        common_models : typing.Optional[str]
            A comma seperated list of Common Model names. If included, will only return Remote Fields for those Common Models.

        include_example_values : typing.Optional[str]
            If true, will include example values, where available, for remote fields in the 3rd party platform. These examples come from active data from your customers.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RemoteFieldApiResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.field_mapping.remote_fields_retrieve()
        """
        _response = self._raw_client.remote_fields_retrieve(
            common_models=common_models, include_example_values=include_example_values, request_options=request_options
        )
        return _response.data

    def target_fields_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExternalTargetFieldApiResponse:
        """
        Get all organization-wide Target Fields, this will not include any Linked Account specific Target Fields. Organization-wide Target Fields are additional fields appended to the Merge Common Model for all Linked Accounts in a category. [Learn more](https://docs.merge.dev/supplemental-data/field-mappings/target-fields/).

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalTargetFieldApiResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.field_mapping.target_fields_retrieve()
        """
        _response = self._raw_client.target_fields_retrieve(request_options=request_options)
        return _response.data


class AsyncFieldMappingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFieldMappingClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFieldMappingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFieldMappingClient
        """
        return self._raw_client

    async def field_mappings_retrieve(
        self,
        *,
        exclude_remote_field_metadata: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FieldMappingApiInstanceResponse:
        """
        Get all Field Mappings for this Linked Account. Field Mappings are mappings between third-party Remote Fields and user defined Merge fields. [Learn more](https://docs.merge.dev/supplemental-data/field-mappings/overview/).

        Parameters
        ----------
        exclude_remote_field_metadata : typing.Optional[bool]
            If `true`, remote fields metadata is excluded from each field mapping instance (i.e. `remote_fields.remote_key_name` and `remote_fields.schema` will be null). This will increase the speed of the request since these fields require some calculations.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FieldMappingApiInstanceResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.field_mapping.field_mappings_retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.field_mappings_retrieve(
            exclude_remote_field_metadata=exclude_remote_field_metadata, request_options=request_options
        )
        return _response.data

    async def field_mappings_create(
        self,
        *,
        target_field_name: str,
        target_field_description: str,
        remote_field_traversal_path: typing.Sequence[typing.Optional[typing.Any]],
        remote_method: str,
        remote_url_path: str,
        common_model_name: str,
        exclude_remote_field_metadata: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FieldMappingInstanceResponse:
        """
        Create new Field Mappings that will be available after the next scheduled sync. This will cause the next sync for this Linked Account to sync **ALL** data from start.

        Parameters
        ----------
        target_field_name : str
            The name of the target field you want this remote field to map to.

        target_field_description : str
            The description of the target field you want this remote field to map to.

        remote_field_traversal_path : typing.Sequence[typing.Optional[typing.Any]]
            The field traversal path of the remote field listed when you hit the GET /remote-fields endpoint.

        remote_method : str
            The method of the remote endpoint where the remote field is coming from.

        remote_url_path : str
            The path of the remote endpoint where the remote field is coming from.

        common_model_name : str
            The name of the Common Model that the remote field corresponds to in a given category.

        exclude_remote_field_metadata : typing.Optional[bool]
            If `true`, remote fields metadata is excluded from each field mapping instance (i.e. `remote_fields.remote_key_name` and `remote_fields.schema` will be null). This will increase the speed of the request since these fields require some calculations.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FieldMappingInstanceResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.field_mapping.field_mappings_create(
                target_field_name="example_target_field_name",
                target_field_description="this is a example description of the target field",
                remote_field_traversal_path=["example_remote_field"],
                remote_method="GET",
                remote_url_path="/example-url-path",
                common_model_name="ExampleCommonModel",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.field_mappings_create(
            target_field_name=target_field_name,
            target_field_description=target_field_description,
            remote_field_traversal_path=remote_field_traversal_path,
            remote_method=remote_method,
            remote_url_path=remote_url_path,
            common_model_name=common_model_name,
            exclude_remote_field_metadata=exclude_remote_field_metadata,
            request_options=request_options,
        )
        return _response.data

    async def field_mappings_destroy(
        self, field_mapping_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FieldMappingInstanceResponse:
        """
        Deletes Field Mappings for a Linked Account. All data related to this Field Mapping will be deleted and these changes will be reflected after the next scheduled sync. This will cause the next sync for this Linked Account to sync **ALL** data from start.

        Parameters
        ----------
        field_mapping_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FieldMappingInstanceResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.field_mapping.field_mappings_destroy(
                field_mapping_id="field_mapping_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.field_mappings_destroy(field_mapping_id, request_options=request_options)
        return _response.data

    async def field_mappings_partial_update(
        self,
        field_mapping_id: str,
        *,
        remote_field_traversal_path: typing.Optional[typing.Sequence[typing.Optional[typing.Any]]] = OMIT,
        remote_method: typing.Optional[str] = OMIT,
        remote_url_path: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FieldMappingInstanceResponse:
        """
        Create or update existing Field Mappings for a Linked Account. Changes will be reflected after the next scheduled sync. This will cause the next sync for this Linked Account to sync **ALL** data from start.

        Parameters
        ----------
        field_mapping_id : str

        remote_field_traversal_path : typing.Optional[typing.Sequence[typing.Optional[typing.Any]]]
            The field traversal path of the remote field listed when you hit the GET /remote-fields endpoint.

        remote_method : typing.Optional[str]
            The method of the remote endpoint where the remote field is coming from.

        remote_url_path : typing.Optional[str]
            The path of the remote endpoint where the remote field is coming from.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FieldMappingInstanceResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.field_mapping.field_mappings_partial_update(
                field_mapping_id="field_mapping_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.field_mappings_partial_update(
            field_mapping_id,
            remote_field_traversal_path=remote_field_traversal_path,
            remote_method=remote_method,
            remote_url_path=remote_url_path,
            request_options=request_options,
        )
        return _response.data

    async def remote_fields_retrieve(
        self,
        *,
        common_models: typing.Optional[str] = None,
        include_example_values: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RemoteFieldApiResponse:
        """
        Get all remote fields for a Linked Account. Remote fields are third-party fields that are accessible after initial sync if remote_data is enabled. You can use remote fields to override existing Merge fields or map a new Merge field. [Learn more](https://docs.merge.dev/supplemental-data/field-mappings/overview/).

        Parameters
        ----------
        common_models : typing.Optional[str]
            A comma seperated list of Common Model names. If included, will only return Remote Fields for those Common Models.

        include_example_values : typing.Optional[str]
            If true, will include example values, where available, for remote fields in the 3rd party platform. These examples come from active data from your customers.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RemoteFieldApiResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.field_mapping.remote_fields_retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.remote_fields_retrieve(
            common_models=common_models, include_example_values=include_example_values, request_options=request_options
        )
        return _response.data

    async def target_fields_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExternalTargetFieldApiResponse:
        """
        Get all organization-wide Target Fields, this will not include any Linked Account specific Target Fields. Organization-wide Target Fields are additional fields appended to the Merge Common Model for all Linked Accounts in a category. [Learn more](https://docs.merge.dev/supplemental-data/field-mappings/target-fields/).

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalTargetFieldApiResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.field_mapping.target_fields_retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.target_fields_retrieve(request_options=request_options)
        return _response.data
