# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.webhook_receiver import WebhookReceiver
from .raw_client import AsyncRawWebhookReceiversClient, RawWebhookReceiversClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WebhookReceiversClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWebhookReceiversClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWebhookReceiversClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWebhookReceiversClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[WebhookReceiver]:
        """
        Returns a list of `WebhookReceiver` objects.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[WebhookReceiver]


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.webhook_receivers.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        event: str,
        is_active: bool,
        key: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WebhookReceiver:
        """
        Creates a `WebhookReceiver` object with the given values.

        Parameters
        ----------
        event : str

        is_active : bool

        key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookReceiver


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ats.webhook_receivers.create(
            event="event",
            is_active=True,
        )
        """
        _response = self._raw_client.create(event=event, is_active=is_active, key=key, request_options=request_options)
        return _response.data


class AsyncWebhookReceiversClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWebhookReceiversClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWebhookReceiversClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWebhookReceiversClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[WebhookReceiver]:
        """
        Returns a list of `WebhookReceiver` objects.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[WebhookReceiver]


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.webhook_receivers.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        event: str,
        is_active: bool,
        key: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WebhookReceiver:
        """
        Creates a `WebhookReceiver` object with the given values.

        Parameters
        ----------
        event : str

        is_active : bool

        key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookReceiver


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ats.webhook_receivers.create(
                event="event",
                is_active=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            event=event, is_active=is_active, key=key, request_options=request_options
        )
        return _response.data
