# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .application_request_candidate import ApplicationRequestCandidate
from .application_request_credited_to import ApplicationRequestCreditedTo
from .application_request_current_stage import ApplicationRequestCurrentStage
from .application_request_job import ApplicationRequestJob
from .application_request_offers_item import ApplicationRequestOffersItem
from .application_request_reject_reason import ApplicationRequestRejectReason
from .application_request_screening_question_answers_item import ApplicationRequestScreeningQuestionAnswersItem


class ApplicationRequest(UncheckedBaseModel):
    """
    # The Application Object
    ### Description
    The Application Object is used to represent a candidate's journey through a particular Job's recruiting process. If a Candidate applies for multiple Jobs, there will be a separate Application for each Job if the third-party integration allows it.

    ### Usage Example
    Fetch from the `LIST Applications` endpoint and filter by `ID` to show all applications.
    """

    candidate: typing.Optional[ApplicationRequestCandidate] = pydantic.Field(default=None)
    """
    The candidate applying.
    """

    job: typing.Optional[ApplicationRequestJob] = pydantic.Field(default=None)
    """
    The job being applied for.
    """

    applied_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the application was submitted.
    """

    rejected_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the application was rejected.
    """

    offers: typing.Optional[typing.List[typing.Optional[ApplicationRequestOffersItem]]] = None
    source: typing.Optional[str] = pydantic.Field(default=None)
    """
    The application's source.
    """

    credited_to: typing.Optional[ApplicationRequestCreditedTo] = pydantic.Field(default=None)
    """
    The user credited for this application.
    """

    screening_question_answers: typing.Optional[typing.List[ApplicationRequestScreeningQuestionAnswersItem]] = None
    current_stage: typing.Optional[ApplicationRequestCurrentStage] = pydantic.Field(default=None)
    """
    The application's current stage.
    """

    reject_reason: typing.Optional[ApplicationRequestRejectReason] = pydantic.Field(default=None)
    """
    The application's reason for rejection.
    """

    remote_template_id: typing.Optional[str] = None
    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .application import Application  # noqa: E402, F401, I001
from .candidate import Candidate  # noqa: E402, F401, I001
from .offer import Offer  # noqa: E402, F401, I001

update_forward_refs(ApplicationRequest)
