# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .candidate_attachments_item import CandidateAttachmentsItem
from .email_address import EmailAddress
from .phone_number import PhoneNumber
from .remote_data import RemoteData
from .url import Url


class Candidate(UncheckedBaseModel):
    """
    # The Candidate Object
    ### Description
    The `Candidate` object is used to represent profile information about a given Candidate. Because it is specific to a Candidate, this information stays constant across applications.
    ### Usage Example
    Fetch from the `LIST Candidates` endpoint and filter by `ID` to show all candidates.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    first_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The candidate's first name.
    """

    last_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The candidate's last name.
    """

    company: typing.Optional[str] = pydantic.Field(default=None)
    """
    The candidate's current company.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The candidate's current title.
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's candidate was created.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's candidate was updated.
    """

    last_interaction_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the most recent interaction with the candidate occurred.
    """

    is_private: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the candidate is private.
    """

    can_email: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the candidate can be emailed.
    """

    locations: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    The candidate's locations.
    """

    phone_numbers: typing.Optional[typing.List[PhoneNumber]] = None
    email_addresses: typing.Optional[typing.List[EmailAddress]] = None
    urls: typing.Optional[typing.List[Url]] = None
    tags: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Array of `Tag` names as strings.
    """

    applications: typing.Optional[typing.List[typing.Optional["CandidateApplicationsItem"]]] = pydantic.Field(
        default=None
    )
    """
    Array of `Application` object IDs.
    """

    attachments: typing.Optional[typing.List[typing.Optional[CandidateAttachmentsItem]]] = pydantic.Field(default=None)
    """
    Array of `Attachment` object IDs.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .application import Application  # noqa: E402, F401, I001
from .offer import Offer  # noqa: E402, F401, I001
from .candidate_applications_item import CandidateApplicationsItem  # noqa: E402, F401, I001

update_forward_refs(Candidate)
