# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .eeoc_candidate import EeocCandidate
from .eeoc_disability_status import EeocDisabilityStatus
from .eeoc_gender import EeocGender
from .eeoc_race import EeocRace
from .eeoc_veteran_status import EeocVeteranStatus
from .remote_data import RemoteData


class Eeoc(UncheckedBaseModel):
    """
    # The EEOC Object
    ### Description
    The `EEOC` object is used to represent the Equal Employment Opportunity Commission information for a candidate (race, gender, veteran status, disability status).
    ### Usage Example
    Fetch from the `LIST EEOCs` endpoint and filter by `candidate` to show all EEOC information for a candidate.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    candidate: typing.Optional[EeocCandidate] = pydantic.Field(default=None)
    """
    The candidate being represented.
    """

    submitted_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the information was submitted.
    """

    race: typing.Optional[EeocRace] = pydantic.Field(default=None)
    """
    The candidate's race.
    
    * `AMERICAN_INDIAN_OR_ALASKAN_NATIVE` - AMERICAN_INDIAN_OR_ALASKAN_NATIVE
    * `ASIAN` - ASIAN
    * `BLACK_OR_AFRICAN_AMERICAN` - BLACK_OR_AFRICAN_AMERICAN
    * `HISPANIC_OR_LATINO` - HISPANIC_OR_LATINO
    * `WHITE` - WHITE
    * `NATIVE_HAWAIIAN_OR_OTHER_PACIFIC_ISLANDER` - NATIVE_HAWAIIAN_OR_OTHER_PACIFIC_ISLANDER
    * `TWO_OR_MORE_RACES` - TWO_OR_MORE_RACES
    * `DECLINE_TO_SELF_IDENTIFY` - DECLINE_TO_SELF_IDENTIFY
    """

    gender: typing.Optional[EeocGender] = pydantic.Field(default=None)
    """
    The candidate's gender.
    
    * `MALE` - MALE
    * `FEMALE` - FEMALE
    * `NON-BINARY` - NON-BINARY
    * `OTHER` - OTHER
    * `DECLINE_TO_SELF_IDENTIFY` - DECLINE_TO_SELF_IDENTIFY
    """

    veteran_status: typing.Optional[EeocVeteranStatus] = pydantic.Field(default=None)
    """
    The candidate's veteran status.
    
    * `I_AM_NOT_A_PROTECTED_VETERAN` - I_AM_NOT_A_PROTECTED_VETERAN
    * `I_IDENTIFY_AS_ONE_OR_MORE_OF_THE_CLASSIFICATIONS_OF_A_PROTECTED_VETERAN` - I_IDENTIFY_AS_ONE_OR_MORE_OF_THE_CLASSIFICATIONS_OF_A_PROTECTED_VETERAN
    * `I_DONT_WISH_TO_ANSWER` - I_DONT_WISH_TO_ANSWER
    """

    disability_status: typing.Optional[EeocDisabilityStatus] = pydantic.Field(default=None)
    """
    The candidate's disability status.
    
    * `YES_I_HAVE_A_DISABILITY_OR_PREVIOUSLY_HAD_A_DISABILITY` - YES_I_HAVE_A_DISABILITY_OR_PREVIOUSLY_HAD_A_DISABILITY
    * `NO_I_DONT_HAVE_A_DISABILITY` - NO_I_DONT_HAVE_A_DISABILITY
    * `I_DONT_WISH_TO_ANSWER` - I_DONT_WISH_TO_ANSWER
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .application import Application  # noqa: E402, F401, I001
from .candidate import Candidate  # noqa: E402, F401, I001
from .offer import Offer  # noqa: E402, F401, I001

update_forward_refs(Eeoc)
