# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .offer_creator import OfferCreator
from .offer_status import OfferStatus
from .remote_data import RemoteData


class Offer(UncheckedBaseModel):
    """
    # The Offer Object
    ### Description
    The `Offer` object is used to represent an offer for a candidate's application specific to a job.
    ### Usage Example
    Fetch from the `LIST Offers` endpoint and filter by `ID` to show all offers.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    application: typing.Optional["OfferApplication"] = pydantic.Field(default=None)
    """
    The application who is receiving the offer.
    """

    creator: typing.Optional[OfferCreator] = pydantic.Field(default=None)
    """
    The user who created the offer.
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's offer was created.
    """

    closed_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the offer was closed.
    """

    sent_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the offer was sent.
    """

    start_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The employment start date on the offer.
    """

    status: typing.Optional[OfferStatus] = pydantic.Field(default=None)
    """
    The offer's status.
    
    * `DRAFT` - DRAFT
    * `APPROVAL-SENT` - APPROVAL-SENT
    * `APPROVED` - APPROVED
    * `SENT` - SENT
    * `SENT-MANUALLY` - SENT-MANUALLY
    * `OPENED` - OPENED
    * `DENIED` - DENIED
    * `SIGNED` - SIGNED
    * `DEPRECATED` - DEPRECATED
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .application import Application  # noqa: E402, F401, I001
from .candidate import Candidate  # noqa: E402, F401, I001
from .offer_application import OfferApplication  # noqa: E402, F401, I001

update_forward_refs(Offer)
