# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .phone_number_phone_number_type import PhoneNumberPhoneNumberType


class PhoneNumber(UncheckedBaseModel):
    """
    # The PhoneNumber Object
    ### Description
    The `PhoneNumber` object is used to represent a candidate's phone number.
    ### Usage Example
    Fetch from the `GET Candidate` endpoint and view their phone numbers.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The phone number.
    """

    phone_number_type: typing.Optional[PhoneNumberPhoneNumberType] = pydantic.Field(default=None)
    """
    The type of phone number.
    
    * `HOME` - HOME
    * `WORK` - WORK
    * `MOBILE` - MOBILE
    * `SKYPE` - SKYPE
    * `OTHER` - OTHER
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
