# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .scheduled_interview_request_application import ScheduledInterviewRequestApplication
from .scheduled_interview_request_interviewers_item import ScheduledInterviewRequestInterviewersItem
from .scheduled_interview_request_job_interview_stage import ScheduledInterviewRequestJobInterviewStage
from .scheduled_interview_request_organizer import ScheduledInterviewRequestOrganizer
from .scheduled_interview_request_status import ScheduledInterviewRequestStatus


class ScheduledInterviewRequest(UncheckedBaseModel):
    """
    # The ScheduledInterview Object
    ### Description
    The `ScheduledInterview` object is used to represent a scheduled interview for a given candidate’s application to a job. An `Application` can have multiple `ScheduledInterview`s depending on the particular hiring process.
    ### Usage Example
    Fetch from the `LIST ScheduledInterviews` endpoint and filter by `interviewers` to show all office locations.
    """

    application: typing.Optional[ScheduledInterviewRequestApplication] = pydantic.Field(default=None)
    """
    The application being interviewed.
    """

    job_interview_stage: typing.Optional[ScheduledInterviewRequestJobInterviewStage] = pydantic.Field(default=None)
    """
    The stage of the interview.
    """

    organizer: typing.Optional[ScheduledInterviewRequestOrganizer] = pydantic.Field(default=None)
    """
    The user organizing the interview.
    """

    interviewers: typing.Optional[typing.List[typing.Optional[ScheduledInterviewRequestInterviewersItem]]] = (
        pydantic.Field(default=None)
    )
    """
    Array of `RemoteUser` IDs.
    """

    location: typing.Optional[str] = pydantic.Field(default=None)
    """
    The interview's location.
    """

    start_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the interview was started.
    """

    end_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the interview was ended.
    """

    status: typing.Optional[ScheduledInterviewRequestStatus] = pydantic.Field(default=None)
    """
    The interview's status.
    
    * `SCHEDULED` - SCHEDULED
    * `AWAITING_FEEDBACK` - AWAITING_FEEDBACK
    * `COMPLETE` - COMPLETE
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .application import Application  # noqa: E402, F401, I001
from .candidate import Candidate  # noqa: E402, F401, I001
from .offer import Offer  # noqa: E402, F401, I001

update_forward_refs(ScheduledInterviewRequest)
