# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .url_url_type import UrlUrlType


class Url(UncheckedBaseModel):
    """
    # The Url Object
    ### Description
    The `Url` object is used to represent hyperlinks associated with the parent model.
    ### Usage Example
    Fetch from the `GET Candidate` endpoint and view their website urls.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The site's url.
    """

    url_type: typing.Optional[UrlUrlType] = pydantic.Field(default=None)
    """
    The type of site.
    
    * `PERSONAL` - PERSONAL
    * `COMPANY` - COMPANY
    * `PORTFOLIO` - PORTFOLIO
    * `BLOG` - BLOG
    * `SOCIAL_MEDIA` - SOCIAL_MEDIA
    * `OTHER` - OTHER
    * `JOB_POSTING` - JOB_POSTING
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
