# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawCrmClient, RawCrmClient

if typing.TYPE_CHECKING:
    from .resources.account_details.client import AccountDetailsClient, AsyncAccountDetailsClient
    from .resources.account_token.client import AccountTokenClient, AsyncAccountTokenClient
    from .resources.accounts.client import AccountsClient, AsyncAccountsClient
    from .resources.association_types.client import AssociationTypesClient, AsyncAssociationTypesClient
    from .resources.associations.client import AssociationsClient, AsyncAssociationsClient
    from .resources.async_passthrough.client import AsyncAsyncPassthroughClient
    from .resources.async_passthrough.client import (
        AsyncPassthroughClient as resources_crm_resources_async_passthrough_client_AsyncPassthroughClient,
    )
    from .resources.audit_trail.client import AsyncAuditTrailClient, AuditTrailClient
    from .resources.available_actions.client import AsyncAvailableActionsClient, AvailableActionsClient
    from .resources.contacts.client import AsyncContactsClient, ContactsClient
    from .resources.custom_object_classes.client import AsyncCustomObjectClassesClient, CustomObjectClassesClient
    from .resources.custom_objects.client import AsyncCustomObjectsClient, CustomObjectsClient
    from .resources.delete_account.client import AsyncDeleteAccountClient, DeleteAccountClient
    from .resources.engagement_types.client import AsyncEngagementTypesClient, EngagementTypesClient
    from .resources.engagements.client import AsyncEngagementsClient, EngagementsClient
    from .resources.field_mapping.client import AsyncFieldMappingClient, FieldMappingClient
    from .resources.force_resync.client import AsyncForceResyncClient, ForceResyncClient
    from .resources.generate_key.client import AsyncGenerateKeyClient, GenerateKeyClient
    from .resources.issues.client import AsyncIssuesClient, IssuesClient
    from .resources.leads.client import AsyncLeadsClient, LeadsClient
    from .resources.link_token.client import AsyncLinkTokenClient, LinkTokenClient
    from .resources.linked_accounts.client import AsyncLinkedAccountsClient, LinkedAccountsClient
    from .resources.notes.client import AsyncNotesClient, NotesClient
    from .resources.opportunities.client import AsyncOpportunitiesClient, OpportunitiesClient
    from .resources.passthrough.client import (
        AsyncPassthroughClient as resources_crm_resources_passthrough_client_AsyncPassthroughClient,
    )
    from .resources.passthrough.client import PassthroughClient
    from .resources.regenerate_key.client import AsyncRegenerateKeyClient, RegenerateKeyClient
    from .resources.scopes.client import AsyncScopesClient, ScopesClient
    from .resources.stages.client import AsyncStagesClient, StagesClient
    from .resources.sync_status.client import AsyncSyncStatusClient, SyncStatusClient
    from .resources.tasks.client import AsyncTasksClient, TasksClient
    from .resources.users.client import AsyncUsersClient, UsersClient
    from .resources.webhook_receivers.client import AsyncWebhookReceiversClient, WebhookReceiversClient


class CrmClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCrmClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._account_details: typing.Optional[AccountDetailsClient] = None
        self._account_token: typing.Optional[AccountTokenClient] = None
        self._accounts: typing.Optional[AccountsClient] = None
        self._async_passthrough: typing.Optional[
            resources_crm_resources_async_passthrough_client_AsyncPassthroughClient
        ] = None
        self._audit_trail: typing.Optional[AuditTrailClient] = None
        self._available_actions: typing.Optional[AvailableActionsClient] = None
        self._contacts: typing.Optional[ContactsClient] = None
        self._custom_object_classes: typing.Optional[CustomObjectClassesClient] = None
        self._association_types: typing.Optional[AssociationTypesClient] = None
        self._custom_objects: typing.Optional[CustomObjectsClient] = None
        self._associations: typing.Optional[AssociationsClient] = None
        self._scopes: typing.Optional[ScopesClient] = None
        self._delete_account: typing.Optional[DeleteAccountClient] = None
        self._engagement_types: typing.Optional[EngagementTypesClient] = None
        self._engagements: typing.Optional[EngagementsClient] = None
        self._field_mapping: typing.Optional[FieldMappingClient] = None
        self._generate_key: typing.Optional[GenerateKeyClient] = None
        self._issues: typing.Optional[IssuesClient] = None
        self._leads: typing.Optional[LeadsClient] = None
        self._link_token: typing.Optional[LinkTokenClient] = None
        self._linked_accounts: typing.Optional[LinkedAccountsClient] = None
        self._notes: typing.Optional[NotesClient] = None
        self._opportunities: typing.Optional[OpportunitiesClient] = None
        self._passthrough: typing.Optional[PassthroughClient] = None
        self._regenerate_key: typing.Optional[RegenerateKeyClient] = None
        self._stages: typing.Optional[StagesClient] = None
        self._sync_status: typing.Optional[SyncStatusClient] = None
        self._force_resync: typing.Optional[ForceResyncClient] = None
        self._tasks: typing.Optional[TasksClient] = None
        self._users: typing.Optional[UsersClient] = None
        self._webhook_receivers: typing.Optional[WebhookReceiversClient] = None

    @property
    def with_raw_response(self) -> RawCrmClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCrmClient
        """
        return self._raw_client

    @property
    def account_details(self):
        if self._account_details is None:
            from .resources.account_details.client import AccountDetailsClient  # noqa: E402

            self._account_details = AccountDetailsClient(client_wrapper=self._client_wrapper)
        return self._account_details

    @property
    def account_token(self):
        if self._account_token is None:
            from .resources.account_token.client import AccountTokenClient  # noqa: E402

            self._account_token = AccountTokenClient(client_wrapper=self._client_wrapper)
        return self._account_token

    @property
    def accounts(self):
        if self._accounts is None:
            from .resources.accounts.client import AccountsClient  # noqa: E402

            self._accounts = AccountsClient(client_wrapper=self._client_wrapper)
        return self._accounts

    @property
    def async_passthrough(self):
        if self._async_passthrough is None:
            from .resources.async_passthrough.client import (
                AsyncPassthroughClient as resources_crm_resources_async_passthrough_client_AsyncPassthroughClient,  # noqa: E402
            )

            self._async_passthrough = resources_crm_resources_async_passthrough_client_AsyncPassthroughClient(
                client_wrapper=self._client_wrapper
            )
        return self._async_passthrough

    @property
    def audit_trail(self):
        if self._audit_trail is None:
            from .resources.audit_trail.client import AuditTrailClient  # noqa: E402

            self._audit_trail = AuditTrailClient(client_wrapper=self._client_wrapper)
        return self._audit_trail

    @property
    def available_actions(self):
        if self._available_actions is None:
            from .resources.available_actions.client import AvailableActionsClient  # noqa: E402

            self._available_actions = AvailableActionsClient(client_wrapper=self._client_wrapper)
        return self._available_actions

    @property
    def contacts(self):
        if self._contacts is None:
            from .resources.contacts.client import ContactsClient  # noqa: E402

            self._contacts = ContactsClient(client_wrapper=self._client_wrapper)
        return self._contacts

    @property
    def custom_object_classes(self):
        if self._custom_object_classes is None:
            from .resources.custom_object_classes.client import CustomObjectClassesClient  # noqa: E402

            self._custom_object_classes = CustomObjectClassesClient(client_wrapper=self._client_wrapper)
        return self._custom_object_classes

    @property
    def association_types(self):
        if self._association_types is None:
            from .resources.association_types.client import AssociationTypesClient  # noqa: E402

            self._association_types = AssociationTypesClient(client_wrapper=self._client_wrapper)
        return self._association_types

    @property
    def custom_objects(self):
        if self._custom_objects is None:
            from .resources.custom_objects.client import CustomObjectsClient  # noqa: E402

            self._custom_objects = CustomObjectsClient(client_wrapper=self._client_wrapper)
        return self._custom_objects

    @property
    def associations(self):
        if self._associations is None:
            from .resources.associations.client import AssociationsClient  # noqa: E402

            self._associations = AssociationsClient(client_wrapper=self._client_wrapper)
        return self._associations

    @property
    def scopes(self):
        if self._scopes is None:
            from .resources.scopes.client import ScopesClient  # noqa: E402

            self._scopes = ScopesClient(client_wrapper=self._client_wrapper)
        return self._scopes

    @property
    def delete_account(self):
        if self._delete_account is None:
            from .resources.delete_account.client import DeleteAccountClient  # noqa: E402

            self._delete_account = DeleteAccountClient(client_wrapper=self._client_wrapper)
        return self._delete_account

    @property
    def engagement_types(self):
        if self._engagement_types is None:
            from .resources.engagement_types.client import EngagementTypesClient  # noqa: E402

            self._engagement_types = EngagementTypesClient(client_wrapper=self._client_wrapper)
        return self._engagement_types

    @property
    def engagements(self):
        if self._engagements is None:
            from .resources.engagements.client import EngagementsClient  # noqa: E402

            self._engagements = EngagementsClient(client_wrapper=self._client_wrapper)
        return self._engagements

    @property
    def field_mapping(self):
        if self._field_mapping is None:
            from .resources.field_mapping.client import FieldMappingClient  # noqa: E402

            self._field_mapping = FieldMappingClient(client_wrapper=self._client_wrapper)
        return self._field_mapping

    @property
    def generate_key(self):
        if self._generate_key is None:
            from .resources.generate_key.client import GenerateKeyClient  # noqa: E402

            self._generate_key = GenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._generate_key

    @property
    def issues(self):
        if self._issues is None:
            from .resources.issues.client import IssuesClient  # noqa: E402

            self._issues = IssuesClient(client_wrapper=self._client_wrapper)
        return self._issues

    @property
    def leads(self):
        if self._leads is None:
            from .resources.leads.client import LeadsClient  # noqa: E402

            self._leads = LeadsClient(client_wrapper=self._client_wrapper)
        return self._leads

    @property
    def link_token(self):
        if self._link_token is None:
            from .resources.link_token.client import LinkTokenClient  # noqa: E402

            self._link_token = LinkTokenClient(client_wrapper=self._client_wrapper)
        return self._link_token

    @property
    def linked_accounts(self):
        if self._linked_accounts is None:
            from .resources.linked_accounts.client import LinkedAccountsClient  # noqa: E402

            self._linked_accounts = LinkedAccountsClient(client_wrapper=self._client_wrapper)
        return self._linked_accounts

    @property
    def notes(self):
        if self._notes is None:
            from .resources.notes.client import NotesClient  # noqa: E402

            self._notes = NotesClient(client_wrapper=self._client_wrapper)
        return self._notes

    @property
    def opportunities(self):
        if self._opportunities is None:
            from .resources.opportunities.client import OpportunitiesClient  # noqa: E402

            self._opportunities = OpportunitiesClient(client_wrapper=self._client_wrapper)
        return self._opportunities

    @property
    def passthrough(self):
        if self._passthrough is None:
            from .resources.passthrough.client import PassthroughClient  # noqa: E402

            self._passthrough = PassthroughClient(client_wrapper=self._client_wrapper)
        return self._passthrough

    @property
    def regenerate_key(self):
        if self._regenerate_key is None:
            from .resources.regenerate_key.client import RegenerateKeyClient  # noqa: E402

            self._regenerate_key = RegenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._regenerate_key

    @property
    def stages(self):
        if self._stages is None:
            from .resources.stages.client import StagesClient  # noqa: E402

            self._stages = StagesClient(client_wrapper=self._client_wrapper)
        return self._stages

    @property
    def sync_status(self):
        if self._sync_status is None:
            from .resources.sync_status.client import SyncStatusClient  # noqa: E402

            self._sync_status = SyncStatusClient(client_wrapper=self._client_wrapper)
        return self._sync_status

    @property
    def force_resync(self):
        if self._force_resync is None:
            from .resources.force_resync.client import ForceResyncClient  # noqa: E402

            self._force_resync = ForceResyncClient(client_wrapper=self._client_wrapper)
        return self._force_resync

    @property
    def tasks(self):
        if self._tasks is None:
            from .resources.tasks.client import TasksClient  # noqa: E402

            self._tasks = TasksClient(client_wrapper=self._client_wrapper)
        return self._tasks

    @property
    def users(self):
        if self._users is None:
            from .resources.users.client import UsersClient  # noqa: E402

            self._users = UsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def webhook_receivers(self):
        if self._webhook_receivers is None:
            from .resources.webhook_receivers.client import WebhookReceiversClient  # noqa: E402

            self._webhook_receivers = WebhookReceiversClient(client_wrapper=self._client_wrapper)
        return self._webhook_receivers


class AsyncCrmClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCrmClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._account_details: typing.Optional[AsyncAccountDetailsClient] = None
        self._account_token: typing.Optional[AsyncAccountTokenClient] = None
        self._accounts: typing.Optional[AsyncAccountsClient] = None
        self._async_passthrough: typing.Optional[AsyncAsyncPassthroughClient] = None
        self._audit_trail: typing.Optional[AsyncAuditTrailClient] = None
        self._available_actions: typing.Optional[AsyncAvailableActionsClient] = None
        self._contacts: typing.Optional[AsyncContactsClient] = None
        self._custom_object_classes: typing.Optional[AsyncCustomObjectClassesClient] = None
        self._association_types: typing.Optional[AsyncAssociationTypesClient] = None
        self._custom_objects: typing.Optional[AsyncCustomObjectsClient] = None
        self._associations: typing.Optional[AsyncAssociationsClient] = None
        self._scopes: typing.Optional[AsyncScopesClient] = None
        self._delete_account: typing.Optional[AsyncDeleteAccountClient] = None
        self._engagement_types: typing.Optional[AsyncEngagementTypesClient] = None
        self._engagements: typing.Optional[AsyncEngagementsClient] = None
        self._field_mapping: typing.Optional[AsyncFieldMappingClient] = None
        self._generate_key: typing.Optional[AsyncGenerateKeyClient] = None
        self._issues: typing.Optional[AsyncIssuesClient] = None
        self._leads: typing.Optional[AsyncLeadsClient] = None
        self._link_token: typing.Optional[AsyncLinkTokenClient] = None
        self._linked_accounts: typing.Optional[AsyncLinkedAccountsClient] = None
        self._notes: typing.Optional[AsyncNotesClient] = None
        self._opportunities: typing.Optional[AsyncOpportunitiesClient] = None
        self._passthrough: typing.Optional[resources_crm_resources_passthrough_client_AsyncPassthroughClient] = None
        self._regenerate_key: typing.Optional[AsyncRegenerateKeyClient] = None
        self._stages: typing.Optional[AsyncStagesClient] = None
        self._sync_status: typing.Optional[AsyncSyncStatusClient] = None
        self._force_resync: typing.Optional[AsyncForceResyncClient] = None
        self._tasks: typing.Optional[AsyncTasksClient] = None
        self._users: typing.Optional[AsyncUsersClient] = None
        self._webhook_receivers: typing.Optional[AsyncWebhookReceiversClient] = None

    @property
    def with_raw_response(self) -> AsyncRawCrmClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCrmClient
        """
        return self._raw_client

    @property
    def account_details(self):
        if self._account_details is None:
            from .resources.account_details.client import AsyncAccountDetailsClient  # noqa: E402

            self._account_details = AsyncAccountDetailsClient(client_wrapper=self._client_wrapper)
        return self._account_details

    @property
    def account_token(self):
        if self._account_token is None:
            from .resources.account_token.client import AsyncAccountTokenClient  # noqa: E402

            self._account_token = AsyncAccountTokenClient(client_wrapper=self._client_wrapper)
        return self._account_token

    @property
    def accounts(self):
        if self._accounts is None:
            from .resources.accounts.client import AsyncAccountsClient  # noqa: E402

            self._accounts = AsyncAccountsClient(client_wrapper=self._client_wrapper)
        return self._accounts

    @property
    def async_passthrough(self):
        if self._async_passthrough is None:
            from .resources.async_passthrough.client import AsyncAsyncPassthroughClient  # noqa: E402

            self._async_passthrough = AsyncAsyncPassthroughClient(client_wrapper=self._client_wrapper)
        return self._async_passthrough

    @property
    def audit_trail(self):
        if self._audit_trail is None:
            from .resources.audit_trail.client import AsyncAuditTrailClient  # noqa: E402

            self._audit_trail = AsyncAuditTrailClient(client_wrapper=self._client_wrapper)
        return self._audit_trail

    @property
    def available_actions(self):
        if self._available_actions is None:
            from .resources.available_actions.client import AsyncAvailableActionsClient  # noqa: E402

            self._available_actions = AsyncAvailableActionsClient(client_wrapper=self._client_wrapper)
        return self._available_actions

    @property
    def contacts(self):
        if self._contacts is None:
            from .resources.contacts.client import AsyncContactsClient  # noqa: E402

            self._contacts = AsyncContactsClient(client_wrapper=self._client_wrapper)
        return self._contacts

    @property
    def custom_object_classes(self):
        if self._custom_object_classes is None:
            from .resources.custom_object_classes.client import AsyncCustomObjectClassesClient  # noqa: E402

            self._custom_object_classes = AsyncCustomObjectClassesClient(client_wrapper=self._client_wrapper)
        return self._custom_object_classes

    @property
    def association_types(self):
        if self._association_types is None:
            from .resources.association_types.client import AsyncAssociationTypesClient  # noqa: E402

            self._association_types = AsyncAssociationTypesClient(client_wrapper=self._client_wrapper)
        return self._association_types

    @property
    def custom_objects(self):
        if self._custom_objects is None:
            from .resources.custom_objects.client import AsyncCustomObjectsClient  # noqa: E402

            self._custom_objects = AsyncCustomObjectsClient(client_wrapper=self._client_wrapper)
        return self._custom_objects

    @property
    def associations(self):
        if self._associations is None:
            from .resources.associations.client import AsyncAssociationsClient  # noqa: E402

            self._associations = AsyncAssociationsClient(client_wrapper=self._client_wrapper)
        return self._associations

    @property
    def scopes(self):
        if self._scopes is None:
            from .resources.scopes.client import AsyncScopesClient  # noqa: E402

            self._scopes = AsyncScopesClient(client_wrapper=self._client_wrapper)
        return self._scopes

    @property
    def delete_account(self):
        if self._delete_account is None:
            from .resources.delete_account.client import AsyncDeleteAccountClient  # noqa: E402

            self._delete_account = AsyncDeleteAccountClient(client_wrapper=self._client_wrapper)
        return self._delete_account

    @property
    def engagement_types(self):
        if self._engagement_types is None:
            from .resources.engagement_types.client import AsyncEngagementTypesClient  # noqa: E402

            self._engagement_types = AsyncEngagementTypesClient(client_wrapper=self._client_wrapper)
        return self._engagement_types

    @property
    def engagements(self):
        if self._engagements is None:
            from .resources.engagements.client import AsyncEngagementsClient  # noqa: E402

            self._engagements = AsyncEngagementsClient(client_wrapper=self._client_wrapper)
        return self._engagements

    @property
    def field_mapping(self):
        if self._field_mapping is None:
            from .resources.field_mapping.client import AsyncFieldMappingClient  # noqa: E402

            self._field_mapping = AsyncFieldMappingClient(client_wrapper=self._client_wrapper)
        return self._field_mapping

    @property
    def generate_key(self):
        if self._generate_key is None:
            from .resources.generate_key.client import AsyncGenerateKeyClient  # noqa: E402

            self._generate_key = AsyncGenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._generate_key

    @property
    def issues(self):
        if self._issues is None:
            from .resources.issues.client import AsyncIssuesClient  # noqa: E402

            self._issues = AsyncIssuesClient(client_wrapper=self._client_wrapper)
        return self._issues

    @property
    def leads(self):
        if self._leads is None:
            from .resources.leads.client import AsyncLeadsClient  # noqa: E402

            self._leads = AsyncLeadsClient(client_wrapper=self._client_wrapper)
        return self._leads

    @property
    def link_token(self):
        if self._link_token is None:
            from .resources.link_token.client import AsyncLinkTokenClient  # noqa: E402

            self._link_token = AsyncLinkTokenClient(client_wrapper=self._client_wrapper)
        return self._link_token

    @property
    def linked_accounts(self):
        if self._linked_accounts is None:
            from .resources.linked_accounts.client import AsyncLinkedAccountsClient  # noqa: E402

            self._linked_accounts = AsyncLinkedAccountsClient(client_wrapper=self._client_wrapper)
        return self._linked_accounts

    @property
    def notes(self):
        if self._notes is None:
            from .resources.notes.client import AsyncNotesClient  # noqa: E402

            self._notes = AsyncNotesClient(client_wrapper=self._client_wrapper)
        return self._notes

    @property
    def opportunities(self):
        if self._opportunities is None:
            from .resources.opportunities.client import AsyncOpportunitiesClient  # noqa: E402

            self._opportunities = AsyncOpportunitiesClient(client_wrapper=self._client_wrapper)
        return self._opportunities

    @property
    def passthrough(self):
        if self._passthrough is None:
            from .resources.passthrough.client import (
                AsyncPassthroughClient as resources_crm_resources_passthrough_client_AsyncPassthroughClient,  # noqa: E402
            )

            self._passthrough = resources_crm_resources_passthrough_client_AsyncPassthroughClient(
                client_wrapper=self._client_wrapper
            )
        return self._passthrough

    @property
    def regenerate_key(self):
        if self._regenerate_key is None:
            from .resources.regenerate_key.client import AsyncRegenerateKeyClient  # noqa: E402

            self._regenerate_key = AsyncRegenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._regenerate_key

    @property
    def stages(self):
        if self._stages is None:
            from .resources.stages.client import AsyncStagesClient  # noqa: E402

            self._stages = AsyncStagesClient(client_wrapper=self._client_wrapper)
        return self._stages

    @property
    def sync_status(self):
        if self._sync_status is None:
            from .resources.sync_status.client import AsyncSyncStatusClient  # noqa: E402

            self._sync_status = AsyncSyncStatusClient(client_wrapper=self._client_wrapper)
        return self._sync_status

    @property
    def force_resync(self):
        if self._force_resync is None:
            from .resources.force_resync.client import AsyncForceResyncClient  # noqa: E402

            self._force_resync = AsyncForceResyncClient(client_wrapper=self._client_wrapper)
        return self._force_resync

    @property
    def tasks(self):
        if self._tasks is None:
            from .resources.tasks.client import AsyncTasksClient  # noqa: E402

            self._tasks = AsyncTasksClient(client_wrapper=self._client_wrapper)
        return self._tasks

    @property
    def users(self):
        if self._users is None:
            from .resources.users.client import AsyncUsersClient  # noqa: E402

            self._users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def webhook_receivers(self):
        if self._webhook_receivers is None:
            from .resources.webhook_receivers.client import AsyncWebhookReceiversClient  # noqa: E402

            self._webhook_receivers = AsyncWebhookReceiversClient(client_wrapper=self._client_wrapper)
        return self._webhook_receivers
