# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.association import Association
from ...types.paginated_association_list import PaginatedAssociationList
from .raw_client import AsyncRawAssociationsClient, RawAssociationsClient


class AssociationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAssociationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAssociationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAssociationsClient
        """
        return self._raw_client

    def custom_object_classes_custom_objects_associations_list(
        self,
        custom_object_class_id: str,
        object_id: str,
        *,
        association_type_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[typing.Literal["association_type"]] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedAssociationList:
        """
        Returns a list of `Association` objects.

        Parameters
        ----------
        custom_object_class_id : str

        object_id : str

        association_type_id : typing.Optional[str]
            If provided, will only return opportunities with this association_type.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[typing.Literal["association_type"]]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedAssociationList


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.associations.custom_object_classes_custom_objects_associations_list(
            custom_object_class_id="custom_object_class_id",
            object_id="object_id",
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
        )
        """
        _response = self._raw_client.custom_object_classes_custom_objects_associations_list(
            custom_object_class_id,
            object_id,
            association_type_id=association_type_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            remote_id=remote_id,
            request_options=request_options,
        )
        return _response.data

    def custom_object_classes_custom_objects_associations_update(
        self,
        association_type_id: str,
        source_class_id: str,
        source_object_id: str,
        target_class_id: str,
        target_object_id: str,
        *,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Association:
        """
        Creates an Association between `source_object_id` and `target_object_id` of type `association_type_id`.

        Parameters
        ----------
        association_type_id : str

        source_class_id : str

        source_object_id : str

        target_class_id : str

        target_object_id : str

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Association


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.associations.custom_object_classes_custom_objects_associations_update(
            association_type_id="association_type_id",
            source_class_id="source_class_id",
            source_object_id="source_object_id",
            target_class_id="target_class_id",
            target_object_id="target_object_id",
        )
        """
        _response = self._raw_client.custom_object_classes_custom_objects_associations_update(
            association_type_id,
            source_class_id,
            source_object_id,
            target_class_id,
            target_object_id,
            is_debug_mode=is_debug_mode,
            run_async=run_async,
            request_options=request_options,
        )
        return _response.data


class AsyncAssociationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAssociationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAssociationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAssociationsClient
        """
        return self._raw_client

    async def custom_object_classes_custom_objects_associations_list(
        self,
        custom_object_class_id: str,
        object_id: str,
        *,
        association_type_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[typing.Literal["association_type"]] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedAssociationList:
        """
        Returns a list of `Association` objects.

        Parameters
        ----------
        custom_object_class_id : str

        object_id : str

        association_type_id : typing.Optional[str]
            If provided, will only return opportunities with this association_type.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[typing.Literal["association_type"]]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedAssociationList


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.associations.custom_object_classes_custom_objects_associations_list(
                custom_object_class_id="custom_object_class_id",
                object_id="object_id",
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.custom_object_classes_custom_objects_associations_list(
            custom_object_class_id,
            object_id,
            association_type_id=association_type_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            remote_id=remote_id,
            request_options=request_options,
        )
        return _response.data

    async def custom_object_classes_custom_objects_associations_update(
        self,
        association_type_id: str,
        source_class_id: str,
        source_object_id: str,
        target_class_id: str,
        target_object_id: str,
        *,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Association:
        """
        Creates an Association between `source_object_id` and `target_object_id` of type `association_type_id`.

        Parameters
        ----------
        association_type_id : str

        source_class_id : str

        source_object_id : str

        target_class_id : str

        target_object_id : str

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Association


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.associations.custom_object_classes_custom_objects_associations_update(
                association_type_id="association_type_id",
                source_class_id="source_class_id",
                source_object_id="source_object_id",
                target_class_id="target_class_id",
                target_object_id="target_object_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.custom_object_classes_custom_objects_associations_update(
            association_type_id,
            source_class_id,
            source_object_id,
            target_class_id,
            target_object_id,
            is_debug_mode=is_debug_mode,
            run_async=run_async,
            request_options=request_options,
        )
        return _response.data
