# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.async_passthrough_reciept import AsyncPassthroughReciept
from ...types.data_passthrough_request import DataPassthroughRequest
from .raw_client import AsyncRawAsyncPassthroughClient, RawAsyncPassthroughClient
from .types.async_passthrough_retrieve_response import AsyncPassthroughRetrieveResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AsyncPassthroughClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAsyncPassthroughClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAsyncPassthroughClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAsyncPassthroughClient
        """
        return self._raw_client

    def create(
        self, *, request: DataPassthroughRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncPassthroughReciept:
        """
        Asynchronously pull data from an endpoint not currently supported by Merge.

        Parameters
        ----------
        request : DataPassthroughRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPassthroughReciept


        Examples
        --------
        from merge import Merge
        from merge.resources.crm import DataPassthroughRequest, MethodEnum

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.async_passthrough.create(
            request=DataPassthroughRequest(
                method=MethodEnum.GET,
                path="/scooters",
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def retrieve(
        self, async_passthrough_receipt_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncPassthroughRetrieveResponse:
        """
        Retrieves data from earlier async-passthrough POST request

        Parameters
        ----------
        async_passthrough_receipt_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPassthroughRetrieveResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.async_passthrough.retrieve(
            async_passthrough_receipt_id="async_passthrough_receipt_id",
        )
        """
        _response = self._raw_client.retrieve(async_passthrough_receipt_id, request_options=request_options)
        return _response.data


class AsyncAsyncPassthroughClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAsyncPassthroughClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAsyncPassthroughClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAsyncPassthroughClient
        """
        return self._raw_client

    async def create(
        self, *, request: DataPassthroughRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncPassthroughReciept:
        """
        Asynchronously pull data from an endpoint not currently supported by Merge.

        Parameters
        ----------
        request : DataPassthroughRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPassthroughReciept


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.crm import DataPassthroughRequest, MethodEnum

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.async_passthrough.create(
                request=DataPassthroughRequest(
                    method=MethodEnum.GET,
                    path="/scooters",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def retrieve(
        self, async_passthrough_receipt_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncPassthroughRetrieveResponse:
        """
        Retrieves data from earlier async-passthrough POST request

        Parameters
        ----------
        async_passthrough_receipt_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPassthroughRetrieveResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.async_passthrough.retrieve(
                async_passthrough_receipt_id="async_passthrough_receipt_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(async_passthrough_receipt_id, request_options=request_options)
        return _response.data
