# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.categories_enum import CategoriesEnum
from ...types.common_model_scopes_body_request import CommonModelScopesBodyRequest
from ...types.individual_common_model_scope_deserializer_request import IndividualCommonModelScopeDeserializerRequest
from ...types.link_token import LinkToken
from .raw_client import AsyncRawLinkTokenClient, RawLinkTokenClient
from .types.end_user_details_request_language import EndUserDetailsRequestLanguage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class LinkTokenClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawLinkTokenClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawLinkTokenClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawLinkTokenClient
        """
        return self._raw_client

    def create(
        self,
        *,
        end_user_email_address: str,
        end_user_organization_name: str,
        end_user_origin_id: str,
        categories: typing.Sequence[CategoriesEnum],
        integration: typing.Optional[str] = OMIT,
        link_expiry_mins: typing.Optional[int] = OMIT,
        should_create_magic_link_url: typing.Optional[bool] = OMIT,
        hide_admin_magic_link: typing.Optional[bool] = OMIT,
        common_models: typing.Optional[typing.Sequence[CommonModelScopesBodyRequest]] = OMIT,
        category_common_model_scopes: typing.Optional[
            typing.Dict[str, typing.Optional[typing.Sequence[IndividualCommonModelScopeDeserializerRequest]]]
        ] = OMIT,
        language: typing.Optional[EndUserDetailsRequestLanguage] = OMIT,
        are_syncs_disabled: typing.Optional[bool] = OMIT,
        integration_specific_config: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LinkToken:
        """
        Creates a link token to be used when linking a new end user.

        Parameters
        ----------
        end_user_email_address : str
            Your end user's email address. This is purely for identification purposes - setting this value will not cause any emails to be sent.

        end_user_organization_name : str
            Your end user's organization.

        end_user_origin_id : str
            This unique identifier typically represents the ID for your end user in your product's database. This value must be distinct from other Linked Accounts' unique identifiers.

        categories : typing.Sequence[CategoriesEnum]
            The integration categories to show in Merge Link.

        integration : typing.Optional[str]
            The slug of a specific pre-selected integration for this linking flow token. For examples of slugs, see https://docs.merge.dev/guides/merge-link/single-integration/.

        link_expiry_mins : typing.Optional[int]
            An integer number of minutes between [30, 720 or 10080 if for a Magic Link URL] for how long this token is valid. Defaults to 30.

        should_create_magic_link_url : typing.Optional[bool]
            Whether to generate a Magic Link URL. Defaults to false. For more information on Magic Link, see https://merge.dev/blog/integrations-fast-say-hello-to-magic-link.

        hide_admin_magic_link : typing.Optional[bool]
            Whether to generate a Magic Link URL on the Admin Needed screen during the linking flow. Defaults to false. For more information on Magic Link, see https://merge.dev/blog/integrations-fast-say-hello-to-magic-link.

        common_models : typing.Optional[typing.Sequence[CommonModelScopesBodyRequest]]
            An array of objects to specify the models and fields that will be disabled for a given Linked Account. Each object uses model_id, enabled_actions, and disabled_fields to specify the model, method, and fields that are scoped for a given Linked Account.

        category_common_model_scopes : typing.Optional[typing.Dict[str, typing.Optional[typing.Sequence[IndividualCommonModelScopeDeserializerRequest]]]]
            When creating a Link Token, you can set permissions for Common Models that will apply to the account that is going to be linked. Any model or field not specified in link token payload will default to existing settings.

        language : typing.Optional[EndUserDetailsRequestLanguage]
            The following subset of IETF language tags can be used to configure localization.

            * `en` - en
            * `de` - de

        are_syncs_disabled : typing.Optional[bool]
            The boolean that indicates whether initial, periodic, and force syncs will be disabled.

        integration_specific_config : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A JSON object containing integration-specific configuration options.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LinkToken


        Examples
        --------
        from merge import Merge
        from merge.resources.crm import CategoriesEnum

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.link_token.create(
            end_user_email_address="example@gmail.com",
            end_user_organization_name="Test Organization",
            end_user_origin_id="12345",
            categories=[CategoriesEnum.HRIS, CategoriesEnum.ATS],
        )
        """
        _response = self._raw_client.create(
            end_user_email_address=end_user_email_address,
            end_user_organization_name=end_user_organization_name,
            end_user_origin_id=end_user_origin_id,
            categories=categories,
            integration=integration,
            link_expiry_mins=link_expiry_mins,
            should_create_magic_link_url=should_create_magic_link_url,
            hide_admin_magic_link=hide_admin_magic_link,
            common_models=common_models,
            category_common_model_scopes=category_common_model_scopes,
            language=language,
            are_syncs_disabled=are_syncs_disabled,
            integration_specific_config=integration_specific_config,
            request_options=request_options,
        )
        return _response.data


class AsyncLinkTokenClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawLinkTokenClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawLinkTokenClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawLinkTokenClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        end_user_email_address: str,
        end_user_organization_name: str,
        end_user_origin_id: str,
        categories: typing.Sequence[CategoriesEnum],
        integration: typing.Optional[str] = OMIT,
        link_expiry_mins: typing.Optional[int] = OMIT,
        should_create_magic_link_url: typing.Optional[bool] = OMIT,
        hide_admin_magic_link: typing.Optional[bool] = OMIT,
        common_models: typing.Optional[typing.Sequence[CommonModelScopesBodyRequest]] = OMIT,
        category_common_model_scopes: typing.Optional[
            typing.Dict[str, typing.Optional[typing.Sequence[IndividualCommonModelScopeDeserializerRequest]]]
        ] = OMIT,
        language: typing.Optional[EndUserDetailsRequestLanguage] = OMIT,
        are_syncs_disabled: typing.Optional[bool] = OMIT,
        integration_specific_config: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LinkToken:
        """
        Creates a link token to be used when linking a new end user.

        Parameters
        ----------
        end_user_email_address : str
            Your end user's email address. This is purely for identification purposes - setting this value will not cause any emails to be sent.

        end_user_organization_name : str
            Your end user's organization.

        end_user_origin_id : str
            This unique identifier typically represents the ID for your end user in your product's database. This value must be distinct from other Linked Accounts' unique identifiers.

        categories : typing.Sequence[CategoriesEnum]
            The integration categories to show in Merge Link.

        integration : typing.Optional[str]
            The slug of a specific pre-selected integration for this linking flow token. For examples of slugs, see https://docs.merge.dev/guides/merge-link/single-integration/.

        link_expiry_mins : typing.Optional[int]
            An integer number of minutes between [30, 720 or 10080 if for a Magic Link URL] for how long this token is valid. Defaults to 30.

        should_create_magic_link_url : typing.Optional[bool]
            Whether to generate a Magic Link URL. Defaults to false. For more information on Magic Link, see https://merge.dev/blog/integrations-fast-say-hello-to-magic-link.

        hide_admin_magic_link : typing.Optional[bool]
            Whether to generate a Magic Link URL on the Admin Needed screen during the linking flow. Defaults to false. For more information on Magic Link, see https://merge.dev/blog/integrations-fast-say-hello-to-magic-link.

        common_models : typing.Optional[typing.Sequence[CommonModelScopesBodyRequest]]
            An array of objects to specify the models and fields that will be disabled for a given Linked Account. Each object uses model_id, enabled_actions, and disabled_fields to specify the model, method, and fields that are scoped for a given Linked Account.

        category_common_model_scopes : typing.Optional[typing.Dict[str, typing.Optional[typing.Sequence[IndividualCommonModelScopeDeserializerRequest]]]]
            When creating a Link Token, you can set permissions for Common Models that will apply to the account that is going to be linked. Any model or field not specified in link token payload will default to existing settings.

        language : typing.Optional[EndUserDetailsRequestLanguage]
            The following subset of IETF language tags can be used to configure localization.

            * `en` - en
            * `de` - de

        are_syncs_disabled : typing.Optional[bool]
            The boolean that indicates whether initial, periodic, and force syncs will be disabled.

        integration_specific_config : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A JSON object containing integration-specific configuration options.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LinkToken


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.crm import CategoriesEnum

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.link_token.create(
                end_user_email_address="example@gmail.com",
                end_user_organization_name="Test Organization",
                end_user_origin_id="12345",
                categories=[CategoriesEnum.HRIS, CategoriesEnum.ATS],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            end_user_email_address=end_user_email_address,
            end_user_organization_name=end_user_organization_name,
            end_user_origin_id=end_user_origin_id,
            categories=categories,
            integration=integration,
            link_expiry_mins=link_expiry_mins,
            should_create_magic_link_url=should_create_magic_link_url,
            hide_admin_magic_link=hide_admin_magic_link,
            common_models=common_models,
            category_common_model_scopes=category_common_model_scopes,
            language=language,
            are_syncs_disabled=are_syncs_disabled,
            integration_specific_config=integration_specific_config,
            request_options=request_options,
        )
        return _response.data
