# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.meta_response import MetaResponse
from ...types.opportunity import Opportunity
from ...types.opportunity_request import OpportunityRequest
from ...types.opportunity_response import OpportunityResponse
from ...types.paginated_opportunity_list import PaginatedOpportunityList
from ...types.paginated_remote_field_class_list import PaginatedRemoteFieldClassList
from ...types.patched_opportunity_request import PatchedOpportunityRequest
from .raw_client import AsyncRawOpportunitiesClient, RawOpportunitiesClient
from .types.opportunities_list_request_expand import OpportunitiesListRequestExpand
from .types.opportunities_list_request_status import OpportunitiesListRequestStatus
from .types.opportunities_retrieve_request_expand import OpportunitiesRetrieveRequestExpand

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OpportunitiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOpportunitiesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawOpportunitiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOpportunitiesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        account_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[OpportunitiesListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        owner_id: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        remote_created_after: typing.Optional[dt.datetime] = None,
        remote_fields: typing.Optional[typing.Literal["status"]] = None,
        remote_id: typing.Optional[str] = None,
        show_enum_origins: typing.Optional[typing.Literal["status"]] = None,
        stage_id: typing.Optional[str] = None,
        status: typing.Optional[OpportunitiesListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedOpportunityList:
        """
        Returns a list of `Opportunity` objects.

        Parameters
        ----------
        account_id : typing.Optional[str]
            If provided, will only return opportunities with this account.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[OpportunitiesListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        owner_id : typing.Optional[str]
            If provided, will only return opportunities with this owner.

        page_size : typing.Optional[int]
            Number of results to return per page.

        remote_created_after : typing.Optional[dt.datetime]
            If provided, will only return opportunities created in the third party platform after this datetime.

        remote_fields : typing.Optional[typing.Literal["status"]]
            Deprecated. Use show_enum_origins.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        show_enum_origins : typing.Optional[typing.Literal["status"]]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        stage_id : typing.Optional[str]
            If provided, will only return opportunities with this stage.

        status : typing.Optional[OpportunitiesListRequestStatus]
            If provided, will only return opportunities with this status. Options: ('OPEN', 'WON', 'LOST')

            * `OPEN` - OPEN
            * `WON` - WON
            * `LOST` - LOST

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedOpportunityList


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.opportunities.list(
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
        )
        """
        _response = self._raw_client.list(
            account_id=account_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            owner_id=owner_id,
            page_size=page_size,
            remote_created_after=remote_created_after,
            remote_fields=remote_fields,
            remote_id=remote_id,
            show_enum_origins=show_enum_origins,
            stage_id=stage_id,
            status=status,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        model: OpportunityRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OpportunityResponse:
        """
        Creates an `Opportunity` object with the given values.

        Parameters
        ----------
        model : OpportunityRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OpportunityResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.crm import OpportunityRequest

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.opportunities.create(
            model=OpportunityRequest(),
        )
        """
        _response = self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[OpportunitiesRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        remote_fields: typing.Optional[typing.Literal["status"]] = None,
        show_enum_origins: typing.Optional[typing.Literal["status"]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Opportunity:
        """
        Returns an `Opportunity` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[OpportunitiesRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        remote_fields : typing.Optional[typing.Literal["status"]]
            Deprecated. Use show_enum_origins.

        show_enum_origins : typing.Optional[typing.Literal["status"]]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Opportunity


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.opportunities.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            remote_fields=remote_fields,
            show_enum_origins=show_enum_origins,
            request_options=request_options,
        )
        return _response.data

    def partial_update(
        self,
        id: str,
        *,
        model: PatchedOpportunityRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OpportunityResponse:
        """
        Updates an `Opportunity` object with the given `id`.

        Parameters
        ----------
        id : str

        model : PatchedOpportunityRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OpportunityResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.crm import PatchedOpportunityRequest

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.opportunities.partial_update(
            id="id",
            model=PatchedOpportunityRequest(),
        )
        """
        _response = self._raw_client.partial_update(
            id, model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    def meta_patch_retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `Opportunity` PATCHs.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.opportunities.meta_patch_retrieve(
            id="id",
        )
        """
        _response = self._raw_client.meta_patch_retrieve(id, request_options=request_options)
        return _response.data

    def meta_post_retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `Opportunity` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.opportunities.meta_post_retrieve()
        """
        _response = self._raw_client.meta_post_retrieve(request_options=request_options)
        return _response.data

    def remote_field_classes_list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        is_common_model_field: typing.Optional[bool] = None,
        is_custom: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedRemoteFieldClassList:
        """
        Returns a list of `RemoteFieldClass` objects.

        Parameters
        ----------
        cursor : typing.Optional[str]
            The pagination cursor value.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        is_common_model_field : typing.Optional[bool]
            If provided, will only return remote field classes with this is_common_model_field value

        is_custom : typing.Optional[bool]
            If provided, will only return remote fields classes with this is_custom value

        page_size : typing.Optional[int]
            Number of results to return per page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedRemoteFieldClassList


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.crm.opportunities.remote_field_classes_list(
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
        )
        """
        _response = self._raw_client.remote_field_classes_list(
            cursor=cursor,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            is_common_model_field=is_common_model_field,
            is_custom=is_custom,
            page_size=page_size,
            request_options=request_options,
        )
        return _response.data


class AsyncOpportunitiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOpportunitiesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOpportunitiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOpportunitiesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        account_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[OpportunitiesListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        owner_id: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        remote_created_after: typing.Optional[dt.datetime] = None,
        remote_fields: typing.Optional[typing.Literal["status"]] = None,
        remote_id: typing.Optional[str] = None,
        show_enum_origins: typing.Optional[typing.Literal["status"]] = None,
        stage_id: typing.Optional[str] = None,
        status: typing.Optional[OpportunitiesListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedOpportunityList:
        """
        Returns a list of `Opportunity` objects.

        Parameters
        ----------
        account_id : typing.Optional[str]
            If provided, will only return opportunities with this account.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[OpportunitiesListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        owner_id : typing.Optional[str]
            If provided, will only return opportunities with this owner.

        page_size : typing.Optional[int]
            Number of results to return per page.

        remote_created_after : typing.Optional[dt.datetime]
            If provided, will only return opportunities created in the third party platform after this datetime.

        remote_fields : typing.Optional[typing.Literal["status"]]
            Deprecated. Use show_enum_origins.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        show_enum_origins : typing.Optional[typing.Literal["status"]]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        stage_id : typing.Optional[str]
            If provided, will only return opportunities with this stage.

        status : typing.Optional[OpportunitiesListRequestStatus]
            If provided, will only return opportunities with this status. Options: ('OPEN', 'WON', 'LOST')

            * `OPEN` - OPEN
            * `WON` - WON
            * `LOST` - LOST

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedOpportunityList


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.opportunities.list(
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            account_id=account_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            owner_id=owner_id,
            page_size=page_size,
            remote_created_after=remote_created_after,
            remote_fields=remote_fields,
            remote_id=remote_id,
            show_enum_origins=show_enum_origins,
            stage_id=stage_id,
            status=status,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        model: OpportunityRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OpportunityResponse:
        """
        Creates an `Opportunity` object with the given values.

        Parameters
        ----------
        model : OpportunityRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OpportunityResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.crm import OpportunityRequest

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.opportunities.create(
                model=OpportunityRequest(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[OpportunitiesRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        remote_fields: typing.Optional[typing.Literal["status"]] = None,
        show_enum_origins: typing.Optional[typing.Literal["status"]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Opportunity:
        """
        Returns an `Opportunity` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[OpportunitiesRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        remote_fields : typing.Optional[typing.Literal["status"]]
            Deprecated. Use show_enum_origins.

        show_enum_origins : typing.Optional[typing.Literal["status"]]
            A comma separated list of enum field names for which you'd like the original values to be returned, instead of Merge's normalized enum values. [Learn more](https://help.merge.dev/en/articles/8950958-show_enum_origins-query-parameter)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Opportunity


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.opportunities.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            remote_fields=remote_fields,
            show_enum_origins=show_enum_origins,
            request_options=request_options,
        )
        return _response.data

    async def partial_update(
        self,
        id: str,
        *,
        model: PatchedOpportunityRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OpportunityResponse:
        """
        Updates an `Opportunity` object with the given `id`.

        Parameters
        ----------
        id : str

        model : PatchedOpportunityRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OpportunityResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.crm import PatchedOpportunityRequest

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.opportunities.partial_update(
                id="id",
                model=PatchedOpportunityRequest(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.partial_update(
            id, model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    async def meta_patch_retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MetaResponse:
        """
        Returns metadata for `Opportunity` PATCHs.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.opportunities.meta_patch_retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.meta_patch_retrieve(id, request_options=request_options)
        return _response.data

    async def meta_post_retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `Opportunity` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.opportunities.meta_post_retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.meta_post_retrieve(request_options=request_options)
        return _response.data

    async def remote_field_classes_list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_remote_fields: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        is_common_model_field: typing.Optional[bool] = None,
        is_custom: typing.Optional[bool] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedRemoteFieldClassList:
        """
        Returns a list of `RemoteFieldClass` objects.

        Parameters
        ----------
        cursor : typing.Optional[str]
            The pagination cursor value.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_remote_fields : typing.Optional[bool]
            Whether to include all remote fields, including fields that Merge did not map to common models, in a normalized format.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        is_common_model_field : typing.Optional[bool]
            If provided, will only return remote field classes with this is_common_model_field value

        is_custom : typing.Optional[bool]
            If provided, will only return remote fields classes with this is_custom value

        page_size : typing.Optional[int]
            Number of results to return per page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedRemoteFieldClassList


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.crm.opportunities.remote_field_classes_list(
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.remote_field_classes_list(
            cursor=cursor,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_remote_fields=include_remote_fields,
            include_shell_data=include_shell_data,
            is_common_model_field=is_common_model_field,
            is_custom=is_custom,
            page_size=page_size,
            request_options=request_options,
        )
        return _response.data
