# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .address_request import AddressRequest
from .contact_request_account import ContactRequestAccount
from .contact_request_owner import ContactRequestOwner
from .email_address_request import EmailAddressRequest
from .phone_number_request import PhoneNumberRequest
from .remote_field_request import RemoteFieldRequest


class ContactRequest(UncheckedBaseModel):
    """
    # The Contact Object
    ### Description
    The `Contact` object is used to represent an existing point of contact at a company in a CRM system.
    ### Usage Example
    TODO
    """

    first_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contact's first name.
    """

    last_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contact's last name.
    """

    account: typing.Optional[ContactRequestAccount] = pydantic.Field(default=None)
    """
    The contact's account.
    """

    owner: typing.Optional[ContactRequestOwner] = pydantic.Field(default=None)
    """
    The contact's owner.
    """

    addresses: typing.Optional[typing.List[AddressRequest]] = None
    email_addresses: typing.Optional[typing.List[EmailAddressRequest]] = None
    phone_numbers: typing.Optional[typing.List[PhoneNumberRequest]] = None
    last_activity_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the contact's last activity occurred.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_fields: typing.Optional[typing.List[RemoteFieldRequest]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
