# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .engagement_request_account import EngagementRequestAccount
from .engagement_request_contacts_item import EngagementRequestContactsItem
from .engagement_request_direction import EngagementRequestDirection
from .engagement_request_engagement_type import EngagementRequestEngagementType
from .engagement_request_owner import EngagementRequestOwner
from .remote_field_request import RemoteFieldRequest


class EngagementRequest(UncheckedBaseModel):
    """
    # The Engagement Object
    ### Description
    The `Engagement` object is used to represent an interaction noted in a CRM system.
    ### Usage Example
    TODO
    """

    owner: typing.Optional[EngagementRequestOwner] = pydantic.Field(default=None)
    """
    The engagement's owner.
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    The engagement's content.
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The engagement's subject.
    """

    direction: typing.Optional[EngagementRequestDirection] = pydantic.Field(default=None)
    """
    The engagement's direction.
    
    * `INBOUND` - INBOUND
    * `OUTBOUND` - OUTBOUND
    """

    engagement_type: typing.Optional[EngagementRequestEngagementType] = pydantic.Field(default=None)
    """
    The engagement type of the engagement.
    """

    start_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time at which the engagement started.
    """

    end_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time at which the engagement ended.
    """

    account: typing.Optional[EngagementRequestAccount] = pydantic.Field(default=None)
    """
    The account of the engagement.
    """

    contacts: typing.Optional[typing.List[typing.Optional[EngagementRequestContactsItem]]] = None
    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_fields: typing.Optional[typing.List[RemoteFieldRequest]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
