# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .engagement_type_activity_type import EngagementTypeActivityType
from .remote_field import RemoteField


class EngagementType(UncheckedBaseModel):
    """
    # The Engagement Type Object
    ### Description
    The `Engagement Type` object is used to represent an interaction activity. A given `Engagement` typically has an `Engagement Type` object represented in the engagement_type field.
    ### Usage Example
    TODO
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    activity_type: typing.Optional[EngagementTypeActivityType] = pydantic.Field(default=None)
    """
    The engagement type's activity type.
    
    * `CALL` - CALL
    * `MEETING` - MEETING
    * `EMAIL` - EMAIL
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The engagement type's name.
    """

    remote_fields: typing.Optional[typing.List[RemoteField]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
