# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .address_request import AddressRequest
from .remote_field_request import RemoteFieldRequest


class PatchedAccountRequest(UncheckedBaseModel):
    """
    # The Account Object
    ### Description
    The `Account` object is used to represent a company in a CRM system.
    ### Usage Example
    TODO
    """

    owner: typing.Optional[str] = pydantic.Field(default=None)
    """
    The account's owner.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The account's name.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The account's description.
    """

    industry: typing.Optional[str] = pydantic.Field(default=None)
    """
    The account's industry.
    """

    website: typing.Optional[str] = pydantic.Field(default=None)
    """
    The account's website.
    """

    number_of_employees: typing.Optional[int] = pydantic.Field(default=None)
    """
    The account's number of employees.
    """

    addresses: typing.Optional[typing.List[AddressRequest]] = None
    last_activity_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The last date (either most recent or furthest in the future) of when an activity occurs in an account.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_fields: typing.Optional[typing.List[RemoteFieldRequest]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
