# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .patched_opportunity_request_status import PatchedOpportunityRequestStatus
from .remote_field_request import RemoteFieldRequest


class PatchedOpportunityRequest(UncheckedBaseModel):
    """
    # The Opportunity Object
    ### Description
    The `Opportunity` object is used to represent a deal opportunity in a CRM system.
    ### Usage Example
    TODO
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The opportunity's name.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The opportunity's description.
    """

    amount: typing.Optional[int] = pydantic.Field(default=None)
    """
    The opportunity's amount.
    """

    owner: typing.Optional[str] = pydantic.Field(default=None)
    """
    The opportunity's owner.
    """

    account: typing.Optional[str] = pydantic.Field(default=None)
    """
    The account of the opportunity.
    """

    stage: typing.Optional[str] = pydantic.Field(default=None)
    """
    The stage of the opportunity.
    """

    status: typing.Optional[PatchedOpportunityRequestStatus] = pydantic.Field(default=None)
    """
    The opportunity's status.
    
    * `OPEN` - OPEN
    * `WON` - WON
    * `LOST` - LOST
    """

    last_activity_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the opportunity's last activity occurred.
    """

    close_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the opportunity was closed.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_fields: typing.Optional[typing.List[RemoteFieldRequest]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
